import sqlalchemy as sa

from mail.python.theatre.stages.bucket_holder.interactions.db.meta import BucketsMetainfo, BucketsTable, WorkersTable


def get_buckets_metainfo():
    metadata = sa.MetaData(schema='buckets')
    return BucketsMetainfo(
        metadata=metadata,
        t_workers=WorkersTable.default(metadata=metadata),
        t_buckets=BucketsTable(
            'buckets',
            metadata,
            sa.Column('bucket_id', sa.Text()),
            sa.Column('worker', sa.Text()),
            sa.Column('heartbeat', sa.DateTime(timezone=True)),
        ),
    )
