import logging

log = logging.getLogger(__name__)


class SignalHistory:
    def __init__(self, min_limit, max_limit):
        self.window = []
        self.cur_logical_time = 0

        self.min_limit = min_limit
        self.max_limit = max_limit
        self.window_size = 7
        self.window_limit = 3
        # this guarantees that worker set can't be overloaded and underloaded at the same time:
        assert 2 * (self.window_limit + 1) > self.window_size
        assert self.min_limit < self.max_limit

    def update_history(self, load_value):
        self.window.append(load_value)
        if len(self.window) > self.window_size:
            self.window = self.window[1:]

    def is_overloaded(self):
        return sum(1 for i in self.window if i is not None
                   and i > self.max_limit) > self.window_limit

    def is_underloaded(self):
        return sum(1 for i in self.window if i is not None
                   and i < self.min_limit) > self.window_limit
