import ujson
from aiopg.sa import Engine

from aiohttp.web_response import json_response
from mail.python.theatre.stages.bucket_holder.interactions.db.meta import BucketsMetainfo
from mail.python.theatre.stages.bucket_holder.roles.director import Director as DirectorBase
from ora2pg.app import TransferApp
from mail.husky.stages.worker.roles.shard_processor import ShardProcessor
from mail.python.theatre.stages.bucket_holder.typing import BucketId, get_shard_id
from ..settings.app import Settings


class Director(DirectorBase):
    def __init__(
            self,
            pg: Engine,
            settings: Settings,
            worker_name: str,
            husky_cluster: str,
            transfer_app: TransferApp,
            db_meta: BucketsMetainfo = None,
    ):
        async def factory(bucket_id: BucketId):
            shard_id = get_shard_id(bucket_id)
            return await ShardProcessor.async_init(transfer_app, pg, shard_id, husky_cluster, settings.shard_processor)
        super().__init__(pg=pg, worker_name=worker_name, factory=factory, settings=settings, db_meta=db_meta)

    async def unistat_handler(self, _):
        return json_response(self.metrics(), dumps=ujson.dumps)
