from typing import Callable

from mail.husky.stages.worker.interactions.db.huskydb import HuskydbTransfer
from mail.husky.stages.worker.settings.shard_workload_updater import ShardWorkloadUpdaterSettings
from mail.python.theatre.roles import Cron


class ShardWorkloadUpdater(Cron):
    def __init__(self,
                 shard_id: int,
                 default_max_workers: int,
                 huskydb: HuskydbTransfer,
                 settings: ShardWorkloadUpdaterSettings,
                 set_max_workers: Callable[[int], None]) -> None:
        self.shard_id = shard_id
        self.default_max_workers = default_max_workers
        self.huskydb = huskydb
        self.settings = settings
        self.set_max_workers = set_max_workers

        super().__init__(job=self.update_max_workers, run_every=settings.cron.run_every)

    async def get_max_workers(self) -> int:
        max_workers = await self.huskydb.get_max_workers_by_shard_id(self.shard_id)
        return max_workers if max_workers is not None else self.default_max_workers

    async def update_max_workers(self) -> None:
        self.set_max_workers(await self.get_max_workers())
