from datetime import timedelta

from mail.python.theatre.app.settings import CronSettings, SettingsNode


class TaskDispatcherSettings(SettingsNode):
    worker_cnt = 5
    chunk_size = 20
    max_queue_size = 50
    cron = CronSettings(run_every=timedelta(seconds=2))

    def devpack(self):
        self.worker_cnt = 2
        self.cron = CronSettings(run_every=timedelta(milliseconds=100))
