from dataclasses import dataclass, fields


@dataclass
class MapDataclass:
    @classmethod
    def map(cls, f, *objs):
        """Applies function `f` to every field of dataclass objects, creates new dataclass object"""
        return cls(
            **{
                field.name: f(*[obj.__dict__[field.name] for obj in objs])
                for field in fields(cls)
            }
        )
