OWNER(
    kremenkov
    g:mail
)

PY3_LIBRARY(husky-worker-lib)

PY_SRCS(
    run.py

    interactions/db/__init__.py
    interactions/db/huskydb.py
    interactions/db/meta.py
    interactions/yasm_adaptor.py

    logic/signal_history.py

    roles/buckets_provider.py
    roles/director.py
    roles/load_regulator.py
    roles/shard_processor.py
    roles/shard_workload_updater.py
    roles/task_dispatcher.py

    settings/app.py
    settings/bucket_holder.py
    settings/buckets_provider.py
    settings/load_regulator.py
    settings/log.py
    settings/shard_processor.py
    settings/shard_workload_updater.py
    settings/task_dispatcher.py

    util/map_dataclass.py
)


RESOURCE_FILES(
    mail/husky/stages/worker/interactions/db/huskydb.sql
)

PEERDIR(
    mail/husky
    mail/pg/huskydb/settings

    mail/python/theatre
    mail/python/theatre/app
    mail/python/theatre/stages
    mail/python/theatre/stages/bucket_holder

    contrib/python/aiohttp
    contrib/python/aiopg
    contrib/python/click
    contrib/python/psutil
    contrib/python/ujson
    contrib/python/uvloop
)

END()

RECURSE_FOR_TESTS(
    logic/tests
    util/tests
    interactions/db/tests
)
