PY3TEST()

OWNER(
    kremenkov
    g:mail
)

SIZE(MEDIUM)

IF (SANITIZER_TYPE)
    # XXX: Sanitizer usage for pure-python projects is useless
    TAG(ya:not_autocheck)
ENDIF()

TEST_SRCS(
    steps/__init__.py

    steps/common.py
    steps/compare_users.py
    steps/cut_firstlines.py
    steps/filters.py
    steps/husky_api.py
    steps/identical.py
    steps/inherit.py
    steps/instant_delete_user_combos.py
    steps/instant_delete_user.py
    steps/mdb.py
    steps/scripts.py
    steps/shiva.py
    steps/shards.py
    steps/tasks.py
    steps/transfer.py

    conftest.py
    step_types_defs.py
    test_features.py
)

DATA(
    arcadia/mail/husky/tests/integration/features
)

FORK_TESTS()
SPLIT_FACTOR(2)

RESOURCE_FILES(
    mail/husky/tests/integration/steps/cut_firstlines.sql
    mail/husky/tests/integration/steps/common.sql
    mail/husky/tests/integration/steps/instant_delete_user.sql
    mail/husky/tests/integration/steps/shards.sql
    mail/husky/tests/integration/steps/mdb.sql
    mail/husky/tests/integration/steps/shiva.sql
    mail/husky/tests/integration/steps/tasks.sql
    mail/husky/tests/integration/steps/transfer.sql
)

PEERDIR(
    contrib/python/parse
    contrib/python/parse-type

    contrib/python/PyHamcrest
    contrib/python/pytest-bdd
    contrib/python/retry
    library/python/resource

    mail/devpack/components/tvmtool
    mail/devpack/lib
    mail/devpack/tests/helpers
    mail/docker_tests
    mail/pypg
    mail/pg/mdb/tests/tools

    mail/husky/devpack
    mail/husky/husky/types
    mail/shiva/devpack
    mail/york/devpack
)

DEPENDS(
    mail/sharpei/bin
    mail/husky/bin/api
    mail/husky/bin/worker
    mail/shiva/bin
    mail/york/bin
)

END()
