PY3_LIBRARY()

OWNER(
    kremenkov
    g:mail
)

PY_SRCS(
    husky/__init__.py
    husky/api.py
    husky/api_queries.py
    husky/app_gunicorn.py
    husky/config.py
    husky/husky_subproc.py
    husky/sharddb.py

    husky/tasks/__init__.py
    husky/tasks/apply_migrations.py
    husky/tasks/base.py
    husky/tasks/clone_user.py
    husky/tasks/cut_firstlines.py
    husky/tasks/delete_mail_user.py
    husky/tasks/delete_shard_user.py
    husky/tasks/errors.py
    husky/tasks/move_messages_to_tabs.py
    husky/tasks/put_letter.py
    husky/tasks/queries.py
    husky/tasks/runner.py
    husky/tasks/transfer.py
    husky/tasks/transfer_from_backup.py
    husky/tasks/transfer_market_crm.py
    husky/tasks/unlabel_messages.py

    husky/tasks/mixin/__init__.py
    husky/tasks/mixin/shard_resolver.py

    husky/web_tools/__init__.py
    husky/web_tools/json_helpers.py
    husky/web_tools/middleware.py
)

PEERDIR(
    infra/yasm/yasmapi
    contrib/python/ipython
    contrib/python/gunicorn
    contrib/python/psycopg2
    contrib/python/dateutil
    # HuskyAPI
    contrib/python/Werkzeug

    mail/pypg
    mail/pg/mdb/python
    mail/transfer
    mail/python/tvm_requests

    mail/husky/husky/types
)

RESOURCE_FILES(
    mail/husky/husky/api_queries.sql
    mail/husky/husky/sharddb.sql
    mail/husky/husky/tasks/cut_firstlines.sql
    mail/husky/husky/tasks/move_messages_to_tabs.sql
    mail/husky/husky/tasks/queries.sql
    mail/husky/husky/tasks/unlabel_messages.sql

    mail/husky/husky/tasks/vcard_format.json
)

END()

RECURSE(
    bin
    dbstat
    devpack
    husky/types
    husky/tasks/tests/helpers
    stages/worker
)

RECURSE_FOR_TESTS(
    tests
    husky/tests
    husky/tasks/tests
    husky/web_tools/tests
)
