#include <ads/bsyeti/libs/catalogia/categorizer.h>
#include <util/string/join.h>
#include <mail/so/libs/jniwrapper_base/jniwrapper_base.h> // for ProcessJniWrapperException
#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_writer.h>

extern "C"
int CatalogiaApplierCreateInstance(
        const char* config Y_DECLARE_UNUSED,
        void** out)
{
    try {
        NBSYeti::NProto::TCatalogiaSettings::TNeuralSettings settings;
        settings.SetModelPath("./catalogia_neural_data/model");
        settings.SetCategoriesPath("./catalogia_neural_data/categories");
        auto categorizer = NBSYeti::NCatalogia::CreateNeuralCategorizer(settings);
        *out = categorizer.Release();
        return 0;
    } catch (...) {
        return NJniWrapper::ProcessJniWrapperException((char**) (void*)out);
    }
}

extern "C"
void CatalogiaApplierDestroyInstance(void* categorizer) {
    delete static_cast<NBSYeti::NCatalogia::ICategorizer*>(categorizer);
}

extern "C"
int CatalogiaApplierGetCategories(
    void* instance,
    const char* uri Y_DECLARE_UNUSED,
    const char* metainfo Y_DECLARE_UNUSED,
    void* data,
    size_t size,
    void** out)
{
    try {
        auto categorizer = static_cast<NBSYeti::NCatalogia::ICategorizer*>(instance);
        TStringBuf requestText(static_cast<const char*>(data), size);
        NJson::TJsonValue json = NJson::ReadJsonFastTree(requestText);
        const auto& jsonMap = json.GetMapSafe();
        TString result;
        TStringOutput stream(result);
        NJson::TJsonWriter jsonWriter(&stream, false);
        jsonWriter.OpenMap();
        auto bulkRequest = NBSYeti::NCatalogia::ICategorizer::TBulkRequest{};
        for (const auto& item : jsonMap.at("requests").GetArraySafe()) {
            bulkRequest.clear();
            TString request = TString(item.GetStringSafe());
            bulkRequest.push_back({request, {}});
            auto bulkResult = categorizer->Apply(bulkRequest);
            for (const auto& res : bulkResult) {
                jsonWriter.Write(request, JoinSeq(",", res.Categories));
            }
        }
        jsonWriter.CloseMap();
        jsonWriter.Flush();
        *out = strdup(result.c_str());
    } catch (...) {
        return NJniWrapper::ProcessJniWrapperException((char**) (void*)out);
    }
    if (*out) {
        return 0;
    } else {
        return -1;
    }
}

extern "C"
void CatalogiaStrFree(void *s) {
    free(s);
}
