#!/bin/bash
set -exo pipefail

source recommended_java_args.sh
source classpath.sh
source gc_args.sh

export CLASS="ru.yandex.cokemulator.Cokemulator"
export CMDLINE=$BSCONFIG_IDIR/catalogia_cokemulator.conf


LD_LIBRARY_PATH=$JAVA_LD_LIBRARY_PATH LD_PRELOAD=$JAVA_LD_PRELOAD exec \
    $BSCONFIG_IDIR/jdk/bin/java \
    -Dcom.sun.management.jmxremote \
    -Dcom.sun.management.jmxremote.ssl=false \
    -Dcom.sun.management.jmxremote.authenticate=false \
    -Dcom.sun.management.jmxremote.port=$((BSCONFIG_IPORT+8)) \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -Djava.library.path=$BSCONFIG_IDIR/catalogia_wrapper_service \
    -XX:+DisableExplicitGC \
    -verbose:gc \
    $GC_ARGS \
    -Djava.net.preferIPv4Stack=false \
    -Djava.net.preferIPv6Addresses=true \
    -DBSCONFIG_IPORT=$BSCONFIG_IPORT \
    -DBSCONFIG_IHOST=$BSCONFIG_IHOST \
    -DBSCONFIG_INAME=$BSCONFIG_INAME \
    -DBSCONFIG_IDIR=$BSCONFIG_IDIR \
    -DSEARCHMAP=searchmap.txt \
    -cp $CLASSPATH \
    $CLASS $CMDLINE

