package ru.yandex.gate.mail;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.HttpProxyConfigBuilder;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.logger.BackendAccessLoggerConfigDefaults;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.logger.LoggersConfigBuilder;
import ru.yandex.logger.ProxyAccessLoggerConfigDefaults;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class Config extends ImmutableHttpProxyConfig {
    private final ImmutableHttpHostConfig smtpGate;
    private final ImmutableHttpHostConfig blackbox;

    public Config(final IniConfig config) throws ConfigException {
        super(createConfig(config));
        IniConfig database = config.section("smtpgate");
        smtpGate = new HttpHostConfigBuilder(database).build();
        IniConfig blackboxConf = config.section("blackbox");
        blackbox = new HttpHostConfigBuilder(blackboxConf).build();
    }

    private static ImmutableHttpProxyConfig createConfig(final IniConfig ini)
        throws ConfigException
    {
        HttpProxyConfigBuilder config = new HttpProxyConfigBuilder(ini);
        config.name("gate-mail");
        LoggerConfigBuilder loggerConfig =
            new LoggerConfigBuilder(
                BackendAccessLoggerConfigDefaults.INSTANCE);
        loggerConfig.single().logFormat(
            BackendAccessLoggerConfigDefaults.INSTANCE
                .logFormat()
                + ProxyAccessLoggerConfigDefaults.LOG_FORMAT_SUFFIX
                + " %{"
                + SearchProxyAccessLoggerConfigDefaults.HITS_COUNT
                + '}');

        config.loggers().accessLoggers(
            LoggersConfigBuilder.loadLoggers(
                ini.section(LoggersConfigBuilder.ACCESSLOG),
                new PatternMap<>(loggerConfig)));
        return config.build();
    }

    public ImmutableHttpHostConfig smtpGate() {
        return smtpGate;
    }

    public ImmutableHttpHostConfig blackbox() {
        return blackbox;
    }
}
