#!/bin/bash

SERVICE=axis
TARGET_HOST=axis.queue
TARGET_PORT=80
LOCKNAME=axis
CONSUMER_GROUP=IEX_AXIS_CONSUMER

QUEUES=(
    ZOOLOOSER_MAILSEARCH_INSTANCE_1:0-16383
    ZOOLOOSER_MAILSEARCH_INSTANCE_2:16384-32767
    ZOOLOOSER_MAILSEARCH_INSTANCE_3_NEW:32768-49151
    ZOOLOOSER_MAILSEARCH_INSTANCE_4:49152-65533
)

function zk_hostlist() {
    GROUP=$1;
    JSON=$(curl -s api.gencfg.yandex-team.ru/trunk/searcherlookup/groups/$GROUP/instances)
    if [ $? -ne 0 ]; then
        echo "Curl failed"
        return 1;
    fi
    #echo "$JSON" | jq -r '.instances[] | "\(.hostname) \(.port)/\(.port+1)"' | sort
    echo "$JSON" | jq -r '.instances[] | "\(.hbf.interfaces.backbone.hostname) \(.port)/\(.port+1)"' | sort
}

function consumer_hostlist() {
    GROUP=$1;
    #JSON=$(curl -s api.gencfg.yandex-team.ru/trunk/groups/$GROUP/instances)
    JSON=$(curl -s api.gencfg.yandex-team.ru/trunk/searcherlookup/groups/$GROUP/instances)
    if [ $? -ne 0 ]; then
        echo "Curl failed"
        return 1;
    fi
    #echo "$JSON" | jq -r '.instances[] | "\(.hostname) \(.dc)"' | sort | awk '

    echo "$JSON" | jq -r '.instances[] | "\(.hbf.interfaces.backbone.hostname) \(.dc)"' | sort | awk '
    {
        count++;
        if ($2 in dcs) {
            dcHostCount[$2]++;
        } else {
            dcHostCount[$2] = 0;
        };
        dcs[$2] = $2;
        hosts[$2, dcHostCount[$2]] = $1;
    }END{
        dcCount = asorti(dcs);
        for (i = 0; i < count; i++) {
            dc = dcs[(i % dcCount) + 1];
            ptr=int(perDcPtr[dc]++);
            print hosts[dc, ptr];
        }
    }'
}

CONSUMER_HOSTS=$(consumer_hostlist $CONSUMER_GROUP)
if [ $? -ne 0 ]; then
    echo "Can't obtain hostlist for group $group"
    exit 1
fi

for q in ${QUEUES[@]}; do
    arr=(${q//:/ })
    group=${arr[0]}
    shards=${arr[1]}
#    echo $group"@"$shards
    hostlist=$(zk_hostlist $group)
    if [ $? -ne 0 ]; then
        echo "Can't obtain hostlist for group $group"
        exit 1
    fi
    hosts=$(echo -e "$hostlist" | cut -d ' ' -f 1)
    ports=$(echo $hostlist | cut -d ' ' -f 2 | head -1)

#    echo $shards
    arr=(${shards//-/ })
    MIN_SHARD=${arr[0]}
#    echo $MIN_SHARD
    MAX_SHARD=${arr[1]}
    if [ -z "$MAX_SHARD" ]; then
        MAX_SHARD=$MIN_SHARD
    fi
    SHARDS=$((MAX_SHARD-MIN_SHARD+1))
    (
        ZK_PORTS=$ports \
        ZK_HOSTS=$hosts \
        TARGET_HOST=$TARGET_HOST \
        TARGET_PORT=$TARGET_PORT \
        LOCKNAME=$LOCKNAME \
        SHARDS=$SHARDS \
        FIRST_SHARD=$MIN_SHARD \
        MAX_SHARD=$((MAX_SHARD+1)) \
        SERVICES=$SERVICE \
        SALO_HOSTS=$CONSUMER_HOSTS \
        ./iex_axis_searchmap_generator.sh
    )
done

