#!/bin/bash
source recommended_java_args.sh
source classpath.sh

XMX=$(portoctl get self memory_limit_total)
GB=$((1024*1024*1024))
GB1_5=$((GB + (GB/2)))
XMX=$((XMX-GB1_5))
XMS=$((XMX / 4))

MEM_ARGS="-Xms${XMS} -Xmx${XMX} -Xmn${GB1_5}"
GC_ARGS="-Xgcpolicy:gencon -verbose:gc -Xverbosegclog:/dev/shm/gc#.log,10,10000"

exec $BSCONFIG_IDIR/jdk/bin/java \
    $JAVA_ARGS $MEM_ARGS $GC_ARGS \
    -Djava.library.path=iex_axis_consumer \
    -cp $CLASSPATH \
    ru.yandex.dispatcher.consumer.ConsumerServer -config \
    iex_axis_consumer.conf
