#!/bin/bash

DEFAULT_ZK_HOSTS=(
    queue02d.mail.yandex.net
    queue02e.mail.yandex.net
    queue02f.mail.yandex.net)

DEFAULT_ZK_PORTS=(2221 2222 2223 2224)

DEFAULT_SALO_HOSTS=(
    salo01d.mail.yandex.net
    salo01e.mail.yandex.net
    salo01f.mail.yandex.net
    salo01g.mail.yandex.net
    salo01h.mail.yandex.net)

DEFAULT_LOCKNAME=iex-proxy
DEFAULT_TARGET_HOST=iex-proxy-prod3.n.yandex-team.ru
DEFAULT_TARGET_PORT=80
DEFAULT_TARGET_TIMEOUT=-1
DEFAULT_SERVICES=(opqueue change_log)

DEFAULT_FIRST_SHARD=0
DEFAULT_SHARDS=65534

ZK_HOSTS=(${ZK_HOSTS:-${DEFAULT_ZK_HOSTS[@]}})
>&2 echo Zoolooser cluster hosts:
for x in ${ZK_HOSTS[@]}
do
    >&2 echo $x
done
>&2 echo

ZK_PORTS=(${ZK_PORTS:-${DEFAULT_ZK_PORTS[@]}})
>&2 echo Zoolooser cluster client ports:
for x in ${ZK_PORTS[@]}
do
    >&2 echo $x
done
>&2 echo

SALO_HOSTS=(${SALO_HOSTS:-${DEFAULT_SALO_HOSTS[@]}})
>&2 echo SALO cluster hosts:
for x in ${SALO_HOSTS[@]}
do
    >&2 echo $x
done
>&2 echo

LOCKNAME=${LOCKNAME:-$DEFAULT_LOCKNAME}
>&2 echo Lock name: $LOCKNAME

TARGET_HOST=${TARGET_HOST:-$DEFAULT_TARGET_HOST}
>&2 echo Target host: $TARGET_HOST

>&2 echo Consumer name: $CONSUMER_NAME

TARGET_TIMEOUT=${TARGET_TIMEOUT:-$DEFAULT_TARGET_TIMEOUT}
>&2 echo Target timeout: $TARGET_TIMEOUT

TARGET_PORT=${TARGET_PORT:-$DEFAULT_TARGET_PORT}
>&2 echo Target port: $TARGET_PORT

SERVICES=(${SERVICES:-${DEFAULT_SERVICES[@]}})
>&2 echo Services: ${SERVICES[@]}

FIRST_SHARD=${FIRST_SHARD:-$DEFAULT_FIRST_SHARD}
>&2 echo First shard number: $FIRST_SHARD

SHARDS=${SHARDS:-$DEFAULT_SHARDS}
>&2 echo Shards count: $SHARDS

MAX_SHARD=${MAX_SHARD:-$((FIRST_SHARD + SHARDS))}
>&2 echo Max shard: $MAX_SHARD
>&2 echo

min() {
    test $1 -lt $2 && echo $1 || echo $2
}

# $1 - shards lower bound (inclusive)
# $2 - shards upper bound (exclusive)
# $3 - zookeeper client port
generate_searchmap_for_cluster() {
    shards_count=$(($2 - $1))
    shards_per_salo=$(((shards_count + ${#SALO_HOSTS[@]} - 1) / ${#SALO_HOSTS[@]}))
    for ((i = 0; i < ${#SALO_HOSTS[@]}; ++i))
    do
        first=$((i * shards_per_salo + $1))
        last=$(min $(((i + 1) * shards_per_salo + $1 - 1)) $(($2 - 1)))
        for ((offset = 1; offset >= 0; --offset))
        do
            hostnumber=$((((i + 1) - offset + ${#SALO_HOSTS[@]}) % ${#SALO_HOSTS[@]}))
            for ((svc = 0; svc < ${#SERVICES[@]}; ++svc))
            do
                service=${SERVICES[$svc]}
                echo -n "$service host:${SALO_HOSTS[$hostnumber]},"
                echo -n "target_host:$TARGET_HOST,"
                if [ "$TARGET_TIMEOUT" != "-1" ]; then
                    echo -n "target_timeout:$TARGET_TIMEOUT,"
                fi
                if [ ! -z "$CONSUMER_NAME" ]; then
                    echo -n "consumer_name:$CONSUMER_NAME,"
                fi
                echo -n "json_indexer_port:$TARGET_PORT,"
                echo -n "zk:${ZK_HOSTS[0]}:$3"
                for ((zk = 1; zk < ${#ZK_HOSTS[@]}; ++zk))
                do
                    echo -n "|${ZK_HOSTS[$zk]}:$3"
                done
                echo -n ",lock:perconsumer,lockname:$LOCKNAME$((i + 1))"
                if [ $svc -gt 0 ]
                then
                    echo -n "-$service"
                fi
                echo ",shards:$first-$last"
            done
        done
    done
}

shards_per_cluster=$(((SHARDS + ${#ZK_PORTS[@]} - 1) / ${#ZK_PORTS[@]}))

for ((port = 0; port < ${#ZK_PORTS[@]}; ++port))
do
    start=$(((port) * shards_per_cluster + FIRST_SHARD))
    end=$(min $(((port + 1) * shards_per_cluster + FIRST_SHARD)) $MAX_SHARD)
    echo "# ${ZK_PORTS[$port]} port instance, shards:$start-$((end - 1))"
    generate_searchmap_for_cluster $start $end ${ZK_PORTS[$port]}
    echo
done
