package ru.yandex.iex.proxy;

import org.apache.http.concurrent.FutureCallback;

public abstract class AbstractCallback<T>
        implements FutureCallback<T>
{
    protected final IndexationContext<T> context;

    protected AbstractCallback(final IndexationContext<T> context) {
        this.context = context;
    }

    public IndexationContext<T> context() {
        return this.context;
    }

    @Override
    public void cancelled() {
        this.context.callback().cancelled();
    }

    @Override
    public void failed(final Exception e) {
        this.context.callback().failed(e);
    }
}
