package ru.yandex.iex.proxy;

import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.HttpExceptionConverter;
import ru.yandex.http.util.YandexHttpStatus;

public abstract class AbstractEntityCallback<T extends AbstractEntityContext, D>
    implements FutureCallback<D>
{
    protected T context;

    public AbstractEntityCallback(final T context) {
        this.context = context;
    }

    //public abstract void completed(final Object result);

    @Override
    public void cancelled() {
        this.context.session()
            .logger()
            .warning("Request cancelled: "
                + this.context.session().listener().details());
        context.session().response(YandexHttpStatus.SC_CLIENT_CLOSED_REQUEST);
    }

    @Override
    public void failed(final Exception e) {
        this.context.session()
            .logger()
            .log(Level.WARNING, "Failed to process: "
                + context.humanReadableJson()
                + '\n' + context.session().listener().details()
                + " because of exception", e);
        context.session().handleException(
            HttpExceptionConverter.toHttpException(e));
    }
}
