package ru.yandex.iex.proxy;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

import org.apache.http.HttpStatus;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.iex.proxy.hotelshandlerlegacy.HotelsContext;
import ru.yandex.iex.proxy.tickethandlerlegacy.TicketContext;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;
import ru.yandex.parser.email.types.MessageType;
import ru.yandex.parser.string.CollectionParser;

public abstract class AbstractEntityContext implements AbstractHandlersContext {
    public static final String RFC = "_rfc";
    public static final String UNDEFINED = "undefined";
    private static XTimeUtils.TimeFormat timeFormat =
        new XTimeUtils.TimeRfc3339Format();
    private static XTimeUtils.TimeFormat timeFormatIex =
        new XTimeUtils.TimeIexFormat();
    protected final IexProxy iexProxy;
    protected final Map<?, ?> json;
    protected final ProxySession session;
    private String mid;
    protected Long uid;
    private String email = "";
    private String from = "";
    private String domain = "";
    private Set<MessageType> types = Collections.emptySet();
    private String subject = "";
    private long receivedDate = 0L;

    public AbstractEntityContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws JsonUnexpectedTokenException
    {
        this.iexProxy = iexProxy;
        this.session = session;
        this.json = json;
        try {
            mid = session.params().getString(MailIndexFields.MID);
            uid = session.params().getLong(MailIndexFields.UID);
            receivedDate =
                ValueUtils.asLong(session.params().getString(MailIndexFields.RECEIVED_DATE));
            email = ValueUtils.asString(
                session.params().getString(TicketContext.USER_EMAIL));
            types =
                session.params().get(
                    "types",
                    Collections.emptySet(),
                    new CollectionParser<>(
                        new MessageTypesCodeOrEnumParser(session.logger()),
                        LinkedHashSet::new));
            iexProxy.requestWithTypesParam(types.contains(null));

            subject = session.params().getString("subject", subject);
            if (domain.isEmpty()) {
                from = ValueUtils.asString(
                    session.params().getString(HotelsContext.EMAIL));
                domain = IndexationContext.extractDomain(from);
            }
        } catch (BadRequestException e) {
            session.logger().log(
                Level.SEVERE,
                "Session params getting failed",
                e);
            //throw new BadRequestException("No mid or uid or email found");
            // do not throw exception
            // because many of tests doesn't provide params
        }
    }

    public long getReceivedDate() {
        return receivedDate;
    }

    public String getDomain() {
        return domain;
    }

    public String getMid() {
        return mid;
    }

    @Override
    public String uid() {
        return String.valueOf(uid);
    }

    @Override
    public long prefix() {
        return uid;
    }

    public String getEmail() {
        return email;
    }

    public String getFrom() {
        return from;
    }

    public String getSubject() {
        return subject;
    }

    public Set<MessageType> getTypes() {
        return types;
    }

    @Override
    public IexProxy iexProxy() {
        return iexProxy;
    }

    @Override
    public ProxySession session() {
        return session;
    }

    @Override
    public Map<?, ?> json() {
        return json;
    }

    public void response() {
        session.response(HttpStatus.SC_OK, JsonType.NORMAL.toString(json));
    }

    protected void completeDateAndTime(
        final Map<String, Object> x,
        final String[] dateTimeTz)
    {
        if (dateTimeTz.length != 1 + 2) {
            return;
        }
        final String dateDepOrArr = dateTimeTz[0];
        final String timeDepOrArr = dateTimeTz[1];
        final String tzDepOrArr = dateTimeTz[1 + 1];
        if (x.containsKey(dateDepOrArr)
            && x.containsKey(timeDepOrArr))
        { // date time
            Object date = x.get(dateDepOrArr);
            Object time = x.get(timeDepOrArr);
            try {
                int gtm = XTimeUtils.getDefaultGmtInMinutes();
                if (x.containsKey(tzDepOrArr)) {
                    Object timeZone = x.get(tzDepOrArr);
                    gtm = XRegexpUtils.getGmtInMinutes(
                        ValueUtils.asString(timeZone));
                }
                String datas = ValueUtils.asString(date);
                String times = ValueUtils.asString(time);
                if (!datas.contains(UNDEFINED) && !times.contains(UNDEFINED)) {
                    final String resRfc = timeFormat.getFormatedTime(
                        datas,
                        times,
                        gtm);
                    final String resIex = timeFormatIex.getFormatedTime(
                        datas,
                        times,
                        gtm);
                    x.put(dateDepOrArr + RFC, resRfc);
                    x.put(timeDepOrArr + RFC, resRfc);
                    x.put(dateDepOrArr, resIex);
                    x.put(timeDepOrArr, resIex);
                }
            } catch (JsonUnexpectedTokenException e) {
            }
        }
    }
}

