package ru.yandex.iex.proxy;

import java.util.List;

import ru.yandex.blackbox.BlackboxUserIdType;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;

public class AbstractGetMidsContext extends AbstractContext {
    protected final List<String> mids;

    public AbstractGetMidsContext(
        final ProxySession session,
        final IexProxy iexProxy)
        throws BadRequestException
    {
        super(iexProxy, session);
        this.mids = session.params().getAll("mid");
    }

    @Override
    public boolean prefixUrl() {
        return true;
    }

    @Override
    public BlackboxUserIdType prefixType() {
        return BlackboxUserIdType.UID;
    }

    @Override
    public Long lcn() {
        return null;
    }

    @Override
    public long prefix() {
        return userInfo.uid();
    }

    public List<String> mids() {
        return mids;
    }
}
