package ru.yandex.iex.proxy;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.apache.http.HttpException;

public abstract class AbstractGetMidsHandler<
    T extends AbstractGetMidsContext, E>
    extends AbstractUseredGetHandler<T>
{
    AbstractGetMidsHandler(final IexProxy iexProxy) {
        super(iexProxy);
    }

    protected abstract AbstractFilterSearchCallback<E>
        createFilterSearchCallback(
            final T context,
            final Set<String> mids);

    @Override
    protected void completed(final T context) throws HttpException {
        Set<String> uniqueMids;
        if (context.mids() != null) {
            uniqueMids = new HashSet<>(context.mids());
        } else {
            uniqueMids = Collections.emptySet();
        }
        createFilterSearchCallback(context, uniqueMids)
            .execute();
    }
}

