package ru.yandex.iex.proxy;

import java.util.Map;

import org.apache.http.HttpHost;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.writer.JsonType;

public interface AbstractHandlersContext {
    IexProxy iexProxy();

    ProxySession session();

    long prefix();

    Map<?, ?> json();

    default String uid() {
        return Long.toString(prefix());
    }

    default boolean corp() {
        return BlackboxUserinfo.corp(prefix());
    }

    default String humanReadableJson()  {
        return JsonType.HUMAN_READABLE.toString(json());
    }

    default AsyncClient filterSearchClient() {
        return BlackboxUserinfo.corp(prefix())
            ? iexProxy().corpFilterSearchClient()
            : iexProxy().filterSearchClient();
    }

    default String filterSearchTvm2Ticket() {
        return BlackboxUserinfo.corp(prefix())
            ? iexProxy().corpFilterSearchTvm2Ticket()
            : iexProxy().filterSearchTvm2Ticket();
    }

    default String filterSearchUri() {
        return BlackboxUserinfo.corp(prefix())
            ? iexProxy().corpFilterSearchUri()
            : iexProxy().filterSearchUri();
    }

    default String mailSearchQueueName() {
        return BlackboxUserinfo.corp(prefix())
            ? iexProxy().corpMailSearchQueueName()
            : iexProxy().mailSearchQueueName();
    }

    default HttpHost msalHost() {
        return BlackboxUserinfo.corp(prefix())
            ? iexProxy().corpMsalHost()
            : iexProxy().msalHost();
    }

    default AsyncClient msalClient() {
        return BlackboxUserinfo.corp(prefix())
            ? iexProxy().corpMsalClient()
            : iexProxy().msalClient();
    }
}
