package ru.yandex.iex.proxy;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigBuilder;
import ru.yandex.geocoder.GeocoderConfig;
import ru.yandex.geocoder.GeocoderConfigBuilder;
import ru.yandex.http.config.FilterSearchConfig;
import ru.yandex.http.config.FilterSearchConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigBuilder;
import ru.yandex.iex.proxy.afisha.config.AfishaConfigBuilder;
import ru.yandex.iex.proxy.afisha.config.InterfaceAfishaConfig;
import ru.yandex.iex.proxy.complaints.ComplaintsConfig;
import ru.yandex.iex.proxy.complaints.ComplaintsConfigBuilder;
import ru.yandex.iex.proxy.complaints.Route;
import ru.yandex.iex.proxy.config.SmartObjectConfig;
import ru.yandex.iex.proxy.config.SmartObjectConfigBuilder;
import ru.yandex.iex.proxy.images.ZoraProxyClientConfig;
import ru.yandex.iex.proxy.images.ZoraProxyClientConfigBuilder;
import ru.yandex.iex.proxy.xiva.XivaConfig;
import ru.yandex.iex.proxy.xiva.XivaConfigBuilder;
import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapperConfigBuilder;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.mail.received.ReceivedChainParserConfig;
import ru.yandex.parser.mail.received.ReceivedChainParserConfigBuilder;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveLongValidator;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;
import ru.yandex.stater.StaterConfig;
import ru.yandex.stater.StaterConfigBuilder;

public abstract class AbstractIexProxyConfigBuilder
    <T extends AbstractIexProxyConfigBuilder<T>>
    extends AbstractUniversalSearchProxyConfigBuilder<T>
    implements IexProxyConfig
{
    private static final String POSTPROCESS_SESTION = "postprocess";
    private static final String AXIS_SECTION = "axis";
    private static final String ZORA_PROXY_SECTION = "zoraproxy";
    private static final String TVM2 = "tvm2";
    private static final String STAT = "stat";

    private HttpHostConfigBuilder cokemulatorIexlibConfig;
    private HttpHostConfigBuilder msalConfig;
    private HttpHostConfigBuilder corpMsalConfig;
    private HttpHostConfigBuilder msearchConfig;
    private HttpHostConfigBuilder onlineDBConfig;
    private HttpHostConfigBuilder raspConfig;
    private StaterConfigBuilder raspStaterConfig;
    private HttpHostConfigBuilder refundConfig;
    private HttpHostConfigBuilder marketConfig;
    private HttpHostConfigBuilder bkConfig;
    private HttpHostConfigBuilder mediaConfig;
    private HttpHostConfigBuilder gettextConfig;
    private HttpHostConfigBuilder gatemailConfig;
    private HttpHostConfigBuilder reminderConfig;
    private HttpHostConfigBuilder calendarConfig;
    private HttpHostConfigBuilder calendarToolsConfig;
    private HttpHostConfigBuilder corovaneerConfig;
    private HttpHostConfigBuilder kinopoiskQlConfig;
    private GeocoderConfigBuilder geoSearchConfig;
    private StaterConfigBuilder geoStaterConfig;
    private AfishaConfigBuilder afishaConfig;
    private URIConfigBuilder iexConfig;
    private HttpHostConfigBuilder blackboxConfig;
    private Tvm2ClientConfigBuilder tvm2ClientConfig;
    private HttpHostConfigBuilder corpBlackboxConfig;
    private HttpHostConfigBuilder blackboxDirectConfig;
    private HttpTargetConfigBuilder postProcessConfig;
    private HttpHostConfigBuilder tikaiteConfig;
    private HttpHostConfigBuilder tikaiteMlConfig;
    private HttpHostConfigBuilder mulcagateConfig;
    private ZoraProxyClientConfigBuilder zoraProxyConfig;
    private URIConfigBuilder axisConfig;
    private URIConfigBuilder rcaURIConfig;
    private StaterConfigBuilder rcaStaterConfig;
    private URIConfigBuilder factsExtractURIConfig;
    private FilterSearchConfigBuilder filterSearchConfig;
    private FilterSearchConfigBuilder corpFilterSearchConfig;
    private URIConfigBuilder foldersConfig;
    private URIConfigBuilder corpFoldersConfig;
    private URIConfigBuilder labelsConfig;
    private URIConfigBuilder corpLabelsConfig;
    private URIConfigBuilder attachSidConfig;
    private URIConfigBuilder corpAttachSidConfig;
    private ComplaintsConfigBuilder complaintsConfig;
    private URIConfigBuilder complaintsCoworkersSelectionConfig;
    private URIConfigBuilder sologgerConfig;
    private URIConfigBuilder freemailConfig;
    private URIConfigBuilder settingsApiConfig;
    private URIConfigBuilder corpSettingsApiConfig;
    private IexForwardersConfigBuilder forwardersConfig;
    private Pattern mdbs;
    private Long maxRetries;
    private Long almostAllFactsTimeout;
    private Long factsExtractIndexationWaitTimeout;
    private String factsIndexingQueueName;
    private String slowQueueName;
    private String axisQueueName;
    private String xIndexOperationQueueNameFacts;
    private String xIndexOperationQueueNameBacklog;
    private String xIndexOperationQueueNameUpdate;
    private String mailSearchQueueName;
    private String corpMailSearchQueueName;
    private HttpHostConfigBuilder producerAsyncClientConfig;
    private HttpHostConfigBuilder soProducerConfig;
    private HttpHostConfigBuilder knnConfig;
    private HttpHostConfigBuilder mopsConfig;
    private HttpHostConfigBuilder corpMopsConfig;
    private LoggerConfigBuilder reqresLog;
    private LoggerConfigBuilder sobbYtLog;
    private IniConfig extraSettings;
    private final IniConfig headersSection;
    private final IniConfig headersDomainSection;
    private final IniConfig entitiesSection;
    private final IniConfig postProcessSection;
    private final IniConfig entitiesEmailSection;
    private final IniConfig postProcessEmailSection;
    private final IniConfig entitiesRcptEmailSection;
    private final IniConfig postProcessRcptEmailSection;
    private final IniConfig entitiesRcptUidSection;
    private final IniConfig postProcessRcptUidSection;
    private final IniConfig rcptUidRuleSections;
    private final IniConfig entitiesDomainSection;
    private final IniConfig postProcessDomainSection;
    private final IniConfig rcptUidStoreSignalsSection;
    private IniConfig entitiesTimeStamps;
    private IniConfig urlsWhitelistRegexp;
    private IniConfig mediaFiscalsProperties;
    private IniConfig refundSendersProperties;
    private final Set<String> factNamesToEraseFactData;
    private XivaConfigBuilder xivaConfig;
    private XivaConfigBuilder xivaCorpConfig;
    private SmartObjectConfigBuilder smartObjectConfig;
    private HttpHostConfigBuilder taksaConfig;
    private HttpHostConfigBuilder taksaTestingConfig;
    private HttpHostConfigBuilder neuroHardsConfig;
    private ReceivedChainParserConfigBuilder receivedChainParserConfig;
    private String blackboxTvmClientId;
    private String corpBlackboxTvmClientId;
    private String tikaiteTvmClientId;
    private String unistorageTvmClientId;
    private String geoTvmClientId;
    private String filterSearchTvmClientId;
    private String corpFilterSearchTvmClientId;
    private String foldersTvmClientId;
    private String corpFoldersTvmClientId;
    private String labelsTvmClientId;
    private String corpLabelsTvmClientId;
    private String afishaTvmClientId;
    private String kinopoiskTvmClientId;
    private String attachSidTvmClientId;
    private String corpAttachSidTvmClientId;
    private String taksaTvmClientId;
    private String calendarTvmClientId;
    private String calendarToolsTvmClientId;
    private String corovaneerTvmClientId;
    private String mopsTvmClientId;
    private String corpMopsTvmClientId;
    private String settingsApiTvmClientId;
    private String corpSettingsApiTvmClientId;
    private String soService;
    private boolean enlarge;
    private JniWrapperConfigBuilder unpersonConfig;

    protected AbstractIexProxyConfigBuilder(final IexProxyConfig config) {
        super(config);
        iexConfig = new URIConfigBuilder(config.iexConfig());
        tvm2ClientConfig = new Tvm2ClientConfigBuilder(config.tvm2ClientConfig());
        blackboxConfig = new HttpHostConfigBuilder(config.blackboxConfig());
        corpBlackboxConfig = new HttpHostConfigBuilder(config.corpBlackboxConfig());
        blackboxDirectConfig = new HttpHostConfigBuilder(config.blackboxDirectConfig());
        postProcessConfig = new HttpTargetConfigBuilder(config.postProcessConfig());
        tikaiteConfig = new HttpHostConfigBuilder(config.tikaiteConfig());
        tikaiteMlConfig = new HttpHostConfigBuilder(config.tikaiteMlConfig());
        mulcagateConfig = new HttpHostConfigBuilder(config.mulcagateConfig());
        filterSearchConfig = new FilterSearchConfigBuilder(config.filterSearchConfig());
        corpFilterSearchConfig = new FilterSearchConfigBuilder(config.corpFilterSearchConfig());
        foldersConfig = new URIConfigBuilder(config.foldersConfig());
        corpFoldersConfig = new URIConfigBuilder(config.corpFoldersConfig());
        labelsConfig = new URIConfigBuilder(config.labelsConfig());
        corpLabelsConfig = new URIConfigBuilder(config.corpLabelsConfig());
        attachSidConfig = new URIConfigBuilder(config.attachSidConfig());
        corpAttachSidConfig = new URIConfigBuilder(config.corpAttachSidConfig());
        axisConfig = new URIConfigBuilder(config.axisConfig());
        complaintsConfig = new ComplaintsConfigBuilder(config.complaintsConfig());
        complaintsCoworkersSelectionConfig = new URIConfigBuilder(config.complaintsCoworkersSelectionConfig());
        sologgerConfig = new URIConfigBuilder(config.sologgerConfig());
        freemailConfig = new URIConfigBuilder(config.freemailConfig());
        settingsApiConfig = new URIConfigBuilder(config.settingsApiConfig());
        corpSettingsApiConfig = new URIConfigBuilder(config.corpSettingsApiConfig());
        zoraProxyConfig = new ZoraProxyClientConfigBuilder(config.zoraProxyConfig());

        rcaURIConfig = new URIConfigBuilder(config.rcaURIConfig());
        rcaStaterConfig = new StaterConfigBuilder(config.rcaStaterConfig());
        factsExtractURIConfig = new URIConfigBuilder(config.factsExtractURIConfig());
        mdbs = config.mdbs();
        cokemulatorIexlibConfig = new HttpHostConfigBuilder(config.cokemulatorIexlibConfig());
        msalConfig = new HttpHostConfigBuilder(config.msalConfig());
        corpMsalConfig = new HttpHostConfigBuilder(config.corpMsalConfig());
        raspConfig = new HttpHostConfigBuilder(config.raspConfig());
        raspStaterConfig = new StaterConfigBuilder(config.raspStaterConfig());
        refundConfig = new HttpHostConfigBuilder(config.refundConfig());
        marketConfig = new HttpHostConfigBuilder(config.marketConfig());
        bkConfig = new HttpHostConfigBuilder(config.bkConfig());
        mediaConfig = new HttpHostConfigBuilder(config.mediaConfig());
        gettextConfig = new HttpHostConfigBuilder(config.gettextConfig());
        gatemailConfig = new HttpHostConfigBuilder(config.gatemailConfig());
        calendarConfig = new HttpHostConfigBuilder(config.calendarConfig());
        calendarToolsConfig = new HttpHostConfigBuilder(config.calendarToolsConfig());
        corovaneerConfig = new HttpHostConfigBuilder(config.corovaneerConfig());
        kinopoiskQlConfig = new HttpHostConfigBuilder(config.kinopoiskQlConfig());
        msearchConfig = new HttpHostConfigBuilder(config.msearchConfig());
        onlineDBConfig = new HttpHostConfigBuilder(config.onlineDBConfig());
        reminderConfig = new HttpHostConfigBuilder(config.reminderConfig());
        geoSearchConfig = new GeocoderConfigBuilder(config.geoSearchConfig());
        geoStaterConfig = new StaterConfigBuilder(config.geoStaterConfig());
        afishaConfig = new AfishaConfigBuilder(config.afishaConfig());
        reqresLog = new LoggerConfigBuilder(config.reqresLog());
        sobbYtLog = new LoggerConfigBuilder(config.sobbYtLog());
        headersSection = config.headersSection();
        headersDomainSection = config.headersDomainSection();
        entitiesSection = config.entitiesSection();
        entitiesEmailSection = config.entitiesEmailSection();
        postProcessSection = config.postProcessSection();
        postProcessEmailSection = config.postProcessEmailSection();
        entitiesRcptEmailSection = config.entitiesRcptEmailSection();
        postProcessRcptEmailSection = config.postProcessRcptEmailSection();
        entitiesRcptUidSection = config.entitiesRcptUidSection();
        postProcessRcptUidSection = config.postProcessRcptUidSection();
        rcptUidRuleSections = config.rcptUidRuleSections();
        entitiesDomainSection = config.entitiesDomainSection();
        postProcessDomainSection = config.postProcessDomainSection();
        rcptUidStoreSignalsSection = config.rcptUidStoreSignalsSection();
        if (config.producerAsyncClientConfig() != null) {
            producerAsyncClientConfig = new HttpHostConfigBuilder(config.producerAsyncClientConfig());
        }
        if (config.soProducerConfig() != null) {
            soProducerConfig = new HttpHostConfigBuilder(config.soProducerConfig());
        }
        knnConfig = new HttpHostConfigBuilder(config.knnConfig());
        smartObjectConfig = new SmartObjectConfigBuilder(config.smartObjectConfig());
        mopsConfig = new HttpHostConfigBuilder(config.mopsConfig());
        corpMopsConfig = new HttpHostConfigBuilder(config.corpMopsConfig());
        factNamesToEraseFactData = config.factNamesToEraseFactData();

        almostAllFactsTimeout(config.almostAllFactsTimeout());
        factsExtractIndexationWaitTimeout(config.factsExtractIndexationWaitTimeout());
        forwardersConfig(config.forwardersConfig());
        xivaConfig = new XivaConfigBuilder(config.xivaConfig());
        xivaCorpConfig = new XivaConfigBuilder(config.xivaCorpConfig());
        taksaConfig = new HttpHostConfigBuilder(config.taksaConfig());
        taksaTestingConfig = new HttpHostConfigBuilder(config.taksaTestingConfig());
        neuroHardsConfig = new HttpHostConfigBuilder(config.neuroHardsConfig());
        receivedChainParserConfig = new ReceivedChainParserConfigBuilder(config.receivedChainParserConfig());
        blackboxTvmClientId = config.blackboxTvmClientId();
        corpBlackboxTvmClientId = config.corpBlackboxTvmClientId();
        tikaiteTvmClientId = config.tikaiteTvmClientId();
        unistorageTvmClientId = config.unistorageTvmClientId();
        geoTvmClientId = config.geoTvmClientId();
        filterSearchTvmClientId = config.filterSearchTvmClientId();
        corpFilterSearchTvmClientId = config.corpFilterSearchTvmClientId();
        foldersTvmClientId = config.foldersTvmClientId();
        corpFoldersTvmClientId = config.corpFoldersTvmClientId();
        labelsTvmClientId = config.labelsTvmClientId();
        corpLabelsTvmClientId = config.corpLabelsTvmClientId();
        afishaTvmClientId = config.afishaTvmClientId();
        kinopoiskTvmClientId = config.kinopoiskTvmClientId();
        attachSidTvmClientId = config.attachSidTvmClientId();
        corpAttachSidTvmClientId = config.corpAttachSidTvmClientId();
        taksaTvmClientId = config.taksaTvmClientId();
        calendarTvmClientId = config.calendarTvmClientId();
        calendarToolsTvmClientId = config.calendarToolsTvmClientId();
        corovaneerTvmClientId = config.corovaneerTvmClientId();
        mopsTvmClientId = config.mopsTvmClientId();
        corpMopsTvmClientId = config.corpMopsTvmClientId();
        enlarge = config.enlarge();
        unpersonConfig(config.unpersonConfig());
    }

    // CSOFF: MethodLength
    protected AbstractIexProxyConfigBuilder(
        final IniConfig config,
        final IexProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        iexConfig = new URIConfigBuilder(config.section("iex"), defaults.iexConfig());
        tvm2ClientConfig = new Tvm2ClientConfigBuilder(config.section(TVM2), defaults.tvm2ClientConfig());
        IniConfig blackboxSection = config.section("blackbox");
        blackboxConfig = new HttpHostConfigBuilder(blackboxSection, defaults.blackboxConfig());
        IniConfig corpBlackboxSection = config.section("corp-blackbox");
        corpBlackboxConfig = new HttpHostConfigBuilder(corpBlackboxSection, defaults.corpBlackboxConfig());
        IniConfig blackboxDirectSection = config.section("blackbox-direct");
        blackboxDirectConfig = new HttpHostConfigBuilder(blackboxDirectSection, defaults.blackboxDirectConfig());
        postProcessConfig = new HttpTargetConfigBuilder(
            config.section(POSTPROCESS_SESTION),
            defaults.postProcessConfig());
        tikaiteConfig = new HttpHostConfigBuilder(config.section("tikaite"), defaults.tikaiteConfig());
        tikaiteMlConfig = new HttpHostConfigBuilder(config.section("tikaite-ml"), defaults.tikaiteMlConfig());
        mulcagateConfig = new HttpHostConfigBuilder(config.section("mulcagate"), defaults.mulcagateConfig());
        axisConfig = new URIConfigBuilder(config.section(AXIS_SECTION), defaults.axisConfig());
        complaintsConfig = new ComplaintsConfigBuilder(config.section("complaints"), defaults.complaintsConfig());
        complaintsCoworkersSelectionConfig = new URIConfigBuilder(
            config.section("complaints-coworkers-selection"),
            defaults.complaintsCoworkersSelectionConfig());
        sologgerConfig = new URIConfigBuilder(config.section("sologger"), defaults.sologgerConfig());
        freemailConfig = new URIConfigBuilder(config.section("freemail"), defaults.freemailConfig());
        settingsApiConfig = new URIConfigBuilder(config.section("settings-api"), defaults.settingsApiConfig());
        corpSettingsApiConfig =
            new URIConfigBuilder(config.section("corp-settings-api"), defaults.corpSettingsApiConfig());
        zoraProxyConfig = new ZoraProxyClientConfigBuilder(
            config.section(ZORA_PROXY_SECTION),
            defaults.zoraProxyConfig());
        IniConfig rcaSection = config.section("rca");
        rcaURIConfig = new URIConfigBuilder(rcaSection, defaults.rcaURIConfig());
        rcaStaterConfig = new StaterConfigBuilder(rcaSection.section(STAT), defaults.rcaStaterConfig());
        factsExtractURIConfig = new URIConfigBuilder(
            config.section("facts-extractor"),
            defaults.factsExtractURIConfig());
        axisQueueName = config.section(AXIS_SECTION).get(
                "queue-name",
                defaults.axisQueueName(),
                NonEmptyValidator.INSTANCE);
        filterSearchConfig = new FilterSearchConfigBuilder(
            config.section("filter-search"),
            defaults.filterSearchConfig());
        corpFilterSearchConfig = new FilterSearchConfigBuilder(
            config.section("corp-filter-search"),
            defaults.corpFilterSearchConfig());
        foldersConfig = new URIConfigBuilder(config.section("folders"), defaults.foldersConfig());
        corpFoldersConfig = new URIConfigBuilder(config.section("corp-folders"), defaults.corpFoldersConfig());
        labelsConfig = new URIConfigBuilder(config.section("labels"), defaults.labelsConfig());
        corpLabelsConfig = new URIConfigBuilder(config.section("corp-labels"), defaults.corpLabelsConfig());
        attachSidConfig = new URIConfigBuilder(config.section("attach-sid"), defaults.attachSidConfig());
        corpAttachSidConfig = new URIConfigBuilder(config.section("corp-attach-sid"), defaults.corpAttachSidConfig());
        IniConfig iexProxyConfig = config.section("iex-proxy");
        mdbs = iexProxyConfig.get("mdbs", defaults.mdbs(), Pattern::compile);
        maxRetries = iexProxyConfig.get("max-retries", defaults.maxRetries(), PositiveLongValidator.INSTANCE);
        almostAllFactsTimeout = iexProxyConfig.get(
            "almost-all-facts-timeout",
            defaults.almostAllFactsTimeout(),
            DurationParser.POSITIVE_LONG);
        factsExtractIndexationWaitTimeout = iexProxyConfig.get(
            "facts-extract-indexation-wait-timeout",
            defaults.factsExtractIndexationWaitTimeout(),
            DurationParser.POSITIVE_LONG);
        if (maxRetries != null) {
            slowQueueName = iexProxyConfig.get("slow-queue-name", defaults.slowQueueName(), NonEmptyValidator.INSTANCE);
        }
        xIndexOperationQueueNameBacklog = iexProxyConfig.get(
            "x-index-operation-queue-backlog",
            defaults.xIndexOperationQueueNameBacklog(),
            NonEmptyValidator.INSTANCE);
        xIndexOperationQueueNameFacts = iexProxyConfig.get(
            "x-index-operation-queue-facts",
            defaults.xIndexOperationQueueNameFacts(),
            NonEmptyValidator.INSTANCE);
        xIndexOperationQueueNameUpdate = iexProxyConfig.get(
            "x-index-operation-queue-update",
            defaults.xIndexOperationQueueNameUpdate(),
            NonEmptyValidator.INSTANCE);
        factsIndexingQueueName = iexProxyConfig.get(
            "facts-indexing-queue-name",
            defaults.factsIndexingQueueName(),
            NonEmptyValidator.INSTANCE);
        if (maxRetries != null || factsIndexingQueueName != null) {
            producerAsyncClientConfig = new HttpHostConfigBuilder(
                config.section("producer-async-client"),
                defaults.producerAsyncClientConfig());
        }

        mailSearchQueueName = iexProxyConfig.get(
            "mail-search-queue",
            defaults.mailSearchQueueName(),
            NonEmptyValidator.INSTANCE);
        corpMailSearchQueueName = iexProxyConfig.get(
            "corp-mail-search-queue",
            defaults.corpMailSearchQueueName(),
            NonEmptyValidator.INSTANCE);

        forwardersConfig = new IexForwardersConfigBuilder(config.sectionOrDefault("forwarders", IniConfig.empty()));

        cokemulatorIexlibConfig = new HttpHostConfigBuilder(
            config.section("cokemulator-iexlib"),
            defaults.cokemulatorIexlibConfig());
        msalConfig = new HttpHostConfigBuilder(config.section("msal"), defaults.msalConfig());
        corpMsalConfig = new HttpHostConfigBuilder(config.section("corp-msal"), defaults.corpMsalConfig());
        IniConfig raspSection = config.section("rasp");
        raspConfig = new HttpHostConfigBuilder(raspSection, defaults.raspConfig());
        raspStaterConfig = new StaterConfigBuilder(raspSection.section(STAT), defaults.raspStaterConfig());
        refundConfig = new HttpHostConfigBuilder(config.section("refund"), defaults.refundConfig());
        marketConfig = new HttpHostConfigBuilder(config.section("market"), defaults.marketConfig());
        bkConfig = new HttpHostConfigBuilder(config.section("bk"), defaults.bkConfig());
        mediaConfig = new HttpHostConfigBuilder(config.section("media"), defaults.mediaConfig());
        gettextConfig = new HttpHostConfigBuilder(config.section("gettext"), defaults.gettextConfig());
        gatemailConfig = new HttpHostConfigBuilder(config.section("gatemail"), defaults.gatemailConfig());
        calendarConfig = new HttpHostConfigBuilder(config.section("calendar"), defaults.calendarConfig());
        calendarToolsConfig = new HttpHostConfigBuilder(
            config.section("calendar-tools"),
            defaults.calendarToolsConfig());
        corovaneerConfig = new HttpHostConfigBuilder(config.section("corovaneer"), defaults.corovaneerConfig());
        kinopoiskQlConfig = new HttpHostConfigBuilder(config.section("kinopoisk"), defaults.kinopoiskQlConfig());
        msearchConfig = new HttpHostConfigBuilder(config.section("msearch"), defaults.msearchConfig());
        onlineDBConfig = new HttpHostConfigBuilder(config.section("online-db"), defaults.onlineDBConfig());
        reminderConfig = new HttpHostConfigBuilder(config.section("reminder"), defaults.reminderConfig());
        IniConfig geoSection = config.section("geo");
        geoSearchConfig = new GeocoderConfigBuilder(geoSection, defaults.geoSearchConfig());
        geoStaterConfig = new StaterConfigBuilder(geoSection.section(STAT), defaults.geoStaterConfig());
        afishaConfig = new AfishaConfigBuilder(config.section("afisha"), defaults.afishaConfig());
        reqresLog = new LoggerConfigBuilder(config.section("reqreslog"), defaults.reqresLog());
        sobbYtLog = new LoggerConfigBuilder(config.section("sobb-yt-log"), defaults.sobbYtLog());
        extraSettings = config.section("extrasettings");
        headersSection = config.section("headers");
        headersDomainSection = config.section("headers_domain");
        entitiesSection = config.section("entities");
        entitiesEmailSection = config.section("entities_email");
        entitiesRcptEmailSection = config.section("entities_rcpt_email");
        postProcessSection = config.section(POSTPROCESS_SESTION);
        postProcessEmailSection = config.section("postprocess_email");
        postProcessRcptEmailSection = config.section("postprocess_rcpt_email");
        entitiesRcptUidSection = config.section("entities_rcpt_uid");
        postProcessRcptUidSection = config.section("postprocess_rcpt_uid");
        rcptUidRuleSections = config.section("rcpt_uid_rule");
        rcptUidStoreSignalsSection = config.section("rcpt_uid_store_signals");
        entitiesDomainSection = config.section("entities_domain");
        postProcessDomainSection = config.section("postprocess_domain");
        entitiesTimeStamps = config.section("entities_actual_timestamps");
        urlsWhitelistRegexp = config.section("urls_whitelilst_regexp");
        mediaFiscalsProperties = config.section("media-fiscal-rules");
        refundSendersProperties = config.section("refund-senders-rules");
        factNamesToEraseFactData = iexProxyConfig.get(
            "fact-names-to-erase-fact-data",
            defaults.factNamesToEraseFactData(),
            new CollectionParser<>(String::trim, HashSet::new));
        xivaConfig = new XivaConfigBuilder(config.section("xiva"), defaults.xivaConfig());
        xivaCorpConfig = new XivaConfigBuilder(config.section("xiva-corp"), defaults.xivaCorpConfig());
        taksaConfig = new HttpHostConfigBuilder(config.section("taksa"), defaults.taksaConfig());
        taksaTestingConfig = new HttpHostConfigBuilder(config.section("taksa-testing"), defaults.taksaTestingConfig());
        neuroHardsConfig = new HttpHostConfigBuilder(config.section("neuro-hards"), defaults.neuroHardsConfig());
        receivedChainParserConfig = new ReceivedChainParserConfigBuilder(
            config.section("received-chain-parser"),
            defaults.receivedChainParserConfig());
        blackboxTvmClientId = config.get(
            "blackbox.tvm-client-id",
            defaults.blackboxTvmClientId(),
            NonEmptyValidator.INSTANCE);
        corpBlackboxTvmClientId = config.get(
            "corp-blackbox.tvm-client-id",
            defaults.corpBlackboxTvmClientId(),
            NonEmptyValidator.INSTANCE);
        tikaiteTvmClientId = config.get(
            "tikaite.tvm-client-id",
            defaults.tikaiteTvmClientId(),
            NonEmptyValidator.INSTANCE);
        unistorageTvmClientId = config.get(
            "tikaite.unistorage-client-id",
            defaults.unistorageTvmClientId(),
            NonEmptyValidator.INSTANCE);
        geoTvmClientId = config.get(
            "geo.tvm-client-id",
            defaults.geoTvmClientId(),
            NonEmptyValidator.INSTANCE);
        filterSearchTvmClientId = config.get(
            "filter-search.tvm-client-id",
            defaults.filterSearchTvmClientId(),
            NonEmptyValidator.INSTANCE);
        corpFilterSearchTvmClientId = config.get(
            "corp-filter-search.tvm-client-id",
            defaults.corpFilterSearchTvmClientId(),
            NonEmptyValidator.INSTANCE);
        foldersTvmClientId = config.get(
            "folders.tvm-client-id",
            defaults.foldersTvmClientId(),
            NonEmptyValidator.INSTANCE);
        corpFoldersTvmClientId = config.get(
            "corp-folders.tvm-client-id",
            defaults.corpFoldersTvmClientId(),
            NonEmptyValidator.INSTANCE);
        labelsTvmClientId = config.get(
            "labels.tvm-client-id",
            defaults.labelsTvmClientId(),
            NonEmptyValidator.INSTANCE);
        corpLabelsTvmClientId = config.get(
            "corp-labels.tvm-client-id",
            defaults.corpLabelsTvmClientId(),
            NonEmptyValidator.INSTANCE);
        afishaTvmClientId = config.get(
            "afisha.tvm-client-id",
            defaults.afishaTvmClientId(),
            NonEmptyValidator.INSTANCE);
        kinopoiskTvmClientId = config.get(
            "kinopoisk.tvm-client-id",
            defaults.kinopoiskTvmClientId(),
            NonEmptyValidator.INSTANCE);
        attachSidTvmClientId = config.get(
            "attach-sid.tvm-client-id",
            defaults.attachSidTvmClientId(),
            NonEmptyValidator.INSTANCE);
        corpAttachSidTvmClientId = config.get(
            "corp-attach-sid.tvm-client-id",
            defaults.corpAttachSidTvmClientId(),
            NonEmptyValidator.INSTANCE);
        taksaTvmClientId = config.get(
            "taksa.tvm-client-id",
            defaults.taksaTvmClientId(),
            NonEmptyValidator.INSTANCE);
        calendarTvmClientId = config.get(
            "calendar.tvm-client-id",
            defaults.calendarTvmClientId(),
            NonEmptyValidator.INSTANCE);
        calendarToolsTvmClientId = config.get(
            "calendar-tools.tvm-client-id",
            defaults.calendarToolsTvmClientId(),
            NonEmptyValidator.INSTANCE);
        corovaneerTvmClientId = config.get(
            "corovaneer.tvm-client-id",
            defaults.corovaneerTvmClientId(),
            NonEmptyValidator.INSTANCE);
        mopsTvmClientId = config.get(
            "mops.tvm-client-id",
            defaults.mopsTvmClientId(),
            NonEmptyValidator.INSTANCE);
        corpMopsTvmClientId = config.get(
            "corp-mops.tvm-client-id",
            defaults.corpMopsTvmClientId(),
            NonEmptyValidator.INSTANCE);
        settingsApiTvmClientId = config.get(
            "settings-api.tvm-client-id",
            defaults.settingsApiTvmClientId(),
            NonEmptyValidator.INSTANCE);
        corpSettingsApiTvmClientId = config.get(
            "corp-settings-api.tvm-client-id",
            defaults.corpSettingsApiTvmClientId(),
            NonEmptyValidator.INSTANCE);

        IniConfig smartObjectsection = config.sectionOrNull("smartobject");
        if (smartObjectsection != null) {
            smartObjectConfig =
                new SmartObjectConfigBuilder(
                    smartObjectsection,
                    defaults.smartObjectConfig());
        } else {
            smartObjectConfig =
                new SmartObjectConfigBuilder(
                    defaults.smartObjectConfig());
        }
        soService = config.get("so-service", defaults.soService(), NonEmptyValidator.INSTANCE);
        if (soService != null) {
            soProducerConfig = new HttpHostConfigBuilder(config.section("so-producer"), defaults.soProducerConfig());
        }
        knnConfig = new HttpHostConfigBuilder(config.section("knn"), defaults.knnConfig());
        mopsConfig = new HttpHostConfigBuilder(config.section("mops"), defaults.mopsConfig());
        corpMopsConfig = new HttpHostConfigBuilder(config.section("corp-mops"), defaults.corpMopsConfig());

        enlarge = config.getBoolean("enlarge", defaults.enlarge());
        unpersonConfig = new JniWrapperConfigBuilder(config.section("unperson"), defaults.unpersonConfig());
    }
    // CSON: MethodLength

    @Override
    public HttpHostConfigBuilder cokemulatorIexlibConfig() {
        return this.cokemulatorIexlibConfig;
    }

    public T cokemulatorIexlibConfig(final HttpHostConfig cokemulatorIexlibConfig)
    {
        this.cokemulatorIexlibConfig = new HttpHostConfigBuilder(cokemulatorIexlibConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder msalConfig() {
        return this.msalConfig;
    }

    public T msalConfig(final HttpHostConfig msalConfig) {
        this.msalConfig = new HttpHostConfigBuilder(msalConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder corpMsalConfig() {
        return this.corpMsalConfig;
    }

    public T corpMsalConfig(final HttpHostConfig corpMsalConfig) {
        this.corpMsalConfig = new HttpHostConfigBuilder(corpMsalConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder gettextConfig() {
        return this.gettextConfig;
    }

    public T gettextConfig(final HttpHostConfig gettextConfig) {
        this.gettextConfig = new HttpHostConfigBuilder(gettextConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder raspConfig() {
        return this.raspConfig;
    }

    public T raspConfig(final HttpHostConfig raspConfig) {
        this.raspConfig = new HttpHostConfigBuilder(raspConfig);
        return this.self();
    }

    @Override
    public StaterConfigBuilder raspStaterConfig() {
        return raspStaterConfig;
    }

    public T raspStaterConfig(final StaterConfig raspStaterConfig) {
        this.raspStaterConfig = new StaterConfigBuilder(raspStaterConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder refundConfig() {
        return this.refundConfig;
    }

    public T refundConfig(final HttpHostConfig refundConfig) {
        this.refundConfig = new HttpHostConfigBuilder(refundConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder marketConfig() {
        return this.marketConfig;
    }

    public T marketConfig(final HttpHostConfig marketConfig) {
        this.marketConfig = new HttpHostConfigBuilder(marketConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder bkConfig() {
        return this.bkConfig;
    }

    public T bkConfig(final HttpHostConfig bkConfig) {
        this.bkConfig = new HttpHostConfigBuilder(bkConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder mediaConfig() {
        return this.mediaConfig;
    }

    public T mediaConfig(final HttpHostConfig mediaConfig) {
        this.mediaConfig = new HttpHostConfigBuilder(mediaConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder calendarConfig() {
        return this.calendarConfig;
    }

    public T calendarConfig(final HttpHostConfig calendarConfig) {
        this.calendarConfig = new HttpHostConfigBuilder(calendarConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder calendarToolsConfig() {
        return this.calendarToolsConfig;
    }

    public T calendarToolsConfig(final HttpHostConfig config) {
        calendarToolsConfig = new HttpHostConfigBuilder(config);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder corovaneerConfig() {
        return this.corovaneerConfig;
    }

    public T corovaneerConfig(final HttpHostConfig corovaneerConfig) {
        this.corovaneerConfig = new HttpHostConfigBuilder(corovaneerConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder kinopoiskQlConfig() {
        return this.kinopoiskQlConfig;
    }

    public T kinopoiskQlConfig(final HttpHostConfig kinopoiskQlConfig) {
        this.kinopoiskQlConfig = new HttpHostConfigBuilder(kinopoiskQlConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder gatemailConfig() {
        return this.gatemailConfig;
    }

    public T gatemailConfig(final HttpHostConfig gatemailConfig) {
        this.gatemailConfig = new HttpHostConfigBuilder(gatemailConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder msearchConfig() {
        return msearchConfig;
    }

    public T msearchConfig(final HttpHostConfig msearchConfig) {
        this.msearchConfig = new HttpHostConfigBuilder(msearchConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder onlineDBConfig() {
        return onlineDBConfig;
    }

    public T onlineDBConfig(final HttpHostConfig onlineDBConfig) {
        this.onlineDBConfig = new HttpHostConfigBuilder(onlineDBConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder reminderConfig() {
        return this.reminderConfig;
    }

    public T reminderConfig(final HttpHostConfig reminderConfig) {
        this.reminderConfig = new HttpHostConfigBuilder(reminderConfig);
        return this.self();
    }

    @Override
    public GeocoderConfigBuilder geoSearchConfig() {
        return this.geoSearchConfig;
    }

    public T geoSearchConfig(final GeocoderConfig geoSearchConfig) {
        if (geoSearchConfig == null) {
            this.geoSearchConfig = null;
        } else {
            this.geoSearchConfig = new GeocoderConfigBuilder(geoSearchConfig);
        }
        return this.self();
    }

    @Override
    public StaterConfigBuilder geoStaterConfig() {
        return geoStaterConfig;
    }

    public T geoStaterConfig(final StaterConfig geoStaterConfig) {
        this.geoStaterConfig = new StaterConfigBuilder(geoStaterConfig);
        return self();
    }

    @Override
    public AfishaConfigBuilder afishaConfig() {
        return afishaConfig;
    }

    public T afishaConfig(final InterfaceAfishaConfig afishaConfig) {
        if (afishaConfig == null) {
            this.afishaConfig = null;
        } else {
            this.afishaConfig = new AfishaConfigBuilder(afishaConfig);
        }
        return this.self();
    }

    @Override
    public URIConfig iexConfig() {
        return this.iexConfig;
    }

    public T iexConfig(final URIConfig iexConfig) {
        this.iexConfig = new URIConfigBuilder(iexConfig);
        return this.self();
    }

    @Override
    public Tvm2ClientConfigBuilder tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    public T tvm2ClientConfig(final Tvm2ClientConfig tvm2ClientConfig) {
        this.tvm2ClientConfig = new Tvm2ClientConfigBuilder(tvm2ClientConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder blackboxConfig() {
        return this.blackboxConfig;
    }

    public T blackboxConfig(final HttpHostConfig blackboxConfig) {
        this.blackboxConfig = new HttpHostConfigBuilder(blackboxConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder corpBlackboxConfig() {
        return this.corpBlackboxConfig;
    }

    public T corpBlackboxConfig(final HttpHostConfig corpBlackboxConfig) {
        this.corpBlackboxConfig = new HttpHostConfigBuilder(corpBlackboxConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder blackboxDirectConfig() {
        return this.blackboxDirectConfig;
    }

    public T blackboxDirectConfig(final HttpHostConfig blackboxDirectConfig) {
        this.blackboxDirectConfig = new HttpHostConfigBuilder(blackboxDirectConfig);
        return this.self();
    }

    @Override
    public HttpTargetConfigBuilder postProcessConfig() {
        return this.postProcessConfig;
    }

    public T postProcessConfig(final HttpTargetConfig postProcessConfig) {
        this.postProcessConfig = new HttpTargetConfigBuilder(postProcessConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder tikaiteConfig() {
        return this.tikaiteConfig;
    }

    public T tikaiteConfig(final HttpHostConfig tikaiteConfig) {
        this.tikaiteConfig = new HttpHostConfigBuilder(tikaiteConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder tikaiteMlConfig() {
        return this.tikaiteMlConfig;
    }

    public T tikaiteMlConfig(final HttpHostConfig tikaiteMlConfig) {
        this.tikaiteMlConfig = new HttpHostConfigBuilder(tikaiteMlConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder mulcagateConfig() {
        return this.mulcagateConfig;
    }

    public T mulcagateConfig(final HttpHostConfig mulcagateConfig) {
        this.mulcagateConfig = new HttpHostConfigBuilder(mulcagateConfig);
        return this.self();
    }

    @Override
    public URIConfig axisConfig() {
        return this.axisConfig;
    }

    public T axisConfig(final URIConfig axisConfig) {
        this.axisConfig = new URIConfigBuilder(axisConfig);
        return this.self();
    }

    @Override
    public URIConfig rcaURIConfig() {
        return this.rcaURIConfig;
    }

    public T rcaURIConfig(final URIConfig rcaURIConfig) {
        this.rcaURIConfig =
            new URIConfigBuilder(rcaURIConfig);
        return this.self();
    }

    @Override
    public StaterConfigBuilder rcaStaterConfig() {
        return rcaStaterConfig;
    }

    public T rcaStaterConfig(final StaterConfig rcaStaterConfig) {
        this.rcaStaterConfig = new StaterConfigBuilder(rcaStaterConfig);
        return self();
    }

    @Override
    public URIConfig factsExtractURIConfig() {
        return this.factsExtractURIConfig;
    }

    public T factsExtractURIConfig(final URIConfig factsExtractURIConfig) {
        this.factsExtractURIConfig =
            new URIConfigBuilder(factsExtractURIConfig);
        return this.self();
    }

    @Override
    public FilterSearchConfigBuilder filterSearchConfig() {
        return this.filterSearchConfig;
    }

    public T filterSearchConfig(final FilterSearchConfig filterSearchConfig) {
        this.filterSearchConfig =
                new FilterSearchConfigBuilder(filterSearchConfig);
        return this.self();
    }

    @Override
    public FilterSearchConfigBuilder corpFilterSearchConfig() {
        return this.corpFilterSearchConfig;
    }

    public T corpFilterSearchConfig(
            final FilterSearchConfig corpFilterSearchConfig)
    {
        this.corpFilterSearchConfig = new FilterSearchConfigBuilder(corpFilterSearchConfig);
        return this.self();
    }

    @Override
    public ComplaintsConfig complaintsConfig() {
        return this.complaintsConfig;
    }

    public T complaintsConfig(final ComplaintsConfig complaintsConfig) {
        this.complaintsConfig = new ComplaintsConfigBuilder(complaintsConfig);
        return this.self();
    }

    public T complaintsConfig(final URIConfig uriConfig, final ComplaintsConfig complaintsConfig) {
        this.complaintsConfig = new ComplaintsConfigBuilder(uriConfig, complaintsConfig);
        return this.self();
    }

    public T complaintsConfig(final IniConfig complaintsConfig) throws ConfigException {
        this.complaintsConfig = new ComplaintsConfigBuilder(complaintsConfig);
        return this.self();
    }

    public T complaintsConfig(final URIConfig complaintsConfig) {
        Map<Route, Map<Integer, String>> rulesDictionaries =
            this.complaintsConfig.rulesDictionaries();
        StaterConfigBuilder staterConfigBuilder = this.complaintsConfig.soSearchRequestsStaterConfig();
        this.complaintsConfig = new ComplaintsConfigBuilder(complaintsConfig);
        this.complaintsConfig.rulesDictionaries(rulesDictionaries);
        this.complaintsConfig.soSearchRequestsStaterConfig(staterConfigBuilder);
        return this.self();
    }

    public T complaintsConfig(final URIConfig complaintsConfig, final StaterConfig staterConfig) {
        complaintsConfig(complaintsConfig);
        this.complaintsConfig.soSearchRequestsStaterConfig(staterConfig);
        this.complaintsConfig.shinglersDryRun(false).useSolog(true).useSologger(true);
        return this.self();
    }

    @Override
    public URIConfig complaintsCoworkersSelectionConfig() {
        return this.complaintsCoworkersSelectionConfig;
    }

    public T complaintsCoworkersSelectionConfig(
        final URIConfig complaintsCoworkersSelectionConfig)
    {
        this.complaintsCoworkersSelectionConfig =
            new URIConfigBuilder(complaintsCoworkersSelectionConfig);
        return this.self();
    }

    @Override
    public URIConfig sologgerConfig() {
        return this.sologgerConfig;
    }

    public T sologgerConfig(final URIConfig sologgerConfig) {
        this.sologgerConfig = new URIConfigBuilder(sologgerConfig);
        return this.self();
    }

    @Override
    public URIConfig freemailConfig() {
        return this.freemailConfig;
    }

    public T freemailConfig(final URIConfig freemailConfig) {
        this.freemailConfig = new URIConfigBuilder(freemailConfig);
        return this.self();
    }

    @Override
    public URIConfig settingsApiConfig() {
        return this.settingsApiConfig;
    }

    public T settingsApiConfig(final URIConfig settingsApiConfig) {
        this.settingsApiConfig = new URIConfigBuilder(settingsApiConfig);
        return this.self();
    }

    @Override
    public URIConfig corpSettingsApiConfig() {
        return this.corpSettingsApiConfig;
    }

    public T corpSettingsApiConfig(final URIConfig corpSettingsApiConfig) {
        this.corpSettingsApiConfig = new URIConfigBuilder(corpSettingsApiConfig);
        return this.self();
    }

    @Override
    public URIConfig foldersConfig() {
        return this.foldersConfig;
    }

    public T foldersConfig(final URIConfig foldersConfig) {
        this.foldersConfig = new URIConfigBuilder(foldersConfig);
        return this.self();
    }

    @Override
    public URIConfig corpFoldersConfig() {
        return this.corpFoldersConfig;
    }

    public T corpFoldersConfig(final URIConfig corpFoldersConfig) {
        this.corpFoldersConfig = new URIConfigBuilder(corpFoldersConfig);
        return this.self();
    }

    @Override
    public URIConfig labelsConfig() {
        return this.labelsConfig;
    }

    public T labelsConfig(final URIConfig labelsConfig) {
        this.labelsConfig = new URIConfigBuilder(labelsConfig);
        return this.self();
    }

    @Override
    public URIConfig corpLabelsConfig() {
        return this.corpLabelsConfig;
    }

    public T corpLabelsConfig(final URIConfig corpLabelsConfig) {
        this.corpLabelsConfig = new URIConfigBuilder(corpLabelsConfig);
        return this.self();
    }

    @Override
    public URIConfig attachSidConfig() {
        return this.attachSidConfig;
    }

    public T attachSidConfig(final URIConfig attachSidConfig) {
        this.attachSidConfig = new URIConfigBuilder(attachSidConfig);
        return this.self();
    }

    @Override
    public URIConfig corpAttachSidConfig() {
        return this.corpAttachSidConfig;
    }

    public T corpAttachSidConfig(final URIConfig corpAttachSidConfig) {
        this.corpAttachSidConfig = new URIConfigBuilder(corpAttachSidConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder producerAsyncClientConfig() {
        return this.producerAsyncClientConfig;
    }

    public T producerAsyncClientConfig(
            final HttpHostConfig producerAsyncClientConfig)
    {
        this.producerAsyncClientConfig =
                new HttpHostConfigBuilder(producerAsyncClientConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder soProducerConfig() {
        return this.soProducerConfig;
    }

    public T soProducerConfig(
            final HttpHostConfig soProducerConfig)
    {
        this.soProducerConfig =
                new HttpHostConfigBuilder(soProducerConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder knnConfig() {
        return this.knnConfig;
    }

    public T knnConfig(final HttpHostConfig knnConfig)
    {
        this.knnConfig = new HttpHostConfigBuilder(knnConfig);
        return this.self();
    }

    @Override
    public HttpHostConfigBuilder mopsConfig() {
        return this.mopsConfig;
    }

    @Override
    public HttpHostConfig corpMopsConfig() {
        return corpMopsConfig;
    }

    public T mopsConfig(final HttpHostConfig mopsConfig)
    {
        this.mopsConfig = new HttpHostConfigBuilder(mopsConfig);
        return this.self();
    }

    public T corpMopsConfig(final HttpHostConfig corpMopsConfig)
    {
        this.corpMopsConfig = new HttpHostConfigBuilder(corpMopsConfig);
        return this.self();
    }

    @Override
    public Pattern mdbs() {
        return this.mdbs;
    }

    public T mdbs(final Pattern mdbs) {
        this.mdbs = mdbs;
        return this.self();
    }

    @Override
    public Long maxRetries() {
        return this.maxRetries;
    }

    public T maxRetries(final Long maxRetries) {
        this.maxRetries = maxRetries;
        return this.self();
    }

    @Override
    public Long almostAllFactsTimeout() {
        return this.almostAllFactsTimeout;
    }

    public T almostAllFactsTimeout(final Long almostAllFactsTimeout) {
        this.almostAllFactsTimeout = almostAllFactsTimeout;
        return this.self();
    }

    @Override
    public Long factsExtractIndexationWaitTimeout() {
        return this.factsExtractIndexationWaitTimeout;
    }

    public T factsExtractIndexationWaitTimeout(final Long timeout) {
        this.factsExtractIndexationWaitTimeout = timeout;
        return this.self();
    }

    @Override
    public String xIndexOperationQueueNameBacklog() {
        return this.xIndexOperationQueueNameBacklog;
    }

    public T xIndexOperationQueueNameBacklog(
            final String xIndexOperationQueueNameBacklog)
    {
        this.xIndexOperationQueueNameBacklog = xIndexOperationQueueNameBacklog;
        return this.self();
    }

    @Override
    public String xIndexOperationQueueNameFacts() {
        return this.xIndexOperationQueueNameFacts;
    }

    public T xIndexOperationQueueNameFacts(
            final String xIndexOperationQueueNameFacts)
    {
        this.xIndexOperationQueueNameFacts = xIndexOperationQueueNameFacts;
        return this.self();
    }

    @Override
    public String xIndexOperationQueueNameUpdate() {
        return this.xIndexOperationQueueNameUpdate;
    }

    public T xIndexOperationQueueNameUpdate(
            final String xIndexOperationQueueNameUpdate)
    {
        this.xIndexOperationQueueNameUpdate = xIndexOperationQueueNameUpdate;
        return this.self();
    }

    @Override
    public String slowQueueName() {
        return this.slowQueueName;
    }

    public T slowQueueName(final String slowQueueName) {
        this.slowQueueName = slowQueueName;
        return this.self();
    }

    @Override
    public String axisQueueName() {
        return this.axisQueueName;
    }

    public T axisQueueName(final String axisQueueName) {
        this.axisQueueName = axisQueueName;
        return this.self();
    }

    @Override
    public String factsIndexingQueueName() {
        return this.factsIndexingQueueName;
    }

    public T factsIndexingQueueName(
            final String factsIndexingQueueName)
    {
        this.factsIndexingQueueName = factsIndexingQueueName;
        return this.self();
    }

    @Override
    public String mailSearchQueueName() {
        return mailSearchQueueName;
    }

    public T mailSearchQueueName(final String mailSearchQueueName) {
        this.mailSearchQueueName = mailSearchQueueName;
        return self();
    }

    @Override
    public String corpMailSearchQueueName() {
        return corpMailSearchQueueName;
    }

    public T corpMailSearchQueueName(final String corpMailSearchQueueName) {
        this.corpMailSearchQueueName = corpMailSearchQueueName;
        return self();
    }

    @Override
    public LoggerConfigBuilder reqresLog() {
        return reqresLog;
    }

    public T reqresLog(final LoggerConfig reqresLog) {
        this.reqresLog = new LoggerConfigBuilder(reqresLog);
        return self();
    }

    @Override
    public LoggerConfigBuilder sobbYtLog() {
        return sobbYtLog;
    }

    public T sobbYtLog(final LoggerConfig sobbYtLog) {
        this.sobbYtLog = new LoggerConfigBuilder(sobbYtLog);
        return self();
    }

    @Override
    public IniConfig extraSettingsConfig() {
        return extraSettings;
    }

    @Override
    public IniConfig headersSection() {
        return headersSection;
    }

    @Override
    public IniConfig headersDomainSection() {
        return headersDomainSection;
    }

    @Override
    public IniConfig entitiesSection() {
        return entitiesSection;
    }

    @Override
    public IniConfig entitiesEmailSection() {
        return entitiesEmailSection;
    }

    @Override
    public IniConfig entitiesRcptEmailSection() {
        return entitiesRcptEmailSection;
    }

    @Override
    public IniConfig postProcessSection() {
        return postProcessSection;
    }

    @Override
    public IniConfig postProcessEmailSection() {
        return postProcessEmailSection;
    }

    @Override
    public IniConfig postProcessRcptEmailSection() {
        return postProcessRcptEmailSection;
    }

    @Override
    public IniConfig entitiesRcptUidSection() {
        return entitiesRcptUidSection;
    }

    @Override
    public IniConfig postProcessRcptUidSection() {
        return postProcessRcptUidSection;
    }

    @Override
    public IniConfig rcptUidRuleSections() {
        return rcptUidRuleSections;
    }

    @Override
    public IniConfig entitiesDomainSection() {
        return entitiesDomainSection;
    }

    @Override
    public IniConfig postProcessDomainSection() {
        return postProcessDomainSection;
    }

    @Override
    public IniConfig rcptUidStoreSignalsSection() {
        return rcptUidStoreSignalsSection;
    }

    @Override
    public IniConfig entitiesTimeStamps() {
        return entitiesTimeStamps;
    }

    @Override
    public IniConfig urlsWhitelistRegexp() {
        return urlsWhitelistRegexp;
    }

    @Override
    public IniConfig mediaFiscalsProperties() {
        return mediaFiscalsProperties;
    }

    @Override
    public IniConfig refundSendersProperties() {
        return refundSendersProperties;
    }

    public T zoraProxyConfig(final ZoraProxyClientConfig config) {
        this.zoraProxyConfig = new ZoraProxyClientConfigBuilder(config);
        return self();
    }

    @Override
    public ZoraProxyClientConfig zoraProxyConfig() {
        return zoraProxyConfig;
    }

    @Override
    public Set<String> factNamesToEraseFactData() {
        return factNamesToEraseFactData;
    }

    @Override
    public IexForwardersConfigBuilder forwardersConfig() {
        return forwardersConfig;
    }

    public T forwardersConfig(
        final IexForwardersConfig forwardersConfig)
    {
        this.forwardersConfig = new IexForwardersConfigBuilder(forwardersConfig);
        return self();
    }

    @Override
    public XivaConfigBuilder xivaConfig() {
        return xivaConfig;
    }

    public T xivaConfig(final XivaConfig config) {
        xivaConfig = new XivaConfigBuilder(config);
        return self();
    }

    @Override
    public XivaConfigBuilder xivaCorpConfig() {
        return xivaCorpConfig;
    }

    public T xivaCorpConfig(final XivaConfig config) {
        xivaCorpConfig = new XivaConfigBuilder(config);
        return self();
    }

    @Override
    public HttpHostConfig taksaConfig() {
        return taksaConfig;
    }

    public T taksaConfig(final HttpHostConfig config) {
        taksaConfig = new HttpHostConfigBuilder(config);
        return self();
    }

    @Override
    public HttpHostConfig taksaTestingConfig() {
        return taksaTestingConfig;
    }

    public T taksaTestingConfig(final HttpHostConfig config) {
        taksaTestingConfig = new HttpHostConfigBuilder(config);
        return self();
    }

    @Override
    public HttpHostConfig neuroHardsConfig() {
        return neuroHardsConfig;
    }

    public T neuroHardsConfig(final HttpHostConfig config) {
        neuroHardsConfig = new HttpHostConfigBuilder(config);
        return self();
    }

    @Override
    public ReceivedChainParserConfig receivedChainParserConfig() {
        return receivedChainParserConfig;
    }

    public T receivedChainParserConfig(final ReceivedChainParserConfig config) {
        receivedChainParserConfig = new ReceivedChainParserConfigBuilder(config);
        return self();
    }

    @Override
    public String blackboxTvmClientId() {
        return blackboxTvmClientId;
    }

    public T blackboxTvmClientId(final String blackboxTvmClientId) {
        this.blackboxTvmClientId = blackboxTvmClientId;
        return self();
    }

    @Override
    public String corpBlackboxTvmClientId() {
        return corpBlackboxTvmClientId;
    }

    public T corpBlackboxTvmClientId(final String corpBlackboxTvmClientId) {
        this.corpBlackboxTvmClientId = corpBlackboxTvmClientId;
        return self();
    }

    @Override
    public String tikaiteTvmClientId() {
        return tikaiteTvmClientId;
    }

    public T tikaiteTvmClientId(final String tikaiteTvmClientId) {
        this.tikaiteTvmClientId = tikaiteTvmClientId;
        return self();
    }

    @Override
    public String unistorageTvmClientId() {
        return unistorageTvmClientId;
    }

    public T unistorageTvmClientId(final String unistorageTvmClientId) {
        this.unistorageTvmClientId = unistorageTvmClientId;
        return self();
    }

    @Override
    public String geoTvmClientId() {
        return geoTvmClientId;
    }

    public T geoTvmClientId(final String geoTvmClientId) {
        this.geoTvmClientId = geoTvmClientId;
        return self();
    }

    @Override
    public String filterSearchTvmClientId() {
        return filterSearchTvmClientId;
    }

    public T filterSearchTvmClientId(final String filterSearchTvmClientId) {
        this.filterSearchTvmClientId = filterSearchTvmClientId;
        return self();
    }

    @Override
    public String corpFilterSearchTvmClientId() {
        return corpFilterSearchTvmClientId;
    }

    public T corpFilterSearchTvmClientId(
        final String corpFilterSearchTvmClientId)
    {
        this.corpFilterSearchTvmClientId = corpFilterSearchTvmClientId;
        return self();
    }

    @Override
    public String foldersTvmClientId() {
        return foldersTvmClientId;
    }

    public T foldersTvmClientId(final String foldersTvmClientId) {
        this.foldersTvmClientId = foldersTvmClientId;
        return self();
    }

    @Override
    public String corpFoldersTvmClientId() {
        return corpFoldersTvmClientId;
    }

    public T corpFoldersTvmClientId(final String corpFoldersTvmClientId) {
        this.corpFoldersTvmClientId = corpFoldersTvmClientId;
        return self();
    }

    @Override
    public String labelsTvmClientId() {
        return labelsTvmClientId;
    }

    public T labelsTvmClientId(final String labelsTvmClientId) {
        this.labelsTvmClientId = labelsTvmClientId;
        return self();
    }

    @Override
    public String corpLabelsTvmClientId() {
        return corpLabelsTvmClientId;
    }

    public T corpLabelsTvmClientId(final String corpLabelsTvmClientId) {
        this.corpLabelsTvmClientId = corpLabelsTvmClientId;
        return self();
    }

    @Override
    public String afishaTvmClientId() {
        return afishaTvmClientId;
    }

    public T afishaTvmClientId(final String afishaTvmClientId) {
        this.afishaTvmClientId = afishaTvmClientId;
        return self();
    }

    @Override
    public String kinopoiskTvmClientId() {
        return kinopoiskTvmClientId;
    }

    public T kinopoiskTvmClientId(final String kinopoiskTvmClientId) {
        this.kinopoiskTvmClientId = kinopoiskTvmClientId;
        return self();
    }

    @Override
    public String attachSidTvmClientId() {
        return attachSidTvmClientId;
    }

    public T attachSidTvmClientId(final String attachSidTvmClientId) {
        this.attachSidTvmClientId = attachSidTvmClientId;
        return self();
    }

    @Override
    public String corpAttachSidTvmClientId() {
        return corpAttachSidTvmClientId;
    }

    public T corpAttachSidTvmClientId(final String corpAttachSidTvmClientId) {
        this.corpAttachSidTvmClientId = corpAttachSidTvmClientId;
        return self();
    }

    @Override
    public String taksaTvmClientId() {
        return taksaTvmClientId;
    }

    public T taksaTvmClientId(final String taksaTvmClientId) {
        this.taksaTvmClientId = taksaTvmClientId;
        return self();
    }

    @Override
    public String calendarTvmClientId() {
        return calendarTvmClientId;
    }

    public T calendarTvmClientId(final String calendarTvmClientId) {
        this.calendarTvmClientId = calendarTvmClientId;
        return self();
    }

    @Override
    public String calendarToolsTvmClientId() {
        return calendarToolsTvmClientId;
    }

    public T calendarToolsTvmClientId(final String calendarToolsTvmClientId) {
        this.calendarToolsTvmClientId = calendarToolsTvmClientId;
        return self();
    }

    @Override
    public String corovaneerTvmClientId() {
        return corovaneerTvmClientId;
    }

    public T corovaneerTvmClientId(final String corovaneerTvmClientId) {
        this.corovaneerTvmClientId = corovaneerTvmClientId;
        return self();
    }

    @Override
    public String mopsTvmClientId() {
        return mopsTvmClientId;
    }

    public T mopsTvmClientId(final String mopsTvmClientId) {
        this.mopsTvmClientId = mopsTvmClientId;
        return self();
    }

    @Override
    public String corpMopsTvmClientId() {
        return corpMopsTvmClientId;
    }

    public T corpMopsTvmClientId(final String corpMopsTvmClientId) {
        this.corpMopsTvmClientId = corpMopsTvmClientId;
        return self();
    }

    @Override
    public String settingsApiTvmClientId() {
        return settingsApiTvmClientId;
    }

    public T settingsApiTvmClientId(final String settingsApiTvmClientId) {
        this.settingsApiTvmClientId = settingsApiTvmClientId;
        return self();
    }

    @Override
    public String corpSettingsApiTvmClientId() {
        return corpSettingsApiTvmClientId;
    }

    public T corpSettingsApiTvmClientId(final String corpSettingsApiTvmClientId) {
        this.corpSettingsApiTvmClientId = corpSettingsApiTvmClientId;
        return self();
    }

    @Override
    public String soService() {
        return soService;
    }

    public T soService(final String soService) {
        this.soService = soService;
        return self();
    }

    @Override
    public boolean enlarge() {
        return enlarge;
    }

    public T enlarge(final boolean enlarge) {
        this.enlarge = enlarge;
        return self();
    }

    @Override
    public JniWrapperConfigBuilder unpersonConfig() {
        return unpersonConfig;
    }

    public T unpersonConfig(final JniWrapperConfig unpersonConfig) {
        this.unpersonConfig = new JniWrapperConfigBuilder(unpersonConfig);
        return self();
    }

    @Override
    public SmartObjectConfigBuilder smartObjectConfig() {
        return smartObjectConfig;
    }

    public T smartObjectConfig(final SmartObjectConfig smartObjectConfig) {
        this.smartObjectConfig = new SmartObjectConfigBuilder(smartObjectConfig);
        return self();
    }
}

