package ru.yandex.iex.proxy;

import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class ActionEntityHandler extends AbstractEntityHandler<ActionContext> {
    public static final String LIST_UNSUBSCRIBE = "list_unsubscribe";

    ActionEntityHandler(final IexProxy iexProxy) {
        super(iexProxy, "action");
    }

    @Override
    protected ActionContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new ActionContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final ActionContext context)
        throws JsonUnexpectedTokenException, BadRequestException
    {
        context.response();
    }
}
