package ru.yandex.iex.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.HttpExceptionConverter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class AddrContext extends AbstractEntityContext {
    private static final String ADDR = "addr";
    private final Object addrJson;
    private ArrayList<AddrEntry> addrs = new ArrayList<AddrEntry>();
    private int countOfValidAddress = -1;

    AddrContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        if (json == null) {
            addrJson = null;
        } else {
            addrJson = json.get(ADDR);
        }
        if (addrJson != null) {
            parseIexJsonToArrayOfEntry();
            AddrEntry.toFullupArrayOfEntry(addrs);
        }
    }

    public ArrayList<AddrEntry> getArrayOfAddress() {
        return addrs;
    }

    public int getCountOfValidAddress() {
        if (countOfValidAddress == -1) {
            int res = 0;
            for (final AddrEntry x : addrs) {
                if (x.isEntryPerfect()) {
                    res++;
                }
            }
            countOfValidAddress = res;
        }
        return countOfValidAddress;
    }

    @Override
    public void response() {
        session.response(HttpStatus.SC_OK, JsonType.NORMAL.toString(addrJson));
    }

    public void failed(final Exception e) {
        session()
            .logger()
            .log(Level.WARNING, "Failed to process: "
                + humanReadableJson()
                + '\n' + session().listener().details()
                + " because of exception", e);
        session().handleException(
            HttpExceptionConverter.toHttpException(e));
    }

    private void parseIexJsonToArrayOfEntry()
        throws JsonUnexpectedTokenException
    {
        List<?> l = ValueUtils.asList(addrJson);
        for (final Object x: l) {
            @SuppressWarnings("unchecked")
            Map<String, Object> m1 = (Map<String, Object>) ValueUtils.asMap(x);
            AddrEntry tmpEntr = new AddrEntry();
            tmpEntr.parseFromIexEntry(m1);
            addrs.add(tmpEntr);
        }
    }
}

