package ru.yandex.iex.proxy;

import java.util.ArrayList;
import java.util.Map;

import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

class AddrEntry {
    private static final String INDEX = "index";
    private static final int RNUMOFFIELD = 1;
    private static final String GEO = "geo";
    private static final String ADDR = "addr";

    private String index = "";

    private String country = "";
    private String city = "";

    private String descr = "";
    private String street = "";
    private String number = "";
    //private String metro = "";

    private String fullStreetAddress = null;

    private Map<String, Object> ptrToAddrJsonEntry;

    public boolean isEntryPerfect() {
        if (isEmptyInt(country)
            + isEmptyInt(index)
            + isEmptyInt(city)
            + isEmptyInt(getFullStreetAddress()) < RNUMOFFIELD)
        {
            return false;
        }
        return true;
    }

    public void pushToJson(final String json, final Object value) {
        if (ptrToAddrJsonEntry != null) {
            ptrToAddrJsonEntry.put(json, value);
        }
    }

    public String getAddressInGeocoderFormat() {
        return getStrFieldsWithComma(country)
            + getStrFieldsWithComma(index)
            + getStrFieldsWithComma(city)
            + getFullStreetAddress();
    }

    public void parseFromIexEntry(final Map<String, Object> entry)
        throws JsonUnexpectedTokenException
    {
        ptrToAddrJsonEntry = entry;
        if (entry.containsKey(GEO)) {
            Map<?, ?> geo = ValueUtils.asMap(entry.get(GEO));
            city = stringOrEmptyString(geo, "city");
            country = stringOrEmptyString(geo, "country");
        }
        if (entry.containsKey(ADDR)) {
            Map<?, ?> geo = ValueUtils.asMap(entry.get(ADDR));
            descr = stringOrEmptyString(geo, "descr");
            street = stringOrEmptyString(geo, "street");
            number = stringOrEmptyString(geo, "numbers");
            //metro = ValueUtils.asStringOrNull(geo.get("metro"));
        }
        if (entry.containsKey(INDEX)) {
            index = ValueUtils.asStringOrNull(entry.get(INDEX));
        }
    }

    private int isEmptyInt(final String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        return 1;
    }

    private String stringOrEmptyString(final Map<?, ?> m, final String key)
        throws JsonUnexpectedTokenException
    {
        String res = ValueUtils.asStringOrNull(m.get(key));
        if (res == null) {
            return "";
        }
        return res;
    }

    private String getFullStreetAddress() {
        if (fullStreetAddress == null) {
            fullStreetAddress = getStrFieldsWithComma(descr)
                + getStrFieldsWithComma(street)
                + getStrFieldsWithComma(number);
        }
        return fullStreetAddress;
    }

    private String getStrFieldsWithComma(final String s) {
        if (s != null && !s.isEmpty()) {
            return s + ", ";
        }
        return "";
    }

    public static void toFullupArrayOfEntry(
        final ArrayList<AddrEntry> addrsEntryList)
    {
        String curCountry = "";
        String curIndex = "";
        String curCity = "";
        for (final AddrEntry x : addrsEntryList) {
            if (curCountry.isEmpty() && !x.country.isEmpty()) {
                curCountry = x.country;
            }
            if (curIndex.isEmpty() && !x.index.isEmpty()) {
                curIndex = x.index;
            }
            if (curCity.isEmpty() && !x.city.isEmpty()) {
                curCity = x.city;
            }
        }
        if (!curCity.isEmpty()
            || !curIndex.isEmpty()
            || !curCountry.isEmpty())
        {
            for (AddrEntry x : addrsEntryList) {
                if (x.country.isEmpty()) {
                    x.country = curCountry;
                }
                if (x.index.isEmpty()) {
                    x.index = curIndex;
                }
                if (x.city.isEmpty()) {
                    x.city = curCity;
                }
            }
        }
    }
}
