package ru.yandex.iex.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class BounceContext extends AbstractEntityContext {
    public static final String MESSAGE_ID = "original_message_id";
    //public static final int COUNT_OF_MAILTYPE = 11;
    public static final String STATUS = "status";
    public static final String TYPE = "type";
    public static final int THREE = 3;
    public static final int FOUR = 4;
    public static final int FIVE = 5;
    public static final int SIX = 6;
    public static final int SEVEN = 7;
    public static final int EIGHT = 8;
    public static final int NINE = 9;
    public static final int TYPE_12 = 12;
    public static final String WIDGET_SUBTYPE = "widget_subtype";
    public static final String BOUNCE = "bounce";
    public static final String DIAGNOSTIC_CODE = "diagnostic_code";
    public static final String ORIGINAL_FROM = "original_from";
    public static final String ORIGINAL_RECIPIENT = "original_recipient";
    public static final String ACTION = "action";
    public static final String STR_NINE = "9";

    public enum BounceTraits {UNKNOWN, SPAM, REGULAR, INVALID, SMTP, FORWARD};

    private static final XDataStructure.IMailTypeSearch typeDict = new XDataStructure.MailTypeSearchHashMap();
    //  = new XDataStructure.MailTypeSearchAhoCorasick();
    private static int typeId = 1;
    private final Map<String, Object> bounceJson = new HashMap<>();
    private Object messageId = null;
    private String mid = "";
    private String bounceMid = "";
    private String digCode = "";
    private String from = "";
    private String to = "";
    private String senderDomain = "";
    private final List<BounceTraits> bounceTraits = new ArrayList<>();

    static {
        // TODO: rewrite this on the regexp
        // type 1
        java.util.function.BiConsumer<String[], String[]>
            insertType = (autoGenerated, handGenerated) -> {
                int curType = typeId;
                if (curType == TYPE_12) {
                    curType = 2;
                }
                typeDict.addType(autoGenerated, curType);
                typeDict.addType(handGenerated, curType);
                ++typeId;
            };
        String[] statusType1 = XStrAlgo.generateMailStatus(
            new Integer[]{FIVE},
            new Integer[]{1},
            new Integer[]{1, 2, THREE, SIX}
        );
        insertType.accept(statusType1, new String[]{"5.0.0"});

        //status 2
        String[] statusType2 = XStrAlgo.generateMailStatus(
            new Integer[]{FOUR, FIVE},
            new Integer[]{1, 2},
            new Integer[]{FOUR});
        insertType.accept(statusType2, new String[]{"5.1.6"});

        //status 3
        String[] statusType3 = XStrAlgo.generateMailStatus(
            new Integer[]{FOUR, FIVE},
            new Integer[]{1},
            new Integer[]{SEVEN, EIGHT}
        );
        insertType.accept(statusType3, new String[]{"5.3.4"});

        //status 4
        String[] statusType4 = XStrAlgo.generateMailStatus(
            new Integer[]{FOUR, FIVE},
            new Integer[]{1},
            new Integer[]{0});
        insertType.accept(statusType4, new String[]{});

        //status 5
        insertType.accept(new String[]{}, new String[]{"5.2.3"});

        //status 6
        insertType.accept(new String[]{}, new String[]{"5.6.1"});

        //status 7
        insertType.accept(new String[]{}, new String[]{"4.2.2"});

        //status 8
        String[] statusType8 = XStrAlgo.generateMailStatus(
            new Integer[]{FOUR, FIVE},
            new Integer[]{FIVE},
            new Integer[]{THREE});
        insertType.accept(statusType8, new String[]{"5.4.4"});

        //status 9
        String[] statusType9 = XStrAlgo.generateMailStatus(
            new Integer[]{2},
            XTools.range(0, NINE),
            XTools.range(0, NINE));
        insertType.accept(statusType9, new String[]{});

        //status 10
        String[] statusType10 = XStrAlgo.generateMailStatus(
            new Integer[]{FOUR, FIVE},
            new Integer[]{2},
            new Integer[]{0, 1}
        );
        insertType.accept(statusType10, new String[]{});

        //status 11
        String[] statusType11 = XStrAlgo.generateMailStatus(
            new Integer[]{FOUR, FIVE},
            new Integer[]{1},
            new Integer[]{SEVEN, EIGHT}
        );
        insertType.accept(statusType11, new String[]{});

        //status 12
        String[] statusType12sub1 = XStrAlgo.generateMailStatus(
            new Integer[]{FOUR},
            new Integer[]{0},
            new Integer[]{0});
        String[] statusType12sub2 = XStrAlgo.generateMailStatus(
            new Integer[]{FOUR, FIVE},
            new Integer[]{THREE},
            XTools.concatAll(XTools.range(0, THREE), XTools.range(FIVE, FIVE)));
        String[] statusType12sub3 = XStrAlgo.generateMailStatus(
            new Integer[]{FOUR, FIVE},
            new Integer[]{FOUR},
            XTools.concatAll(XTools.range(0, THREE), XTools.range(FIVE, NINE)));
        //XTools.range(0, NINE));
        String[] statusType12sub4 = XStrAlgo.generateMailStatus(
            new Integer[]{FOUR, FIVE},
            new Integer[]{FIVE},
            XTools.concatAll(XTools.range(0, 2), XTools.range(FOUR, NINE)));
        String[] statusType12sub5 = XStrAlgo.generateMailStatus(
            new Integer[]{FOUR, FIVE},
            new Integer[]{SIX},
            new Integer[]{2});
        String[] statusType12sub6 = XStrAlgo.generateMailStatus(
            new Integer[]{FOUR, FIVE},
            new Integer[]{SEVEN},
            XTools.range(0, 2));
        String[] statusType12sub7 = XStrAlgo.generateMailStatus(
            new Integer[]{FOUR},
            new Integer[]{THREE},
            new Integer[]{FOUR});
        String[] statusType12 = XTools.concatAll(
            statusType12sub1,
            statusType12sub2,
            statusType12sub3,
            statusType12sub4,
            statusType12sub5,
            statusType12sub6,
            statusType12sub7);
        insertType.accept(statusType12, new String[]{"4.4.4"});
    }

    public BounceContext(final IexProxy iexProxy, final ProxySession session, final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        uid = session.params().getLong("uid");
        bounceMid = session.params().getString("mid", "");
        Object iexBounce = json.get(BOUNCE);
        XJsonUtils.putAll(iexBounce, bounceJson);
        //possible keys: status, final-recipient, type, original_message_id
        Object hid1mailbody = XJsonUtils.getNodeByPathOrNull(json,"bounce_attach", "getbody", "text");
        if (hid1mailbody instanceof String) {
            String hid1mailText = (String) hid1mailbody;
            parseMessageId(hid1mailText);
            parseStatus(hid1mailText);
            parseAction(hid1mailText);
            parseDiagnosticCode(hid1mailText);
            parseMessageMailTypeAndWidgetSubtype(hid1mailText);
            parseFinalRecipient(hid1mailText);
            parseOriginalRecipient(hid1mailText);
            parseRemoteMTA(hid1mailText);
            parseReportingMTA(hid1mailText);
            parseFrom(hid1mailText);
            // parse bounce's type after all other parsings
            parseBounceTraits(hid1mailText);
        }
    }

    public String getBounceMid() {
        return bounceMid;
    }

    public void setBounceMid(final String mid) {
        this.mid = mid;
    }

    @Override
    public void response() {
        if (!mid.isEmpty()) {
            bounceJson.put("original_mid", mid);
        }
        XJsonUtils.renameKey(bounceJson, TYPE, "bounce_type");
        session.response(YandexHttpStatus.SC_OK, JsonType.NORMAL.toString(bounceJson()));
    }

    public Object getMessageId() {
        return messageId;
    }

    public Object bounceJson() {
        return bounceJson;
    }

    public List<BounceTraits> bounceTraits() {
        return bounceTraits;
    }

    @SuppressWarnings("unused")
    public String diagnosticCode() {
        return digCode;
    }

    public String originalFrom() {
        return from;
    }

    @SuppressWarnings("unused")
    public String originalRecipient() {
        return to;
    }

    public String senderDomain() {
        return senderDomain;
    }

    private void parseMessageId(final String mailText) {
        if (bounceJson.containsKey(MESSAGE_ID)) {
            messageId = bounceJson.get(MESSAGE_ID);
        }
        if (messageId == null) {
            ArrayList<String> msgs = XRegexpUtils.getMessageIdMail(mailText);
            if (!msgs.isEmpty()) {
                Set<String> st = new HashSet<>(msgs);
                msgs.clear();
                msgs.addAll(st);
                messageId = msgs;
            }
        }
        if (messageId == null) {
            XMessageToLog.warning(this, "Message-id not found for bounce.");
        } else {
            XMessageToLog.info(this, "Found Message-id: " + messageId);
            bounceJson.put(MESSAGE_ID, messageId);
        }
    }

    private void parseStatus(final String text) {
        String status = XRegexpUtils.getMailStatus(text);
        if (!status.isEmpty()) {
            bounceJson.put(STATUS, status);
        }
    }

    private void parseAction(final String text) {
        ArrayList<String> actions = XRegexpUtils.getAction(text);
        if (!actions.isEmpty()) {
            bounceJson.put(ACTION, actions);
        }
    }

    private void parseFinalRecipient(final String text) {
        String type = "";
        if (bounceJson.containsKey(TYPE)) {
            type = (String) bounceJson.get(TYPE);
        }
        boolean takeAllRecipients = false;
        if (type != null) {
            takeAllRecipients = type.equals(STR_NINE);
        }
        ArrayList<String> finalRec = XRegexpUtils.getFinalRecipient(text);
        Object actionsList = bounceJson.get(ACTION);
        if (actionsList instanceof List
            && ((List) actionsList).size() == finalRec.size())
        {
            ArrayList<String> newFinalRec = new ArrayList<>();
            int id = 0;
            for (Object x : (List) actionsList) {
                if (x.equals("failed") || takeAllRecipients) {
                    newFinalRec.add(finalRec.get(id++));
                }
            }
            finalRec = newFinalRec;
        }
        if (!finalRec.isEmpty()) {
            bounceJson.put("final_recipient", finalRec);
        }
    }

    private void parseMessageMailTypeAndWidgetSubtype(final String text) {
        String type = null;
        if (bounceJson.containsKey(STATUS)) {
            String status = (String) bounceJson.get(STATUS);
            Integer res = typeDict.getTypeOrNull(status);
            if (res != null) {
                type = String.valueOf(res);
            }
        }
        if (type == null) {
            // TODO: make map for different diagnostic codes
            String diagCode = (String) bounceJson.get(DIAGNOSTIC_CODE);
            if (diagCode != null
                && diagCode.contains("535 Authentication failed"))
            {
                type = String.valueOf(2);
            }
        }
        if (type == null) {
            if (XRegexpUtils.isMailCountLimit(text)) {
                type = String.valueOf(FIVE);
            }
        }
        bounceJson.put(TYPE, type);
        if (type == null) {
            bounceJson.put(WIDGET_SUBTYPE, "undefined");
        } else {
            bounceJson.put(WIDGET_SUBTYPE, BOUNCE);
        }
    }

    private void parseOriginalRecipient(final String text) {
        to = XRegexpUtils.getOriginalRecipient(text);
        if (!to.isEmpty()) {
            bounceJson.put(ORIGINAL_RECIPIENT, to);
        }
    }

    private void parseRemoteMTA(final String text) {
        String remoteMta = XRegexpUtils.getRemoteMTA(text);
        if (!remoteMta.isEmpty()) {
            bounceJson.put("remote_mta", remoteMta);
        }
    }

    private void parseDiagnosticCode(final String text) {
        digCode = XRegexpUtils.getDiagnosticCode(text);
        if (!digCode.isEmpty()) {
            bounceJson.put(DIAGNOSTIC_CODE, digCode);
        }
    }

    private void parseReportingMTA(final String text) {
        String repoMta = XRegexpUtils.getReportingMTA(text);
        if (!repoMta.isEmpty()) {
            bounceJson.put("reporting_mta", repoMta);
        }
    }

    private void parseFrom(final String text) {
        from = XRegexpUtils.getFrom(text);
        if (!from.isEmpty()) {
            bounceJson.put(ORIGINAL_FROM, from);
            senderDomain = XRegexpUtils.getSenderDomain(from);
        }
    }

    private void parseBounceTraits(final String text) {
        String s;
        if (!digCode.isEmpty()) {
            s = XRegexpUtils.getBounceSpam(digCode);
            if (!s.isEmpty()) {
                bounceTraits.add(BounceTraits.SPAM);
            }
            s = XRegexpUtils.getBounceRegular(digCode);
            if (!s.isEmpty()) {
                bounceTraits.add(BounceTraits.REGULAR);
            }
            s = XRegexpUtils.getBounceUnknown(digCode);
            if (!s.isEmpty()) {
                bounceTraits.add(BounceTraits.UNKNOWN);
            }
        }
        s = XRegexpUtils.getBounceSmtp(text);
        if (!s.isEmpty()) {
            bounceTraits.add(BounceTraits.SMTP);
        }
        s = XRegexpUtils.getBounceForward(text);
        if (!s.isEmpty()) {
            bounceTraits.add(BounceTraits.FORWARD);
        }
        if (!bounceTraits.contains(BounceTraits.REGULAR) && !bounceTraits.contains(BounceTraits.FORWARD)
                && (!from.isEmpty() || !to.isEmpty() || messageId == null))
        {
            bounceTraits.add(BounceTraits.INVALID);
        }
        bounceJson.put("bounce_traits", bounceTraits.stream().map(Enum::name).collect(Collectors.toList()));
    }
}
