package ru.yandex.iex.proxy;

import java.util.List;

/**
 * List of Solutions, sent to lucene
 */
public class CacheSentSolutions {
    private final List<Solution> solutions;
    private final long queueId;

    public CacheSentSolutions(
        final List<Solution> solutions,
        final long queueId)
    {
        this.solutions = solutions;
        this.queueId = queueId;
    }

    public CacheSentSolutions(final List<Solution> solutions) {
        this(solutions, Long.MIN_VALUE);
    }

    public List<Solution> solutions() {
        return solutions;
    }

    public long queueId() {
        return queueId;
    }
}
