package ru.yandex.iex.proxy;

import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.blackbox.BlackboxUserIdType;
import ru.yandex.dbfields.ChangeType;
import ru.yandex.dbfields.OracleFields;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;
import ru.yandex.parser.string.NonNegativeIntegerValidator;

public class ChangeContext extends AbstractContext {
    private final long prefix;
    private final ChangeType changeType;
    private final Long lcn;
    private final int offset;
    private final boolean isTteot;
    private final boolean zooQueueIsIexUpdate;
    private final boolean addReindexToAxis;
    private final List<String> updateCache;

    public ChangeContext(
            final IexProxy iexProxy,
            final ProxySession session,
            final Map<?, ?> json
    )
        throws HttpException, JsonUnexpectedTokenException
    {
        this(iexProxy, session, json, false, false, false, null);
    }

    public ChangeContext(
            final IexProxy iexProxy,
            final ProxySession session,
            final Map<?, ?> json,
            final boolean isTteot,
            final boolean zooQueueIsIexUpdate,
            final boolean addReindexToAxis,
            final List<String> updateCache
    )
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        prefix = ValueUtils.asLong(json.get("uid"));
        changeType =
            ValueUtils.asEnum(ChangeType.class, json.get("change_type"));
        lcn = ValueUtils.asLongOrNull(json.get(OracleFields.LCN));
        offset = session.params().get(
            "offset",
            0,
            NonNegativeIntegerValidator.INSTANCE);
        this.isTteot = isTteot;
        this.zooQueueIsIexUpdate = zooQueueIsIexUpdate;
        this.addReindexToAxis = addReindexToAxis;
        this.updateCache = updateCache;
    }

    @Override
    public long prefix() {
        return this.prefix;
    }

    @Override
    public BlackboxUserIdType prefixType() {
        return BlackboxUserIdType.UID;
    }

    @Override
    public boolean prefixUrl() {
        return true;
    }

    public ChangeType changeType() {
        return this.changeType;
    }

    @Override
    public Long lcn() {
        return lcn;
    }

    public int offset() {
        return this.offset;
    }

    public boolean isTteot() {
        return isTteot;
    }

    public boolean isOnline() {
        return !isTteot && !zooQueueIsIexUpdate && !addReindexToAxis;
    }

    public boolean zooQueueIsIexUpdate() {
        return zooQueueIsIexUpdate;
    }

    public boolean addReindexToAxis() {
        return addReindexToAxis;
    }

    public List<String> updateCache() {
        return updateCache;
    }
}
