package ru.yandex.iex.proxy;

import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.parser.uri.CgiParams;

public class ContentLineContext extends AbstractEntityContext {
    private static final int CONTENT_LINE_MAX_LENGTH = 360;

    private final Object clJson;
    private final String contentline;
    private final String firstline;
    private final String mdb;
    private final String stid;
    private final String suid;
    private final String pgShard;
    private final String mid;

    public ContentLineContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        final CgiParams params = session.params();
        firstline = params.getString("firstline");
        mdb = params.getString("mdb");
        mid = params.getString("mid");
        stid = params.getString("stid");
        uid = params.getLong("uid");
        if (mdb.equalsIgnoreCase("pg")) {
            pgShard = params.getString("pgshard", null);
            suid = null;
        } else {
            suid = params.getString("suid");
            pgShard = null;
        }

        clJson = json.get("contentline");
        if (clJson == null) {
            throw new BadRequestException(
                "No contentline json object found in iex solution");
        }
        if (!(clJson instanceof Map)) {
            throw new BadRequestException(
                "Contentline json object is not a Map");
        }
        final Map<?, ?> clMap = (Map<?, ?>) clJson;
        final Object clObject = clMap.get("text");
        if (clObject == null) {
            throw new BadRequestException(
                "No contentline text found in contentline json object");
        }
        contentline = truncateContentLine(clObject.toString().trim());
    }

    @SuppressWarnings("unused")
    public Object clJson() {
        return clJson;
    }

    public String contentline() {
        return iexProxy.contentlinePrefix() + contentline;
    }

    public String firstline() {
        return firstline;
    }

    public String mdb() {
        return mdb;
    }

    public String stid() {
        return stid;
    }

    public String suid() {
        return suid;
    }

    public String mid() {
        return mid;
    }

    public String pgShard() {
        return pgShard;
    }

    private static String truncateContentLine(final String cl) {
        return cl.substring(
            0,
            Math.min(CONTENT_LINE_MAX_LENGTH, cl.length()));
    }
}
