package ru.yandex.iex.proxy;

import java.util.Map;
import java.util.logging.Logger;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.parser.uri.QueryConstructor;

public class ContentLineHandler
    extends AbstractEntityHandler<ContentLineContext>
{
    private static final String SET_FIRSTLINE_URI = "/set-firstline?";

    public ContentLineHandler(final IexProxy iexProxy) {
        super(iexProxy, "contentline");
    }

    @Override
    protected ContentLineContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new ContentLineContext(iexProxy, session, json);
    }

    @Override
    @SuppressWarnings("FutureReturnValueIgnored")
    protected void handle(final ContentLineContext context)
        throws JsonUnexpectedTokenException, BadRequestException
    {
        final Logger logger = context.session().logger();
        if (context.firstline().equals(context.contentline())) {
            logger.info(
                "cl and fl are same for mid: " + context.mid());
            context.session().response(YandexHttpStatus.SC_OK);
        } else {
            if (context.iexProxy().msalEnabled(context.uid())) {
                logger.info(
                    "cl and fl are not same for mid: " + context.mid()
                    + ", trying to update");
                final QueryConstructor query =
                    new QueryConstructor(SET_FIRSTLINE_URI);

                query.append("mdb", context.mdb());
                query.append("mid", context.mid());
                if (context.mdb().equalsIgnoreCase("pg")) {
                    query.append("uid", context.uid());
                    if (context.pgShard() != null) {
                        query.append("pgshard", context.pgShard());
                    }
                } else {
                    query.append("suid", context.suid());
                }
                query.append("firstline", context.contentline());

                AsyncClient client = context.msalClient().adjust(context.session().context());

                final String request = query.toString();

                client.execute(
                    context.msalHost(),
                    new BasicAsyncRequestProducerGenerator(request),
                    EmptyAsyncConsumerFactory.OK,
                    context.session().listener().createContextGeneratorFor(client),
                    new MsalCallback(context)
                );
            } else {
                logger.info(
                    "Cl and fl are not same for mid: " + context.mid()
                    + ", but contentline is disabled for uid: "
                    + context.uid() + ", will not update.");
                context.session().response(YandexHttpStatus.SC_OK);
            }
        }
    }

    private static class MsalCallback
        extends AbstractProxySessionCallback<Object>
    {
        private final ContentLineContext context;

        MsalCallback(final ContentLineContext context) {
            super(context.session());
            this.context = context;
        }

        @Override
        public void completed(final Object voidResult) {
            context.session().response(YandexHttpStatus.SC_OK);
        }
    }
}

