package ru.yandex.iex.proxy;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.ByteArrayProcessable;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.AsyncStringConsumerFactory;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.xutils.spamreport.SpamReportSender;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.StringCollectorsFactory;
import ru.yandex.json.writer.JsonType;
import ru.yandex.mail.search.MailSearchParams;
import ru.yandex.parser.uri.QueryConstructor;

public class CorovaneerHandler implements HttpAsyncRequestHandler<JsonObject> {

    private final IexProxy iexProxy;
    private ProxySession session;

    public CorovaneerHandler(final IexProxy proxy) {
        this.iexProxy = proxy;
    }

    public void response() {
        session.response(
            HttpStatus.SC_OK,
            JsonType.NORMAL.toString(""));
    }

    @Override
    public HttpAsyncRequestConsumer<JsonObject> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException
    {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            throw new BadRequestException("Payload expected");
        }
        return new JsonAsyncTypesafeDomConsumer(
            ((HttpEntityEnclosingRequest) request).getEntity(),
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

    @Override
    public void handle(
        final JsonObject payload,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        session = new BasicProxySession(iexProxy, exchange, context);
        String stid = session.params().getString(MailSearchParams.STID);
        //Long uid = session.params().getLong(MailSearchParams.UID);

        session.logger().info("CorovaneerHandler: sending request to get eml");
            SpamReportSender.sendGetEmlRequest(
                iexProxy,
                session,
                stid,
                new EmlCallback(session));
    }

    private class EmlCallback
        extends AbstractProxySessionCallback<ByteArrayProcessable>
    {
        EmlCallback(final ProxySession session) {
            super(session);
        }

        @Override
        @SuppressWarnings("FutureReturnValueIgnored")
        public void completed(final ByteArrayProcessable result) {
            File emlFile = new File("mail.eml");
            try (
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FileOutputStream emlFileOut = new FileOutputStream(emlFile))
            {
                result.processWith(SpamReportSender.ByteArrayBodyFactory.INSTANCE).writeTo(baos);
                baos.writeTo(emlFileOut);
                QueryConstructor qc = new QueryConstructor("/eml");
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.setStrictMode();
                builder.setCharset(StandardCharsets.UTF_8);
                builder.setMimeSubtype("form-data");
                builder.setBoundary("just_simple_multi_boundary");
                builder.addPart("eml", new FileBody(emlFile));
                //HttpEntity entity = builder.build();
                BasicAsyncRequestProducerGenerator generator =
                    new BasicAsyncRequestProducerGenerator(
                        qc.toString(),
                        builder.build());
                generator.addHeader(
                    HttpHeaders.CONTENT_TYPE,
                    "multipart/form-data; boundary=just_simple_multi_boundary");
                generator.addHeader(
                    HttpHeaders.ACCEPT,
                    ContentType.APPLICATION_JSON.toString());
                generator.addHeader(
                    YandexHeaders.X_YA_SERVICE_TICKET,
                    iexProxy.corovaneerTvm2Ticket());
                AsyncClient client =
                    iexProxy.corovaneerClient().adjust(session.context());
                client.execute(
                    iexProxy.config().corovaneerConfig().host(),
                    generator,
                    AsyncStringConsumerFactory.OK,
                    session.listener().createContextGeneratorFor(client),
                    new CorovaneerCallback());
            } catch (IOException e) {
                session.logger().info("CorovaneerHandler: exception while constructing eml data");
                response();
            }
        }
    }

    private class CorovaneerCallback implements FutureCallback<String> {
        @Override
        public void cancelled() {
            session.logger().info("CorovaneerCallback: cancelled");
            response();
        }

        @Override
        public void failed(final Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            session.logger().info("CorovaneerCallback: failed with " + sw.toString());
            response();
        }

        @Override
        public void completed(final String result) {
            session.logger().info("CorovaneerCallback: completed with: <" + result + '>');
            response();
        }
    }
}

