package ru.yandex.iex.proxy;

import java.util.Map;

public class CutSolution {
    private Map<String, Object> cokemulatorSolutions;
    private Map<String, Object> postActionSolutions;
    private String mid;

    public CutSolution(
        final Map<String, Object> cokemulatorSolutions,
        final Map<String, Object> postActionSolutions,
        final String mid)
    {
        this.cokemulatorSolutions = cokemulatorSolutions;
        this.postActionSolutions = postActionSolutions;
        this.mid = mid;
    }

    @Override
    public String toString() {
        return "CutSolution for " + mid + ": coke: "
            + cokemulatorSolutions + ", post: " + postActionSolutions;
    }

    public Map<String, Object> cokemulatorSolutions() {
        return cokemulatorSolutions;
    }

    public Map<String, Object> postActionSolutions() {
        return postActionSolutions;
    }

    public void addCokeSolution(final String name, final Object result) {
        cokemulatorSolutions.put(name, result);
    }

    public void addPostActionSolution(final String name, final Object result) {
        postActionSolutions.put(name, result);
    }

    public String getMid() {
        return mid;
    }
}
