package ru.yandex.iex.proxy;

import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class DiscountEntityHandler
    extends AbstractEntityHandler<EmptyEntityContext>
{
    public DiscountEntityHandler(final IexProxy iexProxy) {
        super(iexProxy, "discount");
    }

    @Override
    protected EmptyEntityContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new EmptyEntityContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final EmptyEntityContext context)
        throws JsonUnexpectedTokenException, BadRequestException
    {
        context.session().response(YandexHttpStatus.SC_OK);
    }
}
