package ru.yandex.iex.proxy;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.parser.string.ValuesStorage;
import ru.yandex.parser.uri.CgiParams;

public class EntityOptions {
    public static final EntityOptions DEFAULT_OPTIONS = new EntityOptions();

    private final boolean skipSpam;
    private List<String> fromEmails = null;

    public <E extends Exception> EntityOptions(final ValuesStorage<E> params)
        throws E
    {
        skipSpam = params.getBoolean("skip-spam", DEFAULT_OPTIONS.skipSpam());
        fromEmails = ((CgiParams) params).getAll("from-emails");
    }

    // Merge options
    public EntityOptions(final EntityOptions lhs, final EntityOptions rhs) {
        skipSpam = lhs.skipSpam && rhs.skipSpam;
        if (fromEmails != null) {
            fromEmails.clear();
        }
        fromEmails = new ArrayList<>();
        fromEmails.addAll(lhs.fromEmails);
        fromEmails.addAll(rhs.fromEmails);
    }

    private EntityOptions() {
        skipSpam = true;
        fromEmails = new ArrayList<>();
    }

    public boolean skipSpam() {
        return skipSpam;
    }

    public List<String> fromEmails() {
        return fromEmails;
    }

    public static EntityOptions merge(final EntityOptions lhs, final EntityOptions rhs) {
        if (lhs == rhs) {
            return lhs;
        } else if (lhs == DEFAULT_OPTIONS) {
            return rhs;
        } else if (rhs == DEFAULT_OPTIONS) {
            return lhs;
        } else {
            return new EntityOptions(lhs, rhs);
        }
    }
}

