package ru.yandex.iex.proxy;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.iex.proxy.tickethandlerlegacy.TicketWidgetType;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class EventsContext extends AbstractEntityContext {
    public static final String PLACE_1 = "Place1";
    public static final String CALENDAR_EVENT = "CalendarEvent";
    public static final String EVENT = "Event";
    private static final String EVENTS = "events";
    private final long receivedDate;
    private String address = "";
    private String event = "";
    private Map<String, Object> calendarEventMap;
    private Object eventsJson;

    EventsContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        receivedDate =
            ValueUtils.asLong(session.params().getString("received_date"));
        if (json == null) {
            eventsJson = null;
        } else {
            eventsJson = json.get(EVENTS);
        }
        if (eventsJson != null) {
            try {
                calendarEventMap = getCalendarEventMap();
                if (calendarEventMap == null) {
                    eventsJson = null;
                } else {
                    if (calendarEventMap.containsKey(PLACE_1)) {
                        address =
                            ValueUtils.asString(calendarEventMap.get(PLACE_1));
                    }
                    if (calendarEventMap.containsKey(EVENT)) {
                        event =
                            ValueUtils.asString(calendarEventMap.get(EVENT));
                        XDataStructure.StopWords sw =
                            new XDataStructure.StopWords(
                                event,
                                new XDataStructure.SimpleStopWords(),
                                new XDataStructure.SimplePastVerbStopWords());
                        //TODO: mege checkres into one,
                        // in order to avoid multiple words scan
                        if (isEventBad(sw)) {
                            eventsJson = null;
                        } else {
                            sw.resetCheckers(
                                new XDataStructure.WidgetReliableWords());
                            if (sw.startChecking()) {
                                calendarEventMap.put(
                                    TicketWidgetType.TYPE,
                                    "reliable");
                            }
                        }
                    }
                }
            } catch (JsonUnexpectedTokenException e) {
                address = "";
            }
        }
    }

    public boolean isEventValid() {
        return address != null && !address.isEmpty() && eventsJson != null;
    }

    private boolean isEventBad(final XDataStructure.StopWords sw) {
        return !isQuotesGood(sw.getText())
            || sw.startChecking()
            || !isReceivedTimeGood();
    }

    private boolean isQuotesGood(final String s) {
        final String quotes = "'\"`"; // " ' `
        Deque<Character> stack = new ArrayDeque<>();
        for (final Character x: s.toCharArray()) {
            int idx = quotes.indexOf(x);
            if (idx != -1) {
                if (stack.isEmpty() || !stack.getLast().equals(x)) {
                    stack.add(x);
                } else {
                    stack.pollLast();
                }
            }
        }
        return stack.isEmpty();
    }

    private boolean isReceivedTimeGood() {
        Object date = calendarEventMap.get("Date");
        try {
            if (date != null) {
                String dateStr = ValueUtils.asString(date);
                return receivedDate < XTimeUtils.getTimestampISO8601(dateStr);
            }
        } catch (JsonUnexpectedTokenException e) {
        }
        return false;
    }

    public String getAddressPlace1() {
        return address;
    }

    public void pushInCalendarEvent(final String key, final Object value) {
        if (calendarEventMap != null) {
            calendarEventMap.put(key, value);
        }
    }

    @Override
    public void response() {
        session.response(
            YandexHttpStatus.SC_OK,
            JsonType.NORMAL.toString(eventsJson));
    }

    private Map<String, Object> getCalendarEventMap()
        throws JsonUnexpectedTokenException
    {
        List<?> l = ValueUtils.asList(eventsJson);
        for (final Object x: l) {
            Map<?, ?> m1 = ValueUtils.asMap(x);
            if (m1.containsKey(CALENDAR_EVENT)) {
                @SuppressWarnings("unchecked")
                Map<String, Object> res =
                    (Map<String, Object>)
                        ValueUtils.asMap(m1.get(CALENDAR_EVENT));
                return res;
            }
        }
        return null;
    }
}
