package ru.yandex.iex.proxy;

import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.geocoder.GeocoderResult;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.HttpExceptionConverter;
import ru.yandex.http.util.YandexHttpStatus;

public class EventsGeocallback implements FutureCallback<GeocoderResult> {
    private EventsContext context;

    public EventsGeocallback(final EventsContext context)
        throws BadRequestException
    {
        this.context = context;
    }

    @Override
    public void completed(final GeocoderResult result) {
        //Input: geo response
        //Output: empty - endpoint
        if (result.size() == 0) {
            context.response();
            return;
        }
        int precise = 0;
        double lat = (result.lowerLatitude(precise)
            + result.upperLatitude(precise)) / 2.0;
        double lon = (result.lowerLongitude(precise)
            + result.upperLongitude(precise)) / 2.0;
        context.pushInCalendarEvent("geocoder_lat", lat);
        context.pushInCalendarEvent("geocoder_lon", lon);
        context.response();
    }

    @Override
    public void cancelled() {
        this.context.session()
            .logger()
            .warning("Request cancelled: "
                + this.context.session().listener().details());
        context.session().response(YandexHttpStatus.SC_CLIENT_CLOSED_REQUEST);
    }

    @Override
    public void failed(final Exception e) {
        this.context.session()
            .logger()
            .log(Level.WARNING, "Failed to process: "
                + context.humanReadableJson()
                + '\n' + context.session().listener().details()
                + " because of exception", e);
        context.session().handleException(
            HttpExceptionConverter.toHttpException(e));
    }
}
