package ru.yandex.iex.proxy;

import java.util.Map;
import java.util.logging.Level;

import org.apache.http.HttpException;

import ru.yandex.geocoder.GeocoderClient;
import ru.yandex.geocoder.GeocoderRequest;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class EventsHandler extends AbstractEntityHandler<EventsContext> {
    EventsHandler(final IexProxy iexProxy) {
        super(iexProxy, "events");
    }

    @Override
    protected EventsContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new EventsContext(iexProxy, session, json);
    }

    @Override
    @SuppressWarnings("FutureReturnValueIgnored")
    protected void handle(final EventsContext context)
        throws JsonUnexpectedTokenException, BadRequestException
    {
        String address = context.getAddressPlace1();
        if (!context.isEventValid()) {
            context.response();
            return;
        }
        GeocoderClient client =
            context.iexProxy().geoSearchClient().adjust(
                context.session().context());
        try {
            GeocoderRequest request = new GeocoderRequest(
                context.iexProxy().config().geoSearchConfig());
            request.addHeader(
                YandexHeaders.X_YA_SERVICE_TICKET,
                context.iexProxy().geoTvm2Ticket());
            request.setText(address);
            client.execute(
                request,
                context.session().listener()
                    .createContextGeneratorFor(client),
                new EventsGeocallback(context)
            );
        } catch (BadRequestException e) {
            context.session().logger().log(
                Level.SEVERE,
                "GeoCoder request encoding failed",
                e);
            context.response();
        }
    }
}
