package ru.yandex.iex.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.util.YandexHttpStatus;

public class FactsCallback
    extends AbstractProxySessionCallback<List<Solution>>
{
    private FactsContext context;
    private FutureCallback<String> callback;

    FactsCallback(
        final FactsContext context,
        final FutureCallback<String> callback)
    {
        super(context.session());
        this.context = context;
        this.callback = callback;
    }

    public void putFact(
        final Map.Entry<String, Object> entry,
        final List<Object> facts,
        final String prefix)
    {
        final String factName = entry.getKey();
        final Object factObject = entry.getValue();
        final HashMap<String, Object> fact = new HashMap<>();
        final IexProxyConfig config = context.iexProxy.config();
        if (context.factNames().contains(factName)
            || (context.factNames().isEmpty()
            && !config.factNamesToEraseFactData().contains(factName)))
        {
            if (factObject instanceof Map) {
                final Map<?, ?> factMap = (Map<?, ?>) factObject;
                for (final Map.Entry<?, ?> factEntry : factMap.entrySet()) {
                    fact.put(
                        factEntry.getKey().toString(),
                        factEntry.getValue());
                }
            } else if (factObject instanceof List) {
                fact.put(prefix + factName, factObject);
            } else if (factObject == null) {
                fact.put("empty_solution", true);
            } else {
                session.logger().fine(
                    "Unhandled solution type for name <"
                    + factName + ">: " + factObject.getClass()
                    + ", expected Map");
                return;
            }
        }
        fact.put("taksa_widget_type_1234543456546", prefix + factName);
        facts.add(fact);
    }

    @Override
    public void completed(final List<Solution> facts) {
        context.session().logger().info("FactsCallback: "
            + "in completed with facts from FS");
        final LinkedHashMap<String, Object> response =
            new LinkedHashMap<>();
        String underscore = "_";
        if (context.getCachedFacts() != null) {
            for (final CutSolution solution
                    : context.getCachedFacts())
            {
                final List<Object> factsForMid =
                    new ArrayList<>(solution.
                            postActionSolutions().size());
                for (final Map.Entry<String, Object> entry
                    : solution.postActionSolutions().entrySet())
                {
                    putFact(entry, factsForMid, "");
                }
                if (context.cokedump()) {
                    for (final Map.Entry<String, Object> entry
                        : solution.cokemulatorSolutions().entrySet())
                    {
                        putFact(entry, factsForMid, underscore);
                    }
                }
                response.put(solution.getMid(), factsForMid);
            }
        }
        if (facts != null) {
            for (final Object o : facts) {
                final Solution solution = (Solution) o;
                final List<Object> factsForMid =
                    new ArrayList<>(solution.postActionSolutions().size());
                for (final Map.Entry<String, Object> entry
                    : solution.postActionSolutions().entrySet())
                {
                    putFact(entry, factsForMid, "");
                }
                if (context.cokedump()) {
                    for (final Map.Entry<String, Object> entry
                        : solution.cokemulatorSolutions().entrySet())
                    {
                        putFact(entry, factsForMid, underscore);
                    }
                }
                response.put(solution.context().mid(), factsForMid);
            }
        }
        String responseStr = context.jsonType().toString(response);
        if (callback != null) {
            callback.completed(responseStr);
        } else {
            session.response(YandexHttpStatus.SC_OK, responseStr);
        }
    }

    public FactsContext context() {
        return this.context;
    }
}
