package ru.yandex.iex.proxy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.parser.string.CollectionParser;

public class FactsContext extends AbstractGetMidsContext {
    private final JsonType jsonType;
    private final boolean cokedump;
    private final boolean updateCache;
    private List<CutSolution> cachedFacts = null;
    private Set<String> factNames;

    FactsContext(
        final ProxySession session,
        final IexProxy iexProxy)
        throws BadRequestException
    {
        super(session, iexProxy);
        if (mids().isEmpty()) {
            throw new BadRequestException("Missing required parameter mid");
        }
        this.jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
        this.cokedump = session.params().getBoolean("cokedump", false);
        this.updateCache = session.params().getBoolean("update_cache", true);
        this.factNames = session.params().get(
            "fact_names",
            Collections.emptySet(),
            new CollectionParser<>(String::trim, HashSet::new));
    }

    public JsonType jsonType() {
        return jsonType;
    }

    public boolean cokedump() {
        return cokedump;
    }

    public void addCachedFacts(final List<CutSolution> facts) {
        this.cachedFacts = facts;
    }

    public List<CutSolution> getCachedFacts() {
        return cachedFacts;
    }

    public boolean updateCache() {
        return updateCache;
    }

    public Set<String> factNames() {
        return factNames;
    }
}
