package ru.yandex.iex.proxy;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class FinesContext extends AbstractEntityContext {
    public static final String TYPE = "type";
    public static final String NOTIFICATION = "notification";
    public static final String STATUS = "status";
    public static final String PAID_FINE = "paid_fine";
    private Object finesJson;
    private Map<String, Object> output = new HashMap<>();

    FinesContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        if (json == null) {
            finesJson = null;
        } else {
            finesJson = json.get("fines");
            Map<?, ?> pFinesJson = null;
            if (finesJson instanceof List) {
                List<?> l = ValueUtils.asList(finesJson);
                if (l.size() > 0) {
                    XMessageToLog.warning(
                        this,
                        "Amount of fines is " + l.size());
                    pFinesJson = ValueUtils.asMap(chooseTheBiggestMBOResult(l));
                    putToOutPutFineType(pFinesJson);
                } else if (l.size() == 0) {
                    XMessageToLog.warning(this, "Empty list of fines");
                    finesJson = null;
                }
            } else if (finesJson instanceof Map) {
                pFinesJson = ValueUtils.asMap(finesJson);
                putToOutPutFineType(pFinesJson);
            } else {
                XMessageToLog.warning(this, "Undefined type of node in json");
                finesJson = null;
            }
            if (pFinesJson != null) {
                XJsonUtils.putAll(pFinesJson, output);
            }
        }
    }

    @Override
    public void response() {
        session.response(
            YandexHttpStatus.SC_OK,
            JsonType.NORMAL.toString(output));
    }

    private Map<?, ?> chooseTheBiggestMBOResult(final List<?> l) {
        Map<?, ?> res = null;
        for (Object x : l) {
            if (x instanceof Map) {
                if (res == null || res.size() < ((Map) x).size()) {
                    res = (Map<?, ?>) x;
                }
            }
        }
        return res;
    }

    private void putToOutPutFineType(final Map<?, ?> fine)
        throws JsonUnexpectedTokenException
    {
        Object url = fine.get("openstat");
        if (url instanceof String) {
            if (((String) url).contains("gibdd_inform;")) {
                output.put(PAID_FINE, true);
            }
        }
        Object type = fine.get(TYPE);
        Object notification = fine.get(NOTIFICATION);
        if (type instanceof String
            && ValueUtils.asString(type)
            .toLowerCase(Locale.getDefault()).contains("штраф"))
        {
            Object status = fine.get(STATUS);
            if (status instanceof String
                && ValueUtils.asString(status)
                .toLowerCase(Locale.getDefault()).contains("успешно"))
            {
                output.put(PAID_FINE, true);
            }
        } else if (notification instanceof String) {
            final String notif = ValueUtils.asString(notification)
                .toLowerCase(Locale.getDefault());
            if (notif.contains("выписан") || notif.contains("назначен")) {
                output.put("new_fine", true);
            }
        }
    }
}
