package ru.yandex.iex.proxy;

import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class FinesHandler extends AbstractEntityHandler<FinesContext> {
    FinesHandler(final IexProxy iexProxy) {
        super(iexProxy, "fines");
    }

    @Override
    protected FinesContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new FinesContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final FinesContext context)
        throws JsonUnexpectedTokenException, BadRequestException
    {
        context.response();
    }
}
