package ru.yandex.iex.proxy;

import java.util.concurrent.TimeUnit;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.request.util.SearchRequestText;

public final class GenerateLuceneRequestHelper {
    private static final String TRUE = "true";

    private GenerateLuceneRequestHelper() {
    }

    //CSOFF: ParameterNumber
    public static void query(
            final QueryConstructor query,
            final String searchFieldValue,
            final String requestText,
            final String getFields,
            final int updateDepth) throws BadRequestException
    {
        query.append(
            "dp",
            "contains(fact_data," + searchFieldValue + " valuematch)");
        query.append("postfilter", "valuematch == 1");
        query.append("get", getFields);
        query.append("text", requestText);
        if (updateDepth > 0) {
            query.append("collector", "pruning(fact_received_day_p)");
            query.append("length", updateDepth);
            query.append("desc", TRUE);
        } else {
            query.append("asc", TRUE);
        }
    }
    //CSON: ParameterNumber

    //CSOFF: ParameterNumber
    public static String generateRequestText(
            final String factName,
            final String searchFieldName,
            final String searchFieldValue,
            final long receivedDate,
            final int dayAgeLimit)
    {
        if (searchFieldValue == null || searchFieldValue.isEmpty()) {
            return null;
        }
        String searchFieldRequest = new SearchRequestText(
            searchFieldName + ' ' + searchFieldValue).fullEscape(false);
        String request = "fact_data:(" + searchFieldRequest + ')'
            + " AND fact_name:(" + factName + ')';
        if (dayAgeLimit > 0) {
            request += " AND fact_received_day_p:["
                + (receivedDate - TimeUnit.DAYS.toSeconds(dayAgeLimit))
                + " TO "
                + (receivedDate + TimeUnit.DAYS.toSeconds(1))
                + ']';
        }
        return request;
    }
    //CSON: ParameterNumber

    public static String getLuceneRequestPrefix() {
        return "/search?IO_PRIO=5000&json-type=dollar&sort=fact_received_date"
                + "&postfilter=fact_is_coke_solution+%21%3d+true"
                + "&prefix=";
    }
}
