package ru.yandex.iex.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.http.util.nio.AsyncStringConsumerFactory;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.search.document.mail.FirstlineMailMetaInfo;

public class GetTextHandler
    extends AbstractGetMidsHandler<GetTextContext, Object>
{
    public GetTextHandler(final IexProxy iexProxy) {
        super(iexProxy);
    }

    @Override
    protected GetTextContext createContext(
        final ProxySession session,
        final IexProxy iexProxy)
        throws HttpException
    {
        return new GetTextContext(session, iexProxy);
    }

    @Override
    protected AbstractFilterSearchCallback<Object> createFilterSearchCallback(
        final GetTextContext context,
        final Set<String> mids)
    {
        return new FilterSearchCallback(
            context,
            new GetTextCallback(context),
            mids);
    }

    @SuppressWarnings("FutureReturnValueIgnored")
    private static void getText(final AbstractCallback<Object> callback) {
        final AbstractContext cc = callback.context().abstractContext();
        String uri = "/get-text?stid=" + callback.context().stid();

        final AsyncClient client =
            cc.iexProxy().cokemulatorIexlibClient().adjust(
                cc.session().context());

        BasicAsyncRequestProducerGenerator producerGenerator =
            new BasicAsyncRequestProducerGenerator(uri);
        producerGenerator.addHeader(
            YandexHeaders.X_YA_SERVICE_TICKET,
            cc.iexProxy().tikaiteTvm2Ticket());
        producerGenerator.addHeader(
            YandexHeaders.X_SRW_SERVICE_TICKET,
            cc.iexProxy().unistorageTvm2Ticket());

        client.execute(
            cc.iexProxy().cokemulatorIexlibHost(),
            producerGenerator,
            AsyncStringConsumerFactory.OK,
            callback.context().abstractContext().session().listener()
                .createContextGeneratorFor(client),
            callback);
    }

    private static class FilterSearchCallback
        extends AbstractFilterSearchCallback<Object>
    {
        FilterSearchCallback(
            final AbstractContext context,
            final FutureCallback<List<Object>> callback,
            final Set<String> mids)
        {
            super(context, callback, mids);
        }

        @Override
        public AbstractCallback<Object> subMessageCallback(
            final IndexationContext<Object> indexationContext)
        {
            return new TextPassThroughtCallback(indexationContext);
        }

        @Override
        public void executeSubCallback(
            final AbstractCallback<Object> callback)
        {
        }

        @Override
        public void completed(final List<FirstlineMailMetaInfo> metas) {
            try {
                if (metas.isEmpty()) {
                    context.session().logger().info(
                        "All mids from " + mids + " have gone");
                    callback.completed(Collections.emptyList());
                } else {
                    MultiFutureCallback<Object> callback =
                        new MultiFutureCallback<>(this.callback);
                    List<AbstractCallback<Object>> callbacks =
                        new ArrayList<>(metas.size());
                    for (final FirstlineMailMetaInfo meta: metas) {
                        callbacks.add(
                            subMessageCallback(
                                new IndexationContext<Object>(
                                    context,
                                    meta,
                                    callback.newCallback())));
                    }
                    callback.done();
                    for (AbstractCallback<Object> fastCallback
                        : callbacks)
                    {
                        getText(fastCallback);
                    }
                }
            } catch (HttpException | JsonUnexpectedTokenException e) {
                failed(e);
            }
        }
    }

    private static class TextPassThroughtCallback
        extends AbstractCallback<Object>
    {
        TextPassThroughtCallback(final IndexationContext<Object> context) {
            super(context);
        }

        @Override
        public void completed(final Object response) {
            context.callback().completed(response);
        }
    }

    private static class GetTextCallback
        extends AbstractProxySessionCallback<List<Object>>
    {
        GetTextCallback(final GetTextContext context) {
            super(context.session());
        }

        @Override
        public void completed(final List<Object> texts) {
            if (texts.size() == 1) {
                session.response(
                    YandexHttpStatus.SC_OK,
                    texts.get(0).toString());
            } else {
                session.response(
                    YandexHttpStatus.SC_OK,
                    texts.toString());
            }
        }
    }
}
