package ru.yandex.iex.proxy;

import org.apache.http.concurrent.FutureCallback;

public class HandlerCallbackAdapter implements FutureCallback<Solution> {
    private final ActionHandler handler;
    private final HandlersContext context;

    public HandlerCallbackAdapter(
        final ActionHandler handler,
        final HandlersContext context)
    {
        this.handler = handler;
        this.context = context;
    }

    @Override
    public void cancelled() {
        this.context.cancelled(this.handler);
    }

    @Override
    public void completed(final Solution result) {
        this.context.completed(this.handler);
    }

    @Override
    public void failed(final Exception e) {
        this.context.failed(this.handler, e);
    }
}

