package ru.yandex.iex.proxy;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

import org.apache.http.HttpStatus;

import ru.yandex.blackbox.BlackboxUserIdType;
import ru.yandex.dbfields.ActionType;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.HttpExceptionConverter;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class HandlersContext extends AbstractContext {
    private static final String HANDLING = "Handling of actions ";
    private static final String MS = " ms";
    private static final double MILLIS = 1000.0D;
    private final long start = System.currentTimeMillis();
    private final long prefix;
    private final Map<ActionHandler, Set<ActionType>> handlers;
    private final AtomicInteger requestsLeft;
    private final boolean isTteot;
    private final boolean zooQueueIsIexUpdate;
    private final boolean addReindexToAxis;
    private final List<String> updateCache;

    // CSOFF: ParameterNumber
    @SuppressWarnings("unused")
    public HandlersContext(
            final IexProxy iexProxy,
            final ProxySession session,
            final Map<?, ?> json,
            final Map<ActionHandler, Set<ActionType>> handlers)
        throws JsonUnexpectedTokenException
    {
        this(iexProxy, session, json, handlers, false, false, false, null);
    }

    public HandlersContext(
            final IexProxy iexProxy,
            final ProxySession session,
            final Map<?, ?> json,
            final Map<ActionHandler, Set<ActionType>> handlers,
            final boolean isTteot,
            final boolean zooQueueIsIexUpdate,
            final boolean addReindexToAxis,
            final List<String> updateCache)
        throws JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        this.handlers = handlers;
        this.prefix = ValueUtils.asLong(json.get("uname"));
        this.requestsLeft = new AtomicInteger(handlers.size());
        this.isTteot = isTteot;
        this.zooQueueIsIexUpdate = zooQueueIsIexUpdate;
        this.addReindexToAxis = addReindexToAxis;
        this.updateCache = updateCache;
    }

    @Override
    public long prefix() {
        return this.prefix;
    }

    @Override
    public Long lcn() {
        return null;
    }

    @Override
    public BlackboxUserIdType prefixType() {
        return BlackboxUserIdType.SUID;
    }

    @Override
    public boolean prefixUrl() {
        return false;
    }

    public Map<ActionHandler, Set<ActionType>> handlers() {
        return this.handlers;
    }

    public void cancelled(final ActionHandler handler) {
        this.session.logger().info(HANDLING
                + this.handlers.get(handler)
                + " cancelled after "
                + (System.currentTimeMillis() - this.start)
                + MS);
        this.subrequestCompleted();
    }

    public void completed(final ActionHandler handler) {
        this.session.logger().info(HANDLING
                + this.handlers.get(handler)
                + " completed after "
                + (System.currentTimeMillis() - this.start)
                + MS);
        this.subrequestCompleted();
    }

    public void failed(final ActionHandler handler, final Exception e) {
        this.session.logger().log(Level.WARNING, HANDLING
                + this.handlers.get(handler)
                + " failed to process:\n"
                + this.humanReadableJson()
                + "\nafter "
                + (System.currentTimeMillis() - this.start)
                + " ms:\n" + this.session.listener().details(), e);
        session.handleException(HttpExceptionConverter.toHttpException(e));
    }

    private void subrequestCompleted() {
        if (this.requestsLeft.decrementAndGet() == 0) {
            long now = System.currentTimeMillis();
            this.session.logger().info("Processing lag: "
                    + (now - (long) (this.operationDate * MILLIS))
                    + MS);
            this.session.response(HttpStatus.SC_OK);
        }
    }

    public boolean isTteot() {
        return isTteot;
    }

    @SuppressWarnings("unused")
    public boolean zooQueueIsIexUpdate() {
        return zooQueueIsIexUpdate;
    }

    public boolean addReindexToAxis() {
        return addReindexToAxis;
    }

    @SuppressWarnings("unused")
    public List<String> updateCache() {
        return updateCache;
    }
}
