package ru.yandex.iex.proxy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.client.tvm2.Tvm2TicketRenewalTask;
import ru.yandex.client.wmi.FilterSearchErrorClassifier;
import ru.yandex.collection.Pattern;
import ru.yandex.concurrent.ThreadFactoryConfig;
import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.dbfields.ChangeType;
import ru.yandex.dbfields.OracleFields;
import ru.yandex.function.GenericFunction;
import ru.yandex.function.GenericNonThrowingCloseableAdapter;
import ru.yandex.function.HashMapFactory;
import ru.yandex.geocoder.GeocoderClient;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.proxy.StaticProxyHandler;
import ru.yandex.http.server.async.BaseAsyncServer;
import ru.yandex.http.server.async.DelegatedHttpAsyncRequestHandler;
import ru.yandex.http.server.async.PingHandler;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.EmptyFutureCallback;
import ru.yandex.http.util.HeadersParser;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.BasicAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.iex.proxy.advpaymenthandler.AdvPaymentDirectHandler;
import ru.yandex.iex.proxy.advpaymenthandler.AdvPaymentHandler;
import ru.yandex.iex.proxy.afisha.AfishaClient;
import ru.yandex.iex.proxy.calendar.CalendarLogHandler;
import ru.yandex.iex.proxy.combomailhandler.ComboMailHandler;
import ru.yandex.iex.proxy.complaints.EMLHandler;
import ru.yandex.iex.proxy.complaints.RulesDictUpdateHandler;
import ru.yandex.iex.proxy.cvhandler.CvHandler;
import ru.yandex.iex.proxy.edahandler.EdaExtendedHandler;
import ru.yandex.iex.proxy.edahandler.EdaHandler;
import ru.yandex.iex.proxy.eshophandler.EshopHandler;
import ru.yandex.iex.proxy.eventtickethandler.EventTicketHandler;
import ru.yandex.iex.proxy.eventtickethandler.PkpassHandler;
import ru.yandex.iex.proxy.hotelshandlerlegacy.HotelsHandler;
import ru.yandex.iex.proxy.images.ImagesFetcher;
import ru.yandex.iex.proxy.move.MoveHandler;
import ru.yandex.iex.proxy.newshandler.NewsAllUrlHandler;
import ru.yandex.iex.proxy.newshandler.NewsHandler;
import ru.yandex.iex.proxy.paymenthandler.PaymentHandler;
import ru.yandex.iex.proxy.refundhandler.CbkRegisterHandler;
import ru.yandex.iex.proxy.refundhandler.RefundHandler;
import ru.yandex.iex.proxy.refundhandler.RefundMailInfoHandler;
import ru.yandex.iex.proxy.refundhandler.RefundMidUidPairsHandler;
import ru.yandex.iex.proxy.refundhandler.RefundSettings;
import ru.yandex.iex.proxy.snippethandler.SnippetHandler;
import ru.yandex.iex.proxy.snippethandler.SnippetTextHandler;
import ru.yandex.iex.proxy.taxihandler.TaxiHandler;
import ru.yandex.iex.proxy.tickethandlerlegacy.TicketHandler;
import ru.yandex.iex.proxy.tomitahandler.TomitaHandler;
import ru.yandex.jniwrapper.JniWrapper;
import ru.yandex.jniwrapper.JniWrapperException;
import ru.yandex.json.async.consumer.JsonAsyncDomConsumer;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.ValueUtils;
import ru.yandex.logger.HandlersManager;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.proxy.universal.UniversalSearchProxy;
import ru.yandex.stater.CountAggregatorFactory;
import ru.yandex.stater.DuplexStaterFactory;
import ru.yandex.stater.FixedSetStater;
import ru.yandex.stater.IntegralSumAggregatorFactory;
import ru.yandex.stater.NamedStatsAggregatorFactory;
import ru.yandex.stater.PassiveStaterAdapter;
import ru.yandex.stater.RequestInfo;
import ru.yandex.stater.RequestTimeHistogramMetric;
import ru.yandex.stater.RequestsStater;
import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;
import ru.yandex.util.string.StringUtils;
import ru.yandex.util.timesource.TimeSource;

public class IexProxy
    extends UniversalSearchProxy<ImmutableIexProxyConfig>
    implements HttpAsyncRequestHandler<Object>
{
    public static final String VOID_ENTITY = "_VOID";
    public static final String DMARC_ENTITY = "dmarc";
    public static final String DELIM = "[,; ]+";
    public static final String SERVICE = "service";
    public static final String SERVICE_ORIGINAL = "service_original";
    public static final String FILTER_SEARCH_PARAMS = "order=default&full_folders_and_labels=1";
    public static final String CORP_FILTER_SEARCH_PARAMS = "order=default&folder_set=default&full_folders_and_labels=1";

    private static final String SAS = "sas";
    private static final String MAN = "man";
    private static final String VLA = "vla";
    private static final String MYT = "myt";
    private static final String USER_CHPOCK = "User<";
    private static final String MS_AMMM = "-ms_ammm";
    private static final String ASTERISK = "*";
    private static final String NOTIFY_TTEOT = "/notify-tteot";
    private static final String MESSAGE_TYPE_KEY_START = "message-type-";
    private static final String NOT_MESSAGE_TYPE_KEY_START = "exclude-message-type-";
    private static final String GET = RequestHandlerMapper.GET;
    private static final String POST = RequestHandlerMapper.POST;
    private static final int MAX_TYPE = 66;
    private static final int MAX_TYPE_COUNT = 5;
    private static final int PERC = 100;
    //private static final int TYPE_MASK = 0b111111;
    private static final Long ONE = 1L;
    private static final Long ZERO = 0L;
    private static final Set<Integer> DEFAULT_MIXED = Collections.emptySet();

    private final Map<ChangeType, ChangeHandler> changeHandlers =
        new EnumMap<>(ChangeType.class);

    private final AsyncClient iexClient;
    private final HttpHost iexHost;
    private final Tvm2TicketRenewalTask tvm2RenewalTask;
    private final HttpHost msalHost;
    private final HttpHost corpMsalHost;
    private final HttpHost mulcagateHost;
    private final HttpHost cokemulatorIexlibHost;
    private final HttpHost knnHost;
    private final BlackboxClient blackboxClient;
    private final BlackboxClient corpBlackboxClient;
    private final BlackboxClient blackboxDirectClient;
    private final AsyncClient postProcessClient;
    private final AsyncClient tikaiteClient;
    private final AsyncClient tikaiteMlClient;
    private final AsyncClient mulcagateClient;
    private final AsyncClient producerAsyncClient;
    private final AsyncClient soProducerClient;
    private final AsyncClient knnClient;
    private final AsyncClient mopsClient;
    private final AsyncClient corpMopsClient;
    private final AsyncClient cokemulatorIexlibClient;
    private final AsyncClient msalClient;
    private final AsyncClient corpMsalClient;
    private final AsyncClient raspClient;
    private final AsyncClient refundClient;
    private final AsyncClient rcaClient;
    private final URI rcaURI;
    private final AsyncClient marketClient;
    private final AsyncClient bkClient;
    private final AsyncClient mediaClient;
    private final AsyncClient gettextClient;
    private final AsyncClient gatemailClient;
    private final AsyncClient calendarClient;
    private final AsyncClient calendarToolsClient;
    private final AsyncClient corovaneerClient;
    private final AsyncClient msearchClient;
    private final AsyncClient onlineDBClient;
    private final AsyncClient reminderClient;
    private final AsyncClient axisClient;
    private final AsyncClient complaintsClient;
    private final AsyncClient complaintsCoworkersSelectionClient;
    private final AsyncClient sologgerClient;
    private final AsyncClient freemailClient;
    private final AsyncClient settingsApiClient;
    private final AsyncClient corpSettingsApiClient;
    private final AsyncClient xivaClient;
    private final AsyncClient smartobjectClient;
    private final AsyncClient xivaCorpClient;
    private final AsyncClient taksaClient;
    private final AsyncClient taksaTestingClient;
    private final AsyncClient neuroHardsClient;
    private final URI axisURI;
    private final AsyncClient factsExtractClient;
    private final URI factsExtractURI;
    private final GeocoderClient geoSearchClient;
    private final AsyncClient kinopoiskQlClient;
    private final AfishaClient afishaClient;
    private final AsyncClient filterSearchClient;
    private final String filterSearchUri;
    private final AsyncClient corpFilterSearchClient;
    private final String corpFilterSearchUri;
    private final AsyncClient foldersClient;
    private final AsyncClient corpFoldersClient;
    private final AsyncClient labelsClient;
    private final AsyncClient corpLabelsClient;
    private final AsyncClient attachSidClient;
    private final AsyncClient corpAttachSidClient;
    private final ImagesFetcher imagesFetcher;
    private final String axisQueueName;
    private final String xIndexOperationQueueNameBacklog;
    private final String xIndexOperationQueueNameFacts;
    private final String xIndexOperationQueueNameUpdate;
    private final String mailSearchQueueName;
    private final String corpMailSearchQueueName;
    private final long almostAllFactsTimeout;
    private final IexProxyLogger iexProxylogger;
    private final Logger complLogger;
    private final Logger complYtLogger;
    private final Logger sobbYtLogger;
    private final boolean msalEnabled;
    private final boolean narrowType;
    private final boolean ignoreEmptySolution;
    private final Set<String> msalEnabledUids;
    private final Set<String> axisFacts;
    private final Set<String> noJournalingFacts;
    private final Set<String> noCacheFacts;
    private final Set<Long> soTrustedUsers;
    private final Set<Long> soAlarmUsers;
    private final Set<Long> soTrustedCoworkers;
    private final String contentlinePrefix;

    private final Map<Set<Integer>, Set<String>> messageTypeHeadersMap;
    private final Map<String, Set<String>> domainHeadersMap;
    private final Map<Set<Integer>, Map<String, EntityOptions>> messageTypeEntitiesMap;
    private final Map<Set<Integer>, Map<String, EntityOptions>> messageTypeNotEntitiesMap;
    private final Map<Set<Integer>, Set<PostProcessAction>>
            messageTypePostProcessMap;
    private final Map<Set<Integer>, Set<PostProcessAction>>
            messageTypeNotPostProcessMap;
    private final Map<String, Map<String, EntityOptions>> emailEntitiesMap;
    private final Map<String, Set<PostProcessAction>> emailPostProcessMap;
    private final Map<String, Map<String, EntityOptions>> rcptEmailEntitiesMap;
    private final Map<String, Set<PostProcessAction>> rcptEmailPostProcessMap;
    private final Map<Long, Map<String, EntityOptions>> rcptUidEntitiesMap;
    private final Map<Long, Set<PostProcessAction>> rcptUidPostProcessMap;
    private final Map<String, Map<String, EntityOptions>> domainEntitiesMap;
    private final Map<String, Set<PostProcessAction>> domainPostProcessMap;
    private final Map<Long, TimeFrameQueue<Long>> rcptUidStoreSignals;
    private final TimeFrameQueue<Long> filterSearchCompletions;
    private final TimeFrameQueue<Long> luceneCompletions;
    private final TimeFrameQueue<Long> cokemulatorCompletions;
    private final TimeFrameQueue<Long> producerClientCompletions;
    private final TimeFrameQueue<IntegerPair> factsCacheHitRatios;
    private final TimeFrameQueue<IntegerPair> actualFactsCacheHitRatios;
    private final TimeFrameQueue<IntegerPair> urlsToRcaAndTotalUrlsCount;
    private final TimeFrameQueue<FactsHandler> producerClientSearchMapCounter;
    private final TimeFrameQueue<FactsHandler> producerClientTotalCounter;
    private final TimeFrameQueue<Long> lucenePureTimes;
    private final TimeFrameQueue<Long> sasLuceneTimes;
    private final TimeFrameQueue<Long> manLuceneTimes;
    private final TimeFrameQueue<Long> mytLuceneTimes;
    private final TimeFrameQueue<Long> vlaLuceneTimes;
    private final TimeFrameQueue<Long> otherLuceneTimes;
    private final TimeFrameQueue<Long> sasLuceneAnswerSelected;
    private final TimeFrameQueue<Long> manLuceneAnswerSelected;
    private final TimeFrameQueue<Long> mytLuceneAnswerSelected;
    private final TimeFrameQueue<Long> vlaLuceneAnswerSelected;
    private final TimeFrameQueue<Long> otherLuceneAnswerSelected;

    private final TimeFrameQueue<Long> producerClientPureTimes;
    private final TimeFrameQueue<Long> cacheStoreTimes;
    private final TimeFrameQueue<Long> axisStoreTimes;
    private final TimeFrameQueue<Long> mainExtractTimes;
    private final TimeFrameQueue<Long> attachExtractTimes;
    private final TimeFrameQueue<Long> postActionsTimes;
    //images download
    private final TimeFrameQueue<Long> imagesMidDownloadTimes;
    private final TimeFrameQueue<Long> imageDownloadRequests;
    private final TimeFrameQueue<Long> imageDownloadFails;
    private final TimeFrameQueue<Long> midImagesDownloaded;

    private final TimeFrameQueue<Long> factsSporadicTimerWakeup;

    private final TimeFrameQueue<Long> raspRequestCompletions;
    private final TimeFrameQueue<Long> requestsWithTypesParamCounter;
    private final TimeFrameQueue<Long> calendarLogParsingFails;
    private final TimeFrameQueue<Long> taksaRequestCompletions;
    private final TimeFrameQueue<Long> rcaRequestCompletions;
    private final TimeFrameQueue<Long> spamComplaints;
    private final TimeFrameQueue<Long> hamComplaints;
    private final TimeFrameQueue<Long> trustedSpamComplaints;
    private final TimeFrameQueue<Long> trustedSpamFreshComplaints;
    private final TimeFrameQueue<Long> trustedHamComplaints;
    private final RequestsStater raspRequestsStater;
    private final RequestsStater geoRequestsStater;
    private final RequestsStater rcaRequestsStater;
    private final RequestsStater incomingLagStater;
    private final RequestsStater processingLagStater;
    private final TimeFrameQueue<Long> abusesGetRequestsStater;
    private final TimeFrameQueue<Long> abusesPutRequestsStater;

    // ForwardHandler may add to this queue
    private final TimeFrameQueue<String> reportedForwards;

    private final IniConfig entitiesTimeStamps;
    private final IniConfig urlsWhitelistRegexp;
    private final File urlsWhitelistRegexpFile;
    private Map<String, Long> factNameToActualData;
    private List<java.util.regex.Pattern> urlsWhitelistRules;
    private Map<String, Set<String>> mediaFiscalRules;
    private final File mediaFiscalFile;
    private Map<String, RefundSettings> refundRulesEmail;
    private Map<String, RefundSettings> refundRulesDomain;
    private final File refundRulesFile;
    private final Predicate<InetAddress> yandexNets;

    //CSOFF: MethodLength
    public IexProxy(final ImmutableIexProxyConfig config)
        throws ConfigException,
            HttpException,
            IOException,
            JniWrapperException,
            JsonException,
            URISyntaxException
    {
        super(config);

        {
            HandlersManager handlersManager = new HandlersManager();
            final Logger requestDumpLogger = config.reqresLog().build(handlersManager);
            iexProxylogger = new IexProxyLogger(requestDumpLogger);
            registerLoggerForLogrotate(requestDumpLogger);
            complLogger = config.complaintsConfig().complLog().build(handlersManager);
            registerLoggerForLogrotate(complLogger);
            complYtLogger = config.complaintsConfig().ytLog().build(handlersManager);
            registerLoggerForLogrotate(complYtLogger);
            sobbYtLogger = config.sobbYtLog().build(handlersManager);
            registerLoggerForLogrotate(sobbYtLogger);
        }
        iexClient = client("IEX", config.iexConfig());
        iexHost = config.iexConfig().host();
        tvm2RenewalTask = new Tvm2TicketRenewalTask(
            logger().addPrefix("tvm2"),
            serviceContextRenewalTask,
            config.tvm2ClientConfig());

        blackboxClient =
            registerClient(
                "Blackbox",
                new BlackboxClient(reactor, config.blackboxConfig()),
                config.blackboxConfig());

        corpBlackboxClient =
            registerClient(
                "CorpBlackbox",
                new BlackboxClient(reactor, config.corpBlackboxConfig()),
                config.corpBlackboxConfig());

        blackboxDirectClient =
            registerClient(
                "BlackboxDirect",
                new BlackboxClient(reactor, config.blackboxDirectConfig()),
                config.blackboxDirectConfig());

        postProcessClient = client("PostProcess", config.postProcessConfig());
        tikaiteClient = client("Tikaite", config.tikaiteConfig());
        tikaiteMlClient = client("TikaiteMl", config.tikaiteMlConfig());

        mulcagateClient = client("Mulcagate", config.mulcagateConfig());
        mulcagateHost = config.mulcagateConfig().host();

        ImmutableHttpHostConfig producerAsyncClientConfig = config.producerAsyncClientConfig();
        if (producerAsyncClientConfig == null) {
            producerAsyncClient = null;
        } else {
            producerAsyncClient = client("AsyncProducer", producerAsyncClientConfig);
        }
        if (config.soProducerConfig() == null) {
            soProducerClient = null;
        } else {
            soProducerClient = client("SOProducer", config.soProducerConfig());
        }
        smartobjectClient = client("SmartObject", config.smartObjectConfig());
        knnHost = config.knnConfig().host();
        knnClient = client("KNN", config.knnConfig());
        mopsClient = client("MOPS", config.mopsConfig());
        corpMopsClient = client("CorpMOPS", config.corpMopsConfig());
        cokemulatorIexlibClient = client("Cokemulator", config.cokemulatorIexlibConfig());
        cokemulatorIexlibHost = config.cokemulatorIexlibConfig().host();
        axisClient = client("Axis", config.axisConfig());
        complaintsClient = client("Complaints", config.complaintsConfig());
        config.complaintsConfig().registerComponents(this);
        complaintsCoworkersSelectionClient =
            client("ComplaintsCoworkersSelection", config.complaintsCoworkersSelectionConfig());
        sologgerClient = client("Sologger", config.sologgerConfig());
        freemailClient = client("Freemail", config.freemailConfig());
        settingsApiClient = client("SettingsAPI", config.settingsApiConfig());
        corpSettingsApiClient = client("CorpSettingsAPI", config.corpSettingsApiConfig());
        imagesFetcher = new ImagesFetcher(client("ZoraProxy", config.zoraProxyConfig()), this);

        axisURI = config.axisConfig().uri();
        rcaClient = client("Rca", config.rcaURIConfig());
        rcaURI = config.rcaURIConfig().uri();
        factsExtractClient = client("FactsExtract", config.factsExtractURIConfig());
        factsExtractURI = config.factsExtractURIConfig().uri();
        axisQueueName = config.axisQueueName();
        xIndexOperationQueueNameBacklog = config.xIndexOperationQueueNameBacklog();
        xIndexOperationQueueNameFacts = config.xIndexOperationQueueNameFacts();
        xIndexOperationQueueNameUpdate = config.xIndexOperationQueueNameUpdate();
        mailSearchQueueName = config.mailSearchQueueName();
        corpMailSearchQueueName = config.corpMailSearchQueueName();
        almostAllFactsTimeout = config.almostAllFactsTimeout();
        msalClient = client("MSAL", config.msalConfig());
        corpMsalClient = client("CorpMSAL", config.corpMsalConfig());
        msalHost = config.msalConfig().host();
        corpMsalHost = config.corpMsalConfig().host();
        raspClient = client("Rasp", config.raspConfig());
        refundClient = client("Refund", config.refundConfig());
        marketClient = client("Market", config.marketConfig());
        bkClient = client("Bk", config.bkConfig());
        mediaClient = client("Media", config.mediaConfig());
        gettextClient = client("Gettext", config.gettextConfig());
        gatemailClient = client("Gatemail", config.gatemailConfig());
        calendarClient = client("Calendar", config.calendarConfig());
        calendarToolsClient = client("CalendarTools", config.calendarToolsConfig());
        corovaneerClient = client("Corovaneer", config.corovaneerConfig());
        msearchClient = client("Msearch", config.msearchConfig());
        onlineDBClient = client("OnlineDB", config.onlineDBConfig());
        reminderClient = client("Reminder", config.reminderConfig());
        xivaClient = client("Xiva", config.xivaConfig());
        xivaCorpClient = client("XivaCorp", config.xivaCorpConfig());
        taksaClient = client("Taksa", config.taksaConfig());
        taksaTestingClient = client("TaksaTesting", config.taksaTestingConfig());
        neuroHardsClient = client("NeuroHards", config.neuroHardsConfig());
        geoSearchClient =
            registerClient(
                "Geo",
                new GeocoderClient(reactor, config.geoSearchConfig()),
                config.geoSearchConfig());
        kinopoiskQlClient = client("Kinopoisk", config.kinopoiskQlConfig());
        afishaClient =
            registerClient(
                "Afisha",
                new AfishaClient(reactor, config.afishaConfig()),
                config.afishaConfig());
        filterSearchClient = client("FilterSearch", config.filterSearchConfig(), FilterSearchErrorClassifier.INSTANCE);
        filterSearchUri =
            config.filterSearchConfig().uri().toASCIIString()
                + config.filterSearchConfig().firstCgiSeparator()
                + FILTER_SEARCH_PARAMS;
        corpFilterSearchClient = client("CorpFilterSearch",
            config.corpFilterSearchConfig(),
            FilterSearchErrorClassifier.INSTANCE);
        corpFilterSearchUri =
            config.corpFilterSearchConfig().uri().toASCIIString()
                + config.corpFilterSearchConfig().firstCgiSeparator()
                + CORP_FILTER_SEARCH_PARAMS;
        foldersClient = client("Folders", config.foldersConfig());
        corpFoldersClient = client("CorpFolders", config.corpFoldersConfig());
        labelsClient = client("Labels", config.labelsConfig());
        corpLabelsClient = client("CorpLabels", config.corpLabelsConfig());
        attachSidClient = client("AttachSid", config.attachSidConfig());
        corpAttachSidClient = client("CorpAttachSid", config.corpAttachSidConfig());
        luceneCompletions = new TimeFrameQueue<>(config.metricsTimeFrame());
        registerStater(
            new PassiveStaterAdapter<>(
                luceneCompletions,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "lucene-total-time_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "lucene-requests_ammm",
                        CountAggregatorFactory.INSTANCE))));
        filterSearchCompletions = new TimeFrameQueue<>(config.metricsTimeFrame());
        registerStater(
            new PassiveStaterAdapter<>(
                filterSearchCompletions,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "filter-search-total-time_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "filter-search-requests_ammm",
                        CountAggregatorFactory.INSTANCE))));
        cokemulatorCompletions = new TimeFrameQueue<>(config.metricsTimeFrame());
        registerStater(
            new PassiveStaterAdapter<>(
                cokemulatorCompletions,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "cokemulator-total-time_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "cokemulator-requests_ammm",
                        CountAggregatorFactory.INSTANCE))));
        producerClientCompletions = new TimeFrameQueue<>(config.metricsTimeFrame());
        registerStater(
            new PassiveStaterAdapter<>(
                producerClientCompletions,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "producerClient-total-time_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "producerClient-requests_ammm",
                        CountAggregatorFactory.INSTANCE))));
        factsCacheHitRatios = new TimeFrameQueue<>(config.metricsTimeFrame());
        actualFactsCacheHitRatios = new TimeFrameQueue<>(config.metricsTimeFrame());
        urlsToRcaAndTotalUrlsCount = new TimeFrameQueue<>(config.metricsTimeFrame());
        producerClientSearchMapCounter = new TimeFrameQueue<>(config.metricsTimeFrame());
        registerStater(
            new PassiveStaterAdapter<>(
                producerClientSearchMapCounter,
                new NamedStatsAggregatorFactory<>(
                    "producerClient-searchmap-responses_ammm",
                    CountAggregatorFactory.INSTANCE)));
        producerClientTotalCounter = new TimeFrameQueue<>(config.metricsTimeFrame());
        registerStater(
            new PassiveStaterAdapter<>(
                producerClientTotalCounter,
                new NamedStatsAggregatorFactory<>(
                    "producerClient-total-responses_ammm",
                    CountAggregatorFactory.INSTANCE)));
        raspRequestCompletions = new TimeFrameQueue<>(config.metricsTimeFrame());
        registerStater(
            new PassiveStaterAdapter<>(
                raspRequestCompletions,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "rasp-empty-response_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "rasp-total-requests_ammm",
                        CountAggregatorFactory.INSTANCE))));
        raspRequestsStater = config.raspStaterConfig().build();
        geoRequestsStater = config.geoStaterConfig().build();
        rcaRequestCompletions = new TimeFrameQueue<>(config.metricsTimeFrame());
        registerStater(
            new PassiveStaterAdapter<>(
                rcaRequestCompletions,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "rca-empty-response_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "rca-total-requests_ammm",
                        CountAggregatorFactory.INSTANCE))));
        rcaRequestsStater = config.rcaStaterConfig().build();
        requestsWithTypesParamCounter = new TimeFrameQueue<>(config.metricsTimeFrame());
        registerStater(
            new PassiveStaterAdapter<>(
                requestsWithTypesParamCounter,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "requests-with-unknown-message-types_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "requests-with-types-param-total_ammm",
                        CountAggregatorFactory.INSTANCE))));
        taksaRequestCompletions = new TimeFrameQueue<>(config.metricsTimeFrame());
        registerStater(
            new PassiveStaterAdapter<>(
                taksaRequestCompletions,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "taksa-empty-response_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "taksa-total-requests_ammm",
                        CountAggregatorFactory.INSTANCE))));
        lucenePureTimes = new TimeFrameQueue<>(config.metricsTimeFrame());
        sasLuceneTimes = new TimeFrameQueue<>(config.metricsTimeFrame());
        manLuceneTimes = new TimeFrameQueue<>(config.metricsTimeFrame());
        mytLuceneTimes = new TimeFrameQueue<>(config.metricsTimeFrame());
        vlaLuceneTimes = new TimeFrameQueue<>(config.metricsTimeFrame());
        otherLuceneTimes = new TimeFrameQueue<>(config.metricsTimeFrame());

        sasLuceneAnswerSelected = new TimeFrameQueue<>(config.metricsTimeFrame());
        manLuceneAnswerSelected = new TimeFrameQueue<>(config.metricsTimeFrame());
        mytLuceneAnswerSelected = new TimeFrameQueue<>(config.metricsTimeFrame());
        vlaLuceneAnswerSelected = new TimeFrameQueue<>(config.metricsTimeFrame());
        otherLuceneAnswerSelected = new TimeFrameQueue<>(config.metricsTimeFrame());

        producerClientPureTimes = new TimeFrameQueue<>(config.metricsTimeFrame());

        factsSporadicTimerWakeup = new TimeFrameQueue<>(config.metricsTimeFrame());

        spamComplaints = new TimeFrameQueue<>(config.metricsTimeFrame());
        trustedSpamComplaints = new TimeFrameQueue<>(config.metricsTimeFrame());
        trustedSpamFreshComplaints = new TimeFrameQueue<>(config.metricsTimeFrame());
        hamComplaints = new TimeFrameQueue<>(config.metricsTimeFrame());
        trustedHamComplaints = new TimeFrameQueue<>(config.metricsTimeFrame());
        abusesGetRequestsStater = new TimeFrameQueue<>(config.metricsTimeFrame());
        abusesPutRequestsStater = new TimeFrameQueue<>(config.metricsTimeFrame());

        cacheStoreTimes = new TimeFrameQueue<>(config.metricsTimeFrame());
        axisStoreTimes = new TimeFrameQueue<>(config.metricsTimeFrame());
        mainExtractTimes = new TimeFrameQueue<>(config.metricsTimeFrame());
        attachExtractTimes = new TimeFrameQueue<>(config.metricsTimeFrame());
        postActionsTimes = new TimeFrameQueue<>(config.metricsTimeFrame());

        imagesMidDownloadTimes = new TimeFrameQueue<>(config.metricsTimeFrame());
        imageDownloadRequests = new TimeFrameQueue<>(config.metricsTimeFrame());
        imageDownloadFails = new TimeFrameQueue<>(config.metricsTimeFrame());
        midImagesDownloaded = new TimeFrameQueue<>(config.metricsTimeFrame());
        calendarLogParsingFails = new TimeFrameQueue<>(config.metricsTimeFrame());

        reportedForwards = new TimeFrameQueue<>(config.metricsTimeFrame());

        RequestTimeHistogramMetric lagMetricBuilder =
            new RequestTimeHistogramMetric(
                new IniConfig(
                    new StringReader(
                        "histogram-ranges = 0, 100, 300, 600, 1000, "
                        + "3000, 6000, 10000, 30000, 60000, 100000, "
                        + "300000, 600000, 1000000\n"
                        + "precise-histogram = false\n"
                        + "processing-time-stats = false")));

        incomingLagStater =
            new RequestsStater(
                config.metricsTimeFrame(),
                "incoming-lag",
                Collections.singletonList(lagMetricBuilder),
                "lag",
                "Requests lag");
        registerStater(incomingLagStater);

        processingLagStater =
            new RequestsStater(
                config.metricsTimeFrame(),
                "processing-lag",
                Collections.singletonList(lagMetricBuilder),
                "lag",
                "Requests lag");
        registerStater(processingLagStater);

        registerStater(
            new PassiveStaterAdapter<>(
                spamComplaints,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "complaints-spam-messages_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "complaints-spam-requests_ammm",
                        CountAggregatorFactory.INSTANCE))));
        registerStater(
            new PassiveStaterAdapter<>(
                hamComplaints,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "complaints-ham-messages_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "complaints-ham-requests_ammm",
                        CountAggregatorFactory.INSTANCE))));
        registerStater(
            new PassiveStaterAdapter<>(
                trustedSpamComplaints,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "complaints-spam-trusted-messages_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "complaints-spam-trusted-requests_ammm",
                        CountAggregatorFactory.INSTANCE))));
        registerStater(
            new PassiveStaterAdapter<>(
                trustedSpamFreshComplaints,
                new NamedStatsAggregatorFactory<>(
                    "complaints-spam-trusted-fresh-requests_ammm",
                    CountAggregatorFactory.INSTANCE)));
        registerStater(
            new PassiveStaterAdapter<>(
                trustedHamComplaints,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "complaints-ham-trusted-messages_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "complaints-ham-trusted-requests_ammm",
                        CountAggregatorFactory.INSTANCE))));
        registerStater(
            new PassiveStaterAdapter<>(
                abusesGetRequestsStater,
                new NamedStatsAggregatorFactory<>(
                    "complaints-abuses-get-requests_ammm",
                    CountAggregatorFactory.INSTANCE)));
        registerStater(
            new PassiveStaterAdapter<>(
                abusesPutRequestsStater,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "complaints-abuses-put-docs_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "complaints-abuses-put-requests_ammm",
                        CountAggregatorFactory.INSTANCE))));

        registerStater(
            new PassiveStaterAdapter<>(
                imageDownloadRequests,
                new NamedStatsAggregatorFactory<>("imagedownload-requests_ammm", CountAggregatorFactory.INSTANCE)));
        registerStater(
            new PassiveStaterAdapter<>(
                imageDownloadFails,
                new NamedStatsAggregatorFactory<>("imagedownload-fails_ammm", CountAggregatorFactory.INSTANCE)));
        registerStater(
            new PassiveStaterAdapter<>(
                midImagesDownloaded,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "imagedownload-selected-changed_ammm",
                        IntegralSumAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "imagedownload-ok_ammm",
                        CountAggregatorFactory.INSTANCE))));
        registerStater(
            new PassiveStaterAdapter<>(
                calendarLogParsingFails,
                new NamedStatsAggregatorFactory<>("calendarlog-parsing-fails_ammm", CountAggregatorFactory.INSTANCE)));
        registerStater(new TimingsStater());
        String extraStats = config.extraSettingsConfig().getOrNull("extra_stats");
        if (extraStats != null) {
            registerStater(
                new FixedSetStater<>(
                    reportedForwards,
                    HashMapFactory.instance(),
                    ForwardHandler.forwardStats(extraStats.split(",")),
                    "forwarded_",
                    "forwarded",
                    "forwarded",
                    null,
                    null));
        }
        handlersInitialization();
        narrowType = config.entitiesSection().getBoolean("narrow-type", true);
        //Headers by type
        final HeadersMapProcessor headersProcessor = new HeadersMapProcessor();
        messageTypeMapInit(config.headersSection(), headersProcessor);
        messageTypeHeadersMap = headersProcessor.map();
        //Entities by type
        final EntitiesMapProcessor entitiesProcessor = new EntitiesMapProcessor();
        messageTypeMapInit(config.entitiesSection(), entitiesProcessor);
        messageTypeEntitiesMap = entitiesProcessor.map();
        messageTypeNotEntitiesMap = entitiesProcessor.notMap();
        final PostProcessMapProcessor postProcessProcessor = new PostProcessMapProcessor();
        messageTypeMapInit(config.postProcessSection(), postProcessProcessor);
        messageTypePostProcessMap = postProcessProcessor.map();
        messageTypeNotPostProcessMap = postProcessProcessor.notMap();
        //Entities by email
        final EntitiesEmailMapProcessor entitiesEmailProcessor = new EntitiesEmailMapProcessor();
        emailMapInit(config.entitiesEmailSection(), entitiesEmailProcessor);
        emailEntitiesMap = entitiesEmailProcessor.map();
        final EmailPostProcessMapProcessor emailPostProcessProcessor = new EmailPostProcessMapProcessor();
        emailMapInit(config.postProcessEmailSection(), emailPostProcessProcessor);
        emailPostProcessMap = emailPostProcessProcessor.emailMap();
        //Entities by destination email
        final EntitiesEmailMapProcessor entitiesRcptEmailProcessor = new EntitiesEmailMapProcessor();
        emailMapInit(config.entitiesRcptEmailSection(), entitiesRcptEmailProcessor);
        rcptEmailEntitiesMap = entitiesRcptEmailProcessor.map();
        final EmailPostProcessMapProcessor rcptEmailPostProcessProcessor = new EmailPostProcessMapProcessor();
        emailMapInit(config.postProcessRcptEmailSection(), rcptEmailPostProcessProcessor);
        rcptEmailPostProcessMap = rcptEmailPostProcessProcessor.emailMap();
        //Entities by destination uid
        RcptUidProcessor rcptUidProcessor = new RcptUidProcessor(
            config.entitiesRcptUidSection(),
            config.postProcessRcptUidSection(),
            config.rcptUidRuleSections());
        rcptUidEntitiesMap = rcptUidProcessor.entitiesMap();
        rcptUidPostProcessMap = rcptUidProcessor.postprocessActionsMap();
        //Headers by domain
        final HeadersDomainMapProcessor headersDomainProcessor = new HeadersDomainMapProcessor();
        domainMapInit(config.headersDomainSection(), headersDomainProcessor);
        domainHeadersMap = headersDomainProcessor.headersMap();
        //Entities by domain
        final EntitiesDomainMapProcessor entitiesDomainProcessor = new EntitiesDomainMapProcessor();
        domainMapInit(config.entitiesDomainSection(), entitiesDomainProcessor);
        domainEntitiesMap = entitiesDomainProcessor.map();
        final DomainPostProcessMapProcessor domainPostProcessProcessor = new DomainPostProcessMapProcessor();
        domainMapInit(config.postProcessDomainSection(), domainPostProcessProcessor);
        domainPostProcessMap = domainPostProcessProcessor.domainMap();
        rcptUidStoreSignals = new HashMap<>();
        IniConfig rcptUidStoreSignalsSection = config.rcptUidStoreSignalsSection();
        for (String key : rcptUidStoreSignalsSection.keys()) {
            Long uid = Long.parseUnsignedLong(key);
            String signalName = rcptUidStoreSignalsSection.getLastOrNull(key);
            rcptUidStoreSignals.computeIfAbsent(uid, x -> new TimeFrameQueue<>(config.metricsTimeFrame()));
            registerStater(
                new PassiveStaterAdapter<>(
                    rcptUidStoreSignals.get(uid),
                    new NamedStatsAggregatorFactory<>(signalName + "_ammm", CountAggregatorFactory.INSTANCE)));
        }

        msalEnabled = !config.extraSettingsConfig().getBoolean("msal_ignore", true);
        ignoreEmptySolution = config.extraSettingsConfig().getBoolean("ignore_empty_solution", true);
        msalEnabledUids =
            config.extraSettingsConfig().get(
                "msal-enabled-uids",
                Collections.emptySet(),
                new CollectionParser<>(String::trim, HashSet::new));
        axisFacts =
            config.extraSettingsConfig().get(
                "axis-facts",
                Collections.emptySet(),
                new CollectionParser<>(String::trim, HashSet::new));
        noCacheFacts =
            config.extraSettingsConfig().get(
                "no-cache-facts",
                Collections.emptySet(),
                new CollectionParser<>(String::trim, HashSet::new));
        noJournalingFacts =
            config.extraSettingsConfig().get(
                "no-journaling-facts",
                Collections.emptySet(),
                new CollectionParser<>(String::trim, HashSet::new));
        OutputDebugger.setEnabled(config.extraSettingsConfig().getBoolean("debug", false));
        contentlinePrefix = config.extraSettingsConfig().getString("contentline-prefix", "");
        entitiesTimeStamps = config.entitiesTimeStamps();
        if (entitiesTimeStamps == null) {
            factNameToActualData = Collections.emptyMap();
        } else {
            factNameToActualData = new HashMap<>();
            for (String key: entitiesTimeStamps.keys()) {
                factNameToActualData.put(key, entitiesTimeStamps.getLong(key));
            }
        }
        urlsWhitelistRegexp = config.urlsWhitelistRegexp();
        if (urlsWhitelistRegexp != null) {
            urlsWhitelistRegexpFile = urlsWhitelistRegexp.
                getInputFile("file");
        } else {
            urlsWhitelistRegexpFile = null;
        }
        loadPatterns(urlsWhitelistRegexpFile);

        mediaFiscalFile = config.mediaFiscalsProperties().getInputFile("file");
        loadFiscalRules(mediaFiscalFile);

        refundRulesFile = config.refundSendersProperties().getInputFile("file");
        loadRefundRules(refundRulesFile);

        File trustedUsersFile = config.extraSettingsConfig()
            .getInputFile("so-trusted-users", null);

        soTrustedUsers = new HashSet<>();
        soTrustedUsers.addAll(loadTrustedUsers(trustedUsersFile));

        File alarmUsersFile = config.extraSettingsConfig()
            .getInputFile("so-alarm-users", null);
        soAlarmUsers = new HashSet<>();
        soAlarmUsers.addAll(
            loadTrustedUsers(alarmUsersFile));

        soTrustedCoworkers = new HashSet<>();
        soTrustedCoworkers.addAll(loadTrustedCoworkers(config.extraSettingsConfig().getString(
                "so-trusted-coworkers", "trusted_coworkers.txt")));

        yandexNets = config
            .receivedChainParserConfig()
            .yandexNetsConfig()
            .createIpChecker();
    }
    //CSON: MethodLength

    public boolean isIgnoreEmptySolution() {
        return ignoreEmptySolution;
    }

    private void handlersInitialization()
        throws IOException, JniWrapperException
    {
        changeHandlers.put(ChangeType.UPDATE, RealUpdateHandler.INSTANCE);
        changeHandlers.put(ChangeType.STORE, UpdateHandler.INSTANCE);
        changeHandlers.put(ChangeType.SYNC_STORE, UpdateHandler.INSTANCE);
        changeHandlers.put(ChangeType.IEX_UPDATE, UpdateHandler.INSTANCE);
        changeHandlers.put(ChangeType.MESSAGE_STORAGE_CHANGE, UpdateStidHandler.INSTANCE);
        changeHandlers.put(ChangeType.UPDATE_ATTACH, UpdateHandler.INSTANCE);
        changeHandlers.put(ChangeType.QUICK_SAVE, UpdateHandler.INSTANCE);
        changeHandlers.put(ChangeType.MOVE, MoveHandler.INSTANCE);
        changeHandlers.put(ChangeType.MOVE_TO_TAB, MoveHandler.INSTANCE);
        register(new Pattern<>("/contentline", false), new ContentLineHandler(this), POST);
        register(new Pattern<>("/notify", false), this, POST);
        register(new Pattern<>(NOTIFY_TTEOT, false), this, POST);
        StaticProxyHandler iexProxyHandler = new StaticProxyHandler(iexClient, iexHost);
        register(new Pattern<>("/iex/", true), iexProxyHandler);
        register(new Pattern<>("/hotels", false), new HotelsHandler(this), POST);
        register(new Pattern<>("/ticket", false), new TicketHandler(this), POST);
        register(new Pattern<>("/taxi", false), new TaxiHandler(this), POST);
        register(new Pattern<>("/eda", false), new EdaHandler(this), POST);
        register(new Pattern<>("/eda_extended", false), new EdaExtendedHandler(this), POST);
        register(new Pattern<>("/combo_mail", false), new ComboMailHandler(this), POST);
        register(new Pattern<>("/refund_fbl", false), new RefundHandler(this), POST);
        register(new Pattern<>("/cbk_register", false), new CbkRegisterHandler(this), POST);
        register(new Pattern<>("/corovaneer", false), new CorovaneerHandler(this), POST);
        register(new Pattern<>("/adv_payment", false), new AdvPaymentHandler(this), POST);
        register(new Pattern<>("/adv_payment_direct", false), new AdvPaymentDirectHandler(this), POST);
        register(new Pattern<>("/events", false), new EventsHandler(this), POST);
        register(new Pattern<>("/addr", false), new AddrHandler(this), POST);
        register(new Pattern<>("/bounce", false), new BounceHandler(this), POST);
        register(new Pattern<>("/fines", false), new FinesHandler(this), POST);
        register(new Pattern<>("/facts", false), new FactsHandler(this), GET);
        register(new Pattern<>("/facts-extract", false), new FactsHandler(this), GET);
        register(new Pattern<>("/refund_facts_to_next_hop", false), new FactsHandler(this), GET);
        register(new Pattern<>("/get-text", false), new GetTextHandler(this), GET);
        register(new Pattern<>("/pkpass", false), new PkpassHandler(this), POST);
        register(new Pattern<>("/complaint", false), new EMLHandler(this), POST);
        register(new Pattern<>("/load-rules-dict", false), new DelegatedHttpAsyncRequestHandler<>(
            new RulesDictUpdateHandler(this), this, executor), GET);
        register(new Pattern<>("/eshop", false), new EshopHandler(this), POST);
        register(new Pattern<>("/payment", false), new PaymentHandler(this), POST);
        register(new Pattern<>("/action", false), new ActionEntityHandler(this), POST);
        register(new Pattern<>("/event-ticket", false), new EventTicketHandler(this), POST);
        register(new Pattern<>("/tomita", false), new TomitaHandler(this), POST);
        register(new Pattern<>("/cv", false), new CvHandler(this), POST);
        register(new Pattern<>("/news", false), new NewsHandler(this), POST);
        register(new Pattern<>("/news-allimgs", false), new NewsAllUrlHandler(this), POST);
        register(new Pattern<>("/update", false), new PingHandler(this));
        register(new Pattern<>("/delete", false), new PingHandler(this));
        register(new Pattern<>("/snippet", false), new SnippetHandler(this));
        register(new Pattern<>("/snippet-text", false), new SnippetTextHandler(this));
        register(new Pattern<>("/discount", false), new DiscountEntityHandler(this), POST);

        register(new Pattern<>("/people-urls", false), new PeopleUrlsHandler(this), POST);
        register(new Pattern<>("/bigimage", false), new BigImageHandler(this), POST);
        register(new Pattern<>("/calendar-log-handle", false), new CalendarLogHandler(this), POST);
        register(new Pattern<>("/so-index", false), new SOIndexHandler(this), POST);
        JniWrapper unperson = JniWrapper.create(
            config().unpersonConfig(),
            new ThreadFactoryConfig(config.name() + "-Unperson").group(getThreadGroup()).daemon(true));
        closeChain.add(new GenericNonThrowingCloseableAdapter<>(unperson));
        register(new Pattern<>("/top", false), new TopHandler(this), POST);
        register(new Pattern<>("/forward", false), new ForwardHandler(this));
        register(new Pattern<>("/mark", false), new MarkHandler(this));
        register(new Pattern<>("/sobb", false), new BugBountyHandler(this, sobbYtLogger));
        register(new Pattern<>("/get_refund_mid_uid_pairs", false), new RefundMidUidPairsHandler(this), GET);
        register(new Pattern<>("/get_refund_mail_info", false), new RefundMailInfoHandler(this), GET);
    }

    public String contentlinePrefix() {
        return contentlinePrefix;
    }

    public boolean msalEnabled(final String uid) {
        if (!msalEnabled) {
            return msalEnabledUids.contains(uid);
        }
        return true;
    }

    public AsyncClient smartobjectClient() {
        return smartobjectClient;
    }

    @SuppressWarnings("StringSplitter")
    private void messageTypeMapInit(
        final IniConfig config,
        final MessageTypeMapProcessor processor)
        throws ConfigException
    {
        for (String key: config.keys()) {
            if (key.startsWith(MESSAGE_TYPE_KEY_START)
                    || key.startsWith(NOT_MESSAGE_TYPE_KEY_START))
            {
                final boolean inclusive;
                final String typesStr;
                if (key.startsWith(MESSAGE_TYPE_KEY_START)) {
                    inclusive = true;
                    typesStr = key.substring(MESSAGE_TYPE_KEY_START.length());
                } else {
                    inclusive = false;
                    typesStr = key.substring(NOT_MESSAGE_TYPE_KEY_START.length());
                }
                final Set<Integer> setKey = new HashSet<>();
                String[] types = typesStr.split("-");
                if (types.length > MAX_TYPE_COUNT) {
                    throw new ConfigException(
                         "Too many types in type definition: " + typesStr + ". Maximum allowed types count: 5.");
                }
                int prevType = 0;
                for (String typeStr : types) {
                    try {
                        int t = Integer.parseInt(typeStr);
                        if (t == 0) {
                            continue;
                        }
                        if (t <= prevType) {
                            throw new ConfigException(
                                "Invalid types definition: " + key + '.'
                                + " Types should follow in a sorted order.");
                        }
                        if (t > MAX_TYPE) {
                            throw new ConfigException(
                                    "Bad types definition: " + typeStr + ". "
                                    + "Maximum allowed type is " + MAX_TYPE);
                        }
                        setKey.add(t);
                        prevType = t;
                    } catch (NumberFormatException e) {
                        throw new ConfigException(
                                "Invalid number in type definition: " + typeStr + " (" + typesStr + ')', e);
                    }
                }
                String valueString = config.getString(key);
                if (!setKey.isEmpty()) {
                    if (inclusive) {
                        processor.processInclusive(setKey, valueString);
                    } else {
                        processor.processExclusive(setKey, valueString);
                    }
                }
            } else if (key.startsWith("default")) {
                final String valueString = config.getString(key, null);
                if (valueString != null) {
                    processor.processInclusive(DEFAULT_MIXED, valueString);
                }
            }
        }
    }

    private <E> Map<E, EntityOptions> searchMixedMapOptionsFully(
            final Map<Set<Integer>, Map<E, EntityOptions>> map,
            final List<Integer> types,
            final Logger logger)
    {
        Map<E, EntityOptions> result = null;
        final Set<Integer> key = new HashSet<Integer>(types);
        if (!narrowType) {
            result = map.get(key);
            if (result != null) {
                logger.fine(
                        "fully: Matched types: in=" + types
                                + ",   out=" + result);
            }
        } else {
            boolean copied = false;
            for (final Map.Entry<Set<Integer>, Map<E, EntityOptions>> entry
                                            : map.entrySet())
            {
                if (entry.getKey() == DEFAULT_MIXED) {
                    continue;
                }
                if (key.containsAll(entry.getKey())) {
                    Map<E, EntityOptions> subResult = entry.getValue();
                    logger.fine("fully: Matched non exact types: in="
                            + types + ",  key=" + entry.getKey()
                            + ",  out=" + subResult);
                    if (result == null) {
                        result = subResult;
                    } else if (!copied) {
                        result = new HashMap<E, EntityOptions>(result);
                        IndexationContext.mergeEntities(result, subResult);
                        copied = true;
                    } else {
                        IndexationContext.mergeEntities(result, subResult);
                    }
                }
            }
        }
        return result;
    }

    private <E> Set<E> searchMixedMapFully(
            final Map<Set<Integer>, Set<E>> map,
            final List<Integer> types,
            final Logger logger)
    {
        Set<E> result = null;
        final Set<Integer> key = new HashSet<Integer>(types);
        if (!narrowType) {
            result = map.get(key);
            if (result != null) {
                logger.fine(
                        "fully: Matched types: in=" + types
                                + ",   out=" + result);
            }
        } else {
            boolean copied = false;
            for (final Map.Entry<Set<Integer>, Set<E>> entry
                                            : map.entrySet())
            {
                if (entry.getKey() == DEFAULT_MIXED) {
                    continue;
                }
                if (key.containsAll(entry.getKey())) {
                    Set<E> subResult = entry.getValue();
                    logger.fine("fully: Matched non exact types: in="
                            + types + ",  key=" + entry.getKey()
                            + ",  out=" + subResult);
                    if (result == null) {
                        result = subResult;
                    } else if (!copied) {
                        result = new HashSet<E>(result);
                        result.addAll(subResult);
                        copied = true;
                    } else {
                        result.addAll(subResult);
                    }
                }
            }
        }
        return result;
    }

    public Set<String> headersFromTypes(
        final List<Integer> types,
        final Logger logger)
    {
        Set<String> result;
        //boolean copied = false;

        Set<String> headers =
            searchMixedMapFully(messageTypeHeadersMap, types, logger);

        Set<String> defaultHeaders =
            messageTypeHeadersMap.get(DEFAULT_MIXED);
        if (headers == null && defaultHeaders == null) {
            result = Collections.emptySet();
        } else {
            if (headers == null) {
                result = defaultHeaders;
            } else if (defaultHeaders == null) {
                result = headers;
            } else {
                //finally merge
                //copied = true;
                result = new HashSet<>();
                result.addAll(headers);
                result.addAll(defaultHeaders);
            }
        }
        return result;
    }

    public Map<String, EntityOptions> entitiesFromTypes(
            final List<Integer> types,
            final Logger logger)
    {
        Map<String, EntityOptions> result;
        boolean copied = false;

        Map<String, EntityOptions> entities =
            searchMixedMapOptionsFully(messageTypeEntitiesMap, types, logger);

        Map<String, EntityOptions> defaultEntities =
            messageTypeEntitiesMap.get(DEFAULT_MIXED);
        if (entities == null && defaultEntities == null) {
            result = Collections.emptyMap();
        } else {
            if (entities == null) {
                result = defaultEntities;
            } else if (defaultEntities == null) {
                result = entities;
            } else {
                //finally merge
                copied = true;
                result = new HashMap<>(
                    (entities.size() + defaultEntities.size()) << 1);
                result.putAll(defaultEntities);
                IndexationContext.mergeEntities(result, entities);
            }
        }
        final Map<String, EntityOptions> removeEntities =
            searchMixedMapOptionsFully(messageTypeNotEntitiesMap, types, logger);
        if (removeEntities != null && !result.isEmpty()) {
            if (!copied) {
                result = new HashMap<>(result);
            }
            for (String entity: removeEntities.keySet()) {
                result.remove(entity);
            }
        }
        return result;
    }

    public Set<PostProcessAction> postProcessActionsFromTypes(
            final List<Integer> types,
            final Logger logger)
    {
        Set<PostProcessAction> result;
        boolean copied = false;

        final Set<PostProcessAction> actions =
                searchMixedMapFully(messageTypePostProcessMap, types, logger);

        final Set<PostProcessAction> defaultActions =
                messageTypePostProcessMap.get(DEFAULT_MIXED);
        if (actions == null && defaultActions == null) {
            result = Collections.emptySet();
        } else {
            if (actions == null) {
                result = defaultActions;
            } else if (defaultActions == null) {
                result = actions;
            } else {
                copied = true;
                result = new HashSet<>();
                result.addAll(actions);
                result.addAll(defaultActions);
            }
        }
        final Set<PostProcessAction> removeActions =
                searchMixedMapFully(
                        messageTypeNotPostProcessMap,
                        types,
                        logger);
        if (removeActions != null && !result.isEmpty()) {
            if (!copied) {
                result = new HashSet<>(result);
            }
            result.removeAll(removeActions);
        }
        return result;
    }

    public AsyncClient iexClient() {
        return iexClient;
    }

    @SuppressWarnings("unused")
    public HttpHost iexHost() {
        return iexHost;
    }

    public HttpHost msalHost() {
        return msalHost;
    }

    public HttpHost corpMsalHost() {
        return corpMsalHost;
    }

    public BlackboxClient blackboxClient() {
        return blackboxClient;
    }

    public String blackboxTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().blackboxTvmClientId());
    }

    public BlackboxClient corpBlackboxClient() {
        return corpBlackboxClient;
    }

    public String corpBlackboxTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().corpBlackboxTvmClientId());
    }

    public BlackboxClient blackboxDirectClient() {
        return blackboxDirectClient;
    }

    public AsyncClient postProcessClient() {
        return postProcessClient;
    }

    public AsyncClient tikaiteClient() {
        return tikaiteClient;
    }

    public AsyncClient tikaiteMlClient() {
        return tikaiteMlClient;
    }

    public AsyncClient mulcagateClient() {
        return mulcagateClient;
    }

    public HttpHost tikaiteHost() {
        return config().tikaiteConfig().host();
    }

    public HttpHost tikaiteMlHost() {
        return config().tikaiteMlConfig().host();
    }

    public String tikaiteTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().tikaiteTvmClientId());
    }

    public String unistorageTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().unistorageTvmClientId());
    }

    public HttpHost mulcagateHost() {
        return mulcagateHost;
    }

    public AsyncClient producerAsyncClient() {
        return producerAsyncClient;
    }

    public AsyncClient soProducerClient() {
        return soProducerClient;
    }

    public HttpHost knnHost() {
        return knnHost;
    }

    public AsyncClient knnClient() {
        return knnClient;
    }

    public AsyncClient mopsClient() {
        return mopsClient;
    }

    public AsyncClient corpMopsClient() {
        return corpMopsClient;
    }

    public AsyncClient cokemulatorIexlibClient() {
        return cokemulatorIexlibClient;
    }

    public HttpHost cokemulatorIexlibHost() {
        return cokemulatorIexlibHost;
    }

    public AsyncClient calendarClient() {
        return calendarClient;
    }

    public String calendarTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().calendarTvmClientId());
    }

    public AsyncClient calendarToolsClient() {
        return calendarToolsClient;
    }

    public String calendarToolsTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().calendarToolsTvmClientId());
    }

    public AsyncClient corovaneerClient() {
        return corovaneerClient;
    }

    public String corovaneerTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().corovaneerTvmClientId());
    }

    public AsyncClient msalClient() {
        return this.msalClient;
    }

    public AsyncClient corpMsalClient() {
        return this.corpMsalClient;
    }

    public AsyncClient raspClient() {
        return this.raspClient;
    }

    public AsyncClient refundClient() {
        return this.refundClient;
    }

    public AsyncClient rcaClient() {
        return this.rcaClient;
    }

    public URI rcaURI() {
        return this.rcaURI;
    }

    public AsyncClient marketClient() {
        return this.marketClient;
    }

    public AsyncClient bkClient() {
        return this.bkClient;
    }

    public AsyncClient mediaClient() {
        return this.mediaClient;
    }

    public AsyncClient gettextClient() {
        return this.gettextClient;
    }

    public AsyncClient gatemailClient() {
        return this.gatemailClient;
    }

    public AsyncClient msearchClient() {
        return this.msearchClient;
    }

    public AsyncClient onlineDBClient() {
        return this.onlineDBClient;
    }

    public AsyncClient reminderClient() {
        return this.reminderClient;
    }

    public AsyncClient axisClient() {
        return this.axisClient;
    }

    public AsyncClient complaintsClient() {
        return this.complaintsClient;
    }

    public AsyncClient complaintsCoworkersSelectionClient() {
        return this.complaintsCoworkersSelectionClient;
    }

    public AsyncClient freemailClient() {
        return this.freemailClient;
    }

    public AsyncClient sologgerClient() {
        return this.sologgerClient;
    }

    public AsyncClient settingsApiClient() {
        return this.settingsApiClient;
    }

    public String settingsApiTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().settingsApiTvmClientId());
    }

    public AsyncClient corpSettingsApiClient() {
        return this.corpSettingsApiClient;
    }

    public String corpSettingsApiTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().corpSettingsApiTvmClientId());
    }

    public AsyncClient xivaClient() {
        return xivaClient;
    }

    public AsyncClient xivaCorpClient() {
        return xivaCorpClient;
    }

    public AsyncClient taksaClient() {
        return taksaClient;
    }

    public String taksaTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().taksaTvmClientId());
    }

    public AsyncClient taksaTestingClient() {
        return taksaTestingClient;
    }

    public AsyncClient neuroHardsClient() {
        return neuroHardsClient;
    }

    public HttpHost neuroHardsHost() {
        return config().neuroHardsConfig().host();
    }

    public ImagesFetcher imagesFetcher() {
        return imagesFetcher;
    }

    public URI axisURI() {
        return this.axisURI;
    }

    public AsyncClient factsExtractClient() {
        return this.factsExtractClient;
    }

    public URI factsExtractURI() {
        return this.factsExtractURI;
    }

    public String axisQueueName() {
        return this.axisQueueName;
    }

    public String xIndexOperationQueueNameBacklog() {
        return this.xIndexOperationQueueNameBacklog;
    }

    public String xIndexOperationQueueNameFacts() {
        return this.xIndexOperationQueueNameFacts;
    }

    public String xIndexOperationQueueNameUpdate() {
        return this.xIndexOperationQueueNameUpdate;
    }

    public String mailSearchQueueName() {
        return mailSearchQueueName;
    }

    public String corpMailSearchQueueName() {
        return corpMailSearchQueueName;
    }

    public long almostAllFactsTimeout() {
        return this.almostAllFactsTimeout;
    }

    public Long getFactTimeStamp(final String factName) {
        Long timestamp = null;
        if (factNameToActualData != null) {
            timestamp = factNameToActualData.get(factName);
        }
        if (timestamp == null) {
            timestamp = ZERO;
        }
        return timestamp;
    }

    public File urlsWhitelistRegexpFile() {
        return urlsWhitelistRegexpFile;
    }

    public boolean axisEnabled(final String factName) {
        return axisFacts.contains(factName) || axisFacts.contains(ASTERISK);
    }

    public boolean journalingFact(final String factName) {
        return !noJournalingFacts.contains(factName);
    }

    public boolean cachingFact(final String factName) {
        return !noCacheFacts.contains(factName);
    }

    public GeocoderClient geoSearchClient() {
        return geoSearchClient;
    }

    public String geoTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().geoTvmClientId());
    }

    public String afishaTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().afishaTvmClientId());
    }

    public AfishaClient afishaClient() {
        return afishaClient;
    }

    public AsyncClient kinopoiskQlClient() {
        return kinopoiskQlClient;
    }

    public String kinopoiskTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().kinopoiskTvmClientId());
    }

    public AsyncClient filterSearchClient() {
        return this.filterSearchClient;
    }

    public String filterSearchUri() {
        return this.filterSearchUri;
    }

    public String filterSearchTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().filterSearchTvmClientId());
    }

    public AsyncClient corpFilterSearchClient() {
        return this.corpFilterSearchClient;
    }

    public String corpFilterSearchUri() {
        return this.corpFilterSearchUri;
    }

    public String corpFilterSearchTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().corpFilterSearchTvmClientId());
    }

    public String mopsTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().mopsTvmClientId());
    }

    public String corpMopsTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().corpMopsTvmClientId());
    }

    public AsyncClient foldersClient() {
        return this.foldersClient;
    }

    public String foldersTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().foldersTvmClientId());
    }

    public AsyncClient corpFoldersClient() {
        return this.corpFoldersClient;
    }

    public String corpFoldersTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().corpFoldersTvmClientId());
    }

    public AsyncClient labelsClient() {
        return this.labelsClient;
    }

    public String labelsTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().labelsTvmClientId());
    }

    public AsyncClient corpLabelsClient() {
        return this.corpLabelsClient;
    }

    public String corpLabelsTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().corpLabelsTvmClientId());
    }

    public AsyncClient attachSidClient() {
        return this.attachSidClient;
    }

    public String attachSidTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().attachSidTvmClientId());
    }

    public AsyncClient corpAttachSidClient() {
        return this.corpAttachSidClient;
    }

    public String corpAttachSidTvm2Ticket() {
        return tvm2RenewalTask.ticket(config().corpAttachSidTvmClientId());
    }

    @Override
    public void start() throws IOException {
        tvm2RenewalTask.start();
        super.start();
    }

    @Override
    public void close() throws IOException {
        tvm2RenewalTask.cancel();
        super.close();
    }

    // ProxyRequestHandler implementation
    @Override
    public String toString() {
        return "Handles notification messages concerning user mailbox changes";
    }

    @Override
    public void handle(
        final Object payload,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        Logger logger = (Logger) context.getAttribute(BaseAsyncServer.LOGGER);
        logger.fine("POST: " + JsonType.NORMAL.toString(payload));
        ProxySession session = null;
        try {
            session = new BasicProxySession(this, exchange, context);
            Map<?, ?> json = ValueUtils.asMap(payload);
            HeadersParser headersParser =
                new HeadersParser(exchange.getRequest());
            Integer retryNumber = null;
            try {
                retryNumber =
                    Integer.parseInt(
                        headersParser.getString(YandexHeaders.RETRY_COUNT, ""));
            } catch (NumberFormatException ignore) {
            }
            boolean zooQueueIsIexUpdate = false;
            String zooQueue = headersParser.
                getString(YandexHeaders.ZOO_QUEUE, null);
            if (zooQueue != null && zooQueue.equals("iex_update")) {
                zooQueueIsIexUpdate = true;
            }
            boolean addReindexToAxis =
                session.params().getBoolean("reindex", false);
            List<String> updateCache;
            updateCache = session.params().getAll("update_cache");
            List<String> updateCacheNames = new ArrayList<String>();
            for (String str : updateCache) {
                updateCacheNames.addAll(Arrays.asList(str.split(",")));
            }
            updateCache = updateCacheNames;
            boolean isTteot = exchange.getRequest().getRequestLine().getUri().startsWith(NOTIFY_TTEOT);
            boolean serviceIsNotSlowQueue = true;
            String service = headersParser.
                getString(YandexHeaders.SERVICE, null);
            if (service != null && service.equals(config().slowQueueName())) {
                serviceIsNotSlowQueue = false;
            }
            if (config().maxRetries() != null && serviceIsNotSlowQueue
                && retryNumber != null && retryNumber >= config().maxRetries())
            {
                handleMaxRetriesRequest(session, payload);
            } else {
                String mdb = session.params().getString(OracleFields.MDB);
                if (!config().mdbs().matcher(mdb).matches()) {
                    session.logger().fine(
                            mdb + " doesn't match mdbs pattern " + config().mdbs()
                                    + ", skipping request");
                    session.response(HttpStatus.SC_OK);
                    return;
                }
                handleRequest(
                    session,
                    json,
                    isTteot,
                    zooQueueIsIexUpdate,
                    addReindexToAxis,
                    updateCache);
            }
        } catch (JsonException e) {
            session.logger().log(
                Level.SEVERE,
                "Exception - Failed to parse request: " + payload,
                e);
            session.response(HttpStatus.SC_BAD_REQUEST);
        } catch (BadRequestException e) {
            if (session != null) {
                session.logger().log(
                    Level.SEVERE,
                    "Exception - Bad request",
                    e);
                session.response(HttpStatus.SC_BAD_REQUEST);
            }
        }
    }

    @SuppressWarnings("FutureReturnValueIgnored")
    private void handleMaxRetriesRequest(
        final ProxySession session,
        final Object payload)
        throws HttpException
    {
        session.logger().info("Moving request to slow queue");
        HttpHost host = config().producerAsyncClientConfig().host();
        HttpRequest request = session.request();
        try {
            CgiParams cgiParams = session.params();
            QueryConstructor cgiQueryConstructor = new QueryConstructor(
                    session.uri().rawPath() + "-tteot?"
            );
            for (Map.Entry<String, List<String>> entry
                                        : cgiParams.entrySet())
            {
                if (entry.getKey().equals(SERVICE)
                        && !cgiParams.containsKey(SERVICE_ORIGINAL))
                {
                    for (String value : entry.getValue()) {
                        cgiQueryConstructor.append(SERVICE_ORIGINAL, value);
                    }
                } else {
                    for (String value : entry.getValue()) {
                        cgiQueryConstructor.append(entry.getKey(), value);
                    }
                }
            }
            cgiQueryConstructor.append(SERVICE, config().slowQueueName());
            String uri = cgiQueryConstructor.toString();
            BasicAsyncRequestProducerGenerator generator =
                        new BasicAsyncRequestProducerGenerator(
                            uri,
                            new StringEntity(JsonType.NORMAL.toString(payload),
                            ContentType.APPLICATION_JSON)
                        );
            Header zooQueueId = request.getFirstHeader(
                    YandexHeaders.ZOO_QUEUE_ID);
            if (zooQueueId != null) {
                generator.addHeader(zooQueueId);
            }
            Header zooShardId = request.getFirstHeader(
                    YandexHeaders.ZOO_SHARD_ID);
            if (zooShardId != null) {
                generator.addHeader(zooShardId);
            }
            generator.addHeader(YandexHeaders.SERVICE, config().slowQueueName());
            producerAsyncClient.execute(
                    host,
                    generator,
                    EmptyAsyncConsumerFactory.OK,
                    session.listener().
                            createContextGeneratorFor(producerAsyncClient),
                    new ProducerCallback(session)
            );
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    // CSOFF: ParameterNumber
    private void handleRequest(
            final ProxySession session,
            final Map<?, ?> json,
            final boolean isTteot,
            final boolean zooQueueIsIexUpdate,
            final boolean addReindexToAxis,
            final List<String> updateCache)
            throws HttpException, JsonException
    {
        ChangeContext context = new ChangeContext(
            this,
            session,
            json,
            isTteot,
            zooQueueIsIexUpdate,
            addReindexToAxis,
            updateCache);
        ChangeHandler handler = changeHandlers.get(context.changeType());
        if (handler == null) {
            handler = UnknownChangeHandler.INSTANCE;
        }
        handler.handle(context);
        if (handler != UnknownChangeHandler.INSTANCE && context.isOnline()) {
            if (context.hasTransferTimestamp()) {
                long now = TimeSource.INSTANCE.currentTimeMillis();
                long operationDate = context.operationDateMillis();
                long lag = now - operationDate;
                session.logger().fine("Incoming lag: " + lag + " ms");
                incomingLagStater.accept(
                    new RequestInfo(
                        now,
                        0,
                        operationDate,
                        operationDate,
                        0L,
                        0L));
            }
            enlarge(context.prefix(), session);
        }
    }
    // CSON: ParameterNumber
    @SuppressWarnings("FutureReturnValueIgnored")
    private void enlarge(final long prefix, final ProxySession session) {
        final AsyncClient onlineDBClient =
            onlineDBClient().adjust(session.context());
        final BasicAsyncRequestProducerGenerator request =
            new BasicAsyncRequestProducerGenerator(
                "/online?uid=" + prefix);
        onlineDBClient.execute(
            config().onlineDBConfig().host(),
            request,
            BasicAsyncResponseConsumerFactory.OK,
            session.listener().
                createContextGeneratorFor(onlineDBClient),
            new UserOnlineCallback(prefix, session));
    }

    @Override
    public HttpAsyncRequestConsumer<Object> processRequest(
            final HttpRequest request,
            final HttpContext context)
            throws HttpException
    {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            throw new BadRequestException("Payload expected");
        }
        return new JsonAsyncDomConsumer(
                ((HttpEntityEnclosingRequest) request).getEntity());
    }

    public IexProxyLogger iexProxyLogger() {
        return iexProxylogger;
    }

    public Logger complLogger() {
        return complLogger;
    }

    public Logger complYtLogger() {
        return complYtLogger;
    }

    public Predicate<InetAddress> yandexNets() {
        return yandexNets;
    }

    @SuppressWarnings("StringSplitter")
    private static Map<String, EntityOptions> parseEntities(
        final String entitiesString)
        throws ConfigException
    {
        String[] entities = entitiesString.split(DELIM);
        Map<String, EntityOptions> map = new HashMap<>(entities.length << 1);
        for (String entityString: entities) {
            if (!entityString.isEmpty()) {
                parseEntity(map, entityString);
            }
        }
        return map;
    }

    private static void parseEntity(
        final Map<String, EntityOptions> map,
        final String entityString)
        throws ConfigException
    {
        if (entityString.charAt(entityString.length() - 1) == ')') {
            int idx = entityString.indexOf('(');
            try {
                String name = entityString.substring(0, idx);
                EntityOptions options =
                    new EntityOptions(
                        new CgiParams(
                            entityString.substring(
                                idx + 1,
                                entityString.length() - 1)));
                map.put(name, options);
            } catch (Exception e) {
                throw new ConfigException(
                    "Failed to parse entity <" + entityString + '>',
                    e);
            }
        } else {
            map.put(entityString, EntityOptions.DEFAULT_OPTIONS);
        }
    }

    interface MessageTypeMapProcessor {
        void processInclusive(final Set<Integer> key, final String value)
                throws ConfigException;

        void processExclusive(final Set<Integer> key, final String value)
                throws ConfigException;
    }

    private static class HeadersMapProcessor
            implements MessageTypeMapProcessor
    {
        private Map<Set<Integer>, Set<String>> headersMap =
                new LinkedHashMap<>();

        @Override
        public void processInclusive(
            final Set<Integer> key,
            final String value)
        {
            this.headersMap.put(key, getHeaders(value));
        }

        @Override
        public void processExclusive(
            final Set<Integer> key,
            final String value)
        {
        }

        private Set<String> getHeaders(final String headersString) {
            return Set.of(headersString.split(DELIM));
        }

        public Map<Set<Integer>, Set<String>> map() {
            return Collections.unmodifiableMap(this.headersMap);
        }
    }

    private static class EntitiesMapProcessor
            implements MessageTypeMapProcessor
    {
        private Map<Set<Integer>, Map<String, EntityOptions>> entitiesMap =
                new LinkedHashMap<>();
        private Map<Set<Integer>, Map<String, EntityOptions>> notEntitiesMap =
                new LinkedHashMap<>();

        @Override
        public void processInclusive(
            final Set<Integer> key,
            final String value)
            throws ConfigException
        {
            this.entitiesMap.put(key, parseEntities(value));
        }

        @Override
        public void processExclusive(
            final Set<Integer> key,
            final String value)
            throws ConfigException
        {
            this.notEntitiesMap.put(key, parseEntities(value));
        }

        public Map<Set<Integer>, Map<String, EntityOptions>> map() {
            return Collections.unmodifiableMap(this.entitiesMap);
        }

        public Map<Set<Integer>, Map<String, EntityOptions>> notMap() {
            return Collections.unmodifiableMap(this.notEntitiesMap);
        }
    }

    private static class PostProcessMapProcessor
            implements MessageTypeMapProcessor
    {
        private Map<
                Set<Integer>,
                Set<PostProcessAction>> messageTypePostProcessMap =
                new LinkedHashMap<>();
        private Map<
                Set<Integer>,
                Set<PostProcessAction>> messageTypeNotPostProcessMap =
                new LinkedHashMap<>();

        protected static PostProcessAction parseAction(final String actionString)
            throws ConfigException
        {
            int sep = actionString.indexOf(':');
            if (sep == -1
                    || actionString.startsWith("http://")
                    || actionString.startsWith("https://"))
            {
                throw new ConfigException(
                        "Invalid action string: " + actionString
                        + ", should be in form: actionname:actionurl, ex.: "
                        + "hotels:http://localhost:10306/hotels");
            }
            return new PostProcessAction(
                    actionString.substring(sep + 1),
                    actionString.substring(0, sep));
        }

        @SuppressWarnings("StringSplitter")
        public static Set<PostProcessAction> parseActions(final String actionString)
            throws ConfigException
        {
            String[] postActions = actionString.split(DELIM);
            Set<PostProcessAction> res = new HashSet<>();
            for (final String post : postActions) {
                res.add(parseAction(post));
            }
            return Collections.unmodifiableSet(res);
        }

        @Override
        public void processInclusive(final Set<Integer> key, final String value)
                throws ConfigException
        {
            Set<PostProcessAction> action = parseActions(value);
            Set<PostProcessAction> actionSet =
                messageTypePostProcessMap.computeIfAbsent(key, k -> new HashSet<>());
            actionSet.addAll(action);
        }

        @Override
        public void processExclusive(final Set<Integer> key, final String value)
                throws ConfigException
        {
            Set<PostProcessAction> action = parseActions(value);
            Set<PostProcessAction> actionSet =
                    messageTypeNotPostProcessMap.get(key);
            if (actionSet == null) {
                actionSet = new HashSet<>();
                messageTypeNotPostProcessMap.put(
                        key,
                        Collections.unmodifiableSet(actionSet));
            }
            actionSet.addAll(action);
        }

        public Map<Set<Integer>, Set<PostProcessAction>> map() {
            return Collections.unmodifiableMap(messageTypePostProcessMap);
        }

        public Map<Set<Integer>, Set<PostProcessAction>> notMap() {
            return Collections.unmodifiableMap(messageTypeNotPostProcessMap);
        }
    }

    //Extraction entities by email
    public Map<String, EntityOptions> entitiesFromEmail(
        final String email)
    {
        return copyChunkOfMapToMap(email, emailEntitiesMap);
    }

    public Set<PostProcessAction> postProcessActionsFromEmail(
        final String email)
    {
        return copyChunkOfMapToSet(email, emailPostProcessMap);
    }

    //Extraction entities by rcpt uid
    public Map<String, EntityOptions> entitiesFromRcptUid(
        final Long uid)
    {
        return rcptUidEntitiesMap.getOrDefault(uid, Collections.emptyMap());
    }

    public Set<PostProcessAction> postProcessActionsFromRcptUid(
        final Long uid)
    {
        return rcptUidPostProcessMap.getOrDefault(uid, Collections.emptySet());
    }

    //Extraction entities by rcpt email
    public Map<String, EntityOptions> entitiesFromRcptEmail(
        final String email)
    {
        return copyChunkOfMapToMap(email, rcptEmailEntitiesMap);
    }

    public Set<PostProcessAction> postProcessActionsFromRcptEmail(
            final String email)
    {
        return copyChunkOfMapToSet(email, rcptEmailPostProcessMap);
    }

    interface EmailMapProcessor {
        void processInclusive(final String key, final String value)
                throws ConfigException;
    }

    private static class EntitiesEmailMapProcessor
            implements EmailMapProcessor
    {
        protected Map<String, Map<String, EntityOptions>> emailEntitiesMap =
                new LinkedHashMap<>();

        @Override
        public void processInclusive(final String key, final String value)
                throws ConfigException
        {
            emailEntitiesMap.put(key, parseEntities(value));
        }

        @SuppressWarnings("unused")
        private Set<String> getEntities(final String entitiesString) {
            return Set.of(entitiesString.split(DELIM));
        }

        public Map<String, Map<String, EntityOptions>> map() {
            return Collections.unmodifiableMap(emailEntitiesMap);
        }
    }

    private static class EmailPostProcessMapProcessor
            extends PostProcessMapProcessor implements EmailMapProcessor
    {
        private Map<String, Set<PostProcessAction>> emailPostProcessMap =
                new LinkedHashMap<>();

        @Override
        public void processInclusive(final String key, final String value)
                throws ConfigException
        {
            Set<PostProcessAction> action = parseActions(value);

            Set<PostProcessAction> actionSet =
                emailPostProcessMap.computeIfAbsent(key, k -> new HashSet<>());
            actionSet.addAll(action);
        }

        public Map<String, Set<PostProcessAction>> emailMap() {
            return Collections.unmodifiableMap(emailPostProcessMap);
        }
    }

    private void emailMapInit(
        final IniConfig config,
        final EmailMapProcessor processor)
        throws ConfigException
    {
        for (String key: config.keys()) {
            if (XRegexpUtils.isEmail(key)) {
                processor.processInclusive(key, config.getString(key));
            } else {
                throw new ConfigException("Invalid email definition: " + key);
            }
        }
    }

    // Extract actions by receiver uid

    private class RcptUidProcessor {
        private final Map<Long, Map<String, EntityOptions>> entitiesMap;
        private final Map<Long, Set<PostProcessAction>> postprocessActionsMap;

        public RcptUidProcessor(
                final IniConfig entitiesConfig,
                final IniConfig postprocessConfig,
                final IniConfig bulkRulesConfig)
                throws ConfigException
        {
            entitiesMap = constructMap(
                entitiesConfig,
                IexProxy::parseEntities);
            postprocessActionsMap = constructMap(
                postprocessConfig,
                PostProcessMapProcessor::parseActions);
            initBulkRcptUidRules(bulkRulesConfig);
        }

        private <T> Map<Long, T> constructMap(
            final IniConfig config,
            GenericFunction<String, T, Exception> parser)
            throws ConfigException
        {
            Map<Long, T> res = new HashMap<>();
            for (String key: config.keys()) {
                long uid;
                try {
                    uid = Long.parseLong(key);
                } catch (RuntimeException e) {
                    throw new ConfigException("Invalid uid <" + key + '>');
                }
                String value = config.getString(key);
                try {
                    res.put(uid, parser.apply(value));
                } catch (Exception e) {
                    throw new ConfigException("Can't parse " + value, e);
                }
            }
            return res;
        }

        private void initBulkRcptUidRules(IniConfig rcptUidRuleSections)
            throws ConfigException
        {
            for (Map.Entry<String, IniConfig> entry :
                    rcptUidRuleSections.sections().entrySet())
            {
                IniConfig section = entry.getValue();
                try (BufferedReader reader =
                     new BufferedReader(
                         new FileReader(
                             section.getString("uids_file"),
                             StandardCharsets.UTF_8)))
                {
                    Map<String, EntityOptions> entities =
                        parseEntities(section.getString("entities"));
                    Set<PostProcessAction> postProcessActions =
                        PostProcessMapProcessor.parseActions(
                            section.getString("postprocess"));
                    Collection<Long> uids = loadUidsFromBufferedReader(reader);

                    for (Long uid : uids) {
                        entitiesMap.put(uid, entities);
                        postprocessActionsMap.put(uid, postProcessActions);
                    }
                } catch (IOException | ConfigException e) {
                    throw new ConfigException(
                        "Can't load rule " + entry.getKey(), e);
                }
            }
        }

        public Map<Long, Map<String, EntityOptions>> entitiesMap() {
            return Collections.unmodifiableMap(entitiesMap);
        }

        public Map<Long, Set<PostProcessAction>> postprocessActionsMap() {
            return Collections.unmodifiableMap(postprocessActionsMap);
        }
    }

    //Extraction entities by domain

    public Set<String> headersFromDomain(
        final String domain,
        final Logger logger)
    {
        Set<String> headers = domainHeadersMap.get(domain);
        if (headers == null) {
            headers = Collections.<String>emptySet();
        }
        return headers;
    }

    public Map<String, EntityOptions> entitiesFromDomain(
            final String domain)
    {
        return copyChunkOfMapToMap(domain, domainEntitiesMap);
    }

    public Set<PostProcessAction> postProcessActionsFromDomain(
            final String domain)
    {
        return copyChunkOfMapToSet(domain, domainPostProcessMap);
    }

    private static class EntitiesDomainMapProcessor
            extends EntitiesEmailMapProcessor
    {
    }

    private static class HeadersDomainMapProcessor
            extends EntitiesEmailMapProcessor
    {
        @Override
        public void processInclusive(final String key, final String value)
                throws ConfigException
        {
            super.processInclusive(key.replace('$', '.'), value);
        }

        public Map<String, Set<String>> headersMap() {
            Map<String, Set<String>> result =
                new HashMap<>(emailEntitiesMap.size() << 1);
            for (Map.Entry<String, Map<String, EntityOptions>> entry
                : emailEntitiesMap.entrySet())
            {
                result.put(entry.getKey(), entry.getValue().keySet());
            }
            return Collections.unmodifiableMap(result);
        }
    }

    private static class DomainPostProcessMapProcessor
            extends EmailPostProcessMapProcessor
    {
        public Map<String, Set<PostProcessAction>> domainMap() {
            return emailMap();
        }
    }

    private void domainMapInit(
            final IniConfig config,
            final EmailMapProcessor processor)
            throws ConfigException
    {
        for (String key: config.keys()) {
            if (XRegexpUtils.isSpecificDomain(key)) {
                processor.processInclusive(key, config.getString(key));
            } else {
                throw new ConfigException(
                        "Invalid domain definition key - " + key);
            }
        }
    }

    //common methods
    private String changeCommaToDollar(final String s) {
        return s.replace('.', '$');
    }

    private <T> Set<T> copyChunkOfMapToSet(
        final String key,
        final Map<String, Set<T>> map)
    {
        Set<T> result = map.get(changeCommaToDollar(key));
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    private <K, V> Map<K, V> copyChunkOfMapToMap(
        final String key,
        final Map<String, Map<K, V>> map)
    {
        Map<K, V> result = map.get(changeCommaToDollar(key));
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    public boolean trustedSoUser(final long uid) {
        return soTrustedUsers.contains(uid);
    }

    public boolean alarmSoUser(final long uid) {
        return soAlarmUsers.contains(uid);
    }

    public boolean trustedSoCoworkers(final long uid) {
        if (soTrustedCoworkers.isEmpty()) {
            logger.log(Level.WARNING, "trustedSoCoworkers: list of coworkers is empty!");
            return false;
        }
        return soTrustedCoworkers.contains(uid);
    }

    private Collection<Long> loadTrustedUsers(final File file) {
        if (file == null) {
            return Collections.emptySet();
        }
        try (BufferedReader reader =
            new BufferedReader(
                new InputStreamReader(
                    new FileInputStream(file),
                StandardCharsets.UTF_8));
            )
        {
            return loadUidsFromBufferedReader(reader);
        } catch (IOException e) {
            logger.log(
                Level.INFO,
                "LoadTrustedUsers: can't load list from file: " + file,
                e);
        }
        return Collections.emptySet();
    }

    private Collection<Long> loadTrustedCoworkers(final String fileName) {
        if (fileName == null) {
            return Collections.emptySet();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(
                Objects.requireNonNull(IexProxy.class.getResourceAsStream(fileName)), StandardCharsets.UTF_8))
            )
        {
            return loadUidsFromBufferedReader(reader);
        } catch (IOException e) {
            logger.log(Level.INFO, "loadTrustedCoworkers: can't load list from file: " + fileName, e);
        }
        return Collections.emptySet();
    }

    private Collection<Long> loadUidsFromBufferedReader(final BufferedReader reader)
        throws IOException
    {
        HashSet<Long> uids = new HashSet<>();
        String line;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            if (line.startsWith("#")
                || line.startsWith(";")
                || line.startsWith("\\\\")
                || line.isEmpty())
            {
                continue;
            }
            try {
                Long uid = Long.parseLong(line);
                uids.add(uid);
            } catch (NumberFormatException e) {
                logger.log(Level.SEVERE, "LoadUids: skipping entry: " + line, e);
            }
        }
        return uids;
    }

    private void loadPatterns(final File whitelist) {
        try (BufferedReader reader =
            new BufferedReader(
                new InputStreamReader(
                    new FileInputStream(whitelist),
                StandardCharsets.UTF_8));
            )
        {
            urlsWhitelistRules = new ArrayList<>();
            String line = null;
            while ((line = reader.readLine()) != null) {
                urlsWhitelistRules.add(java.util.regex.Pattern.compile(line));
            }
        } catch (IOException e) {
            logger.log(
                Level.INFO,
                "IexProxy: can't load patterns from file: "
                    + whitelist,
                e);
            urlsWhitelistRules = Collections.emptyList();
        }
    }

    public boolean isValidWhitelistUrl(final String url) {
        for (java.util.regex.Pattern pattern : urlsWhitelistRules) {
            if (pattern.matcher(url).matches()) {
                return true;
            }
        }
        return false;
    }

    public void loadFiscalRules(final File mediaFiscalFile) {
        if (mediaFiscalFile == null) {
            mediaFiscalRules = Collections.emptyMap();
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(mediaFiscalFile), StandardCharsets.UTF_8));
            )
        {
            mediaFiscalRules = new HashMap<>();
            Properties properties = new Properties();
            properties.load(reader);
            for (String key : properties.stringPropertyNames()) {
                if (properties.get(key).equals("*")) {
                     mediaFiscalRules.put(key, Collections.emptySet());
                } else {
                     String[] domainRules = properties.get(key).toString().trim().split(",");
                     mediaFiscalRules.put(key, new HashSet<>(Arrays.asList(domainRules)));
                }
            }
        } catch (IOException e) {
            logger.log(
                Level.INFO,
                "IexProxy: can't load fiscal rules from file: "
                    + mediaFiscalFile,
                e);
            mediaFiscalRules = Collections.emptyMap();
        }
    }

    public boolean isValidMediaFiscal(final String from, final String body) {
        if (mediaFiscalRules.containsKey(from)) {
            if (mediaFiscalRules.get(from).isEmpty()) {
                return true;
            }
            for (String rule : mediaFiscalRules.get(from)) {
                if (body.contains(rule.trim())) {
                    return true;
                }
            }
        }
        return false;
    }

    public void loadRefundRules(final File refundRulesFile) {
        if (refundRulesFile == null) {
            refundRulesEmail = Collections.emptyMap();
            refundRulesDomain = Collections.emptyMap();
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(refundRulesFile), StandardCharsets.UTF_8));
            )
        {
            refundRulesEmail = new HashMap<>();
            refundRulesDomain = new HashMap<>();
            Properties properties = new Properties();
            properties.load(reader);
            for (String key : properties.stringPropertyNames()) {
                String[] rules = properties.get(key).toString().trim().split(",");
                if (key.contains("@")) {
                    refundRulesEmail.put(key, new RefundSettings(rules));
                } else {
                    refundRulesDomain.put(key, new RefundSettings(rules));
                }
            }
        } catch (IOException e) {
            logger.log(
                Level.INFO,
                "IexProxy: can't load refund rules from file: "
                    + refundRulesFile,
                e);
            refundRulesEmail = Collections.emptyMap();
            refundRulesDomain = Collections.emptyMap();
        }
    }

    public Map<String, RefundSettings> getRefundRulesEmail() {
        return refundRulesEmail;
    }

    public Map<String, RefundSettings> getRefundRulesDomain() {
        return refundRulesDomain;
    }

    public void addToProducerClientSearchMapCounter(final FactsHandler h) {
        producerClientSearchMapCounter.accept(h);
    }

    public void addToProducerClientTotalCounter(final FactsHandler h) {
        producerClientTotalCounter.accept(h);
    }

    public void luceneCompleted(final long timeTaken) {
        luceneCompletions.accept(timeTaken);
    }

    public void filterSearchCompleted(final long timeTaken) {
        filterSearchCompletions.accept(timeTaken);
    }

    public void cokemulatorCompleted(final long timeTaken) {
        cokemulatorCompletions.accept(timeTaken);
    }

    public void producerClientCompleted(final long timeTaken) {
        producerClientCompletions.accept(timeTaken);
    }

    public void addFactsCacheHitRatio(final int cached, final int total) {
        factsCacheHitRatios.accept(new IntegerPair(cached, total));
    }

    public void addActualFactsCacheHitRatio(final int cached, final int total) {
        actualFactsCacheHitRatios.accept(new IntegerPair(cached, total));
    }

    public void addUrlsToRcaAndTotalUrlsCount(
            final int validToRca,
            final int total)
    {
        urlsToRcaAndTotalUrlsCount.accept(new IntegerPair(validToRca, total));
    }

    public void addLucenePureTime(final long timeTaken) {
        lucenePureTimes.accept(timeTaken);
    }

    public void cacheStoreTime(final long time) {
        cacheStoreTimes.accept(time);
    }

    public void axisStoreTime(final long time) {
        axisStoreTimes.accept(time);
    }

    public void mainExtractTime(final long time) {
        mainExtractTimes.accept(time);
    }

    public void attachExtractTime(final long time) {
        attachExtractTimes.accept(time);
    }

    public void postActionsTime(final long time) {
        postActionsTimes.accept(time);
    }

    public void factsSporadicTimerWakeup() {
        factsSporadicTimerWakeup.accept(ONE);
    }

    public void perDcLuceneTime(final long timeTaken, final String host) {
        if (host.startsWith(SAS)) {
            sasLuceneTimes.accept(timeTaken);
        } else if (host.startsWith(MAN)) {
            manLuceneTimes.accept(timeTaken);
        } else if (host.startsWith(MYT)) {
            mytLuceneTimes.accept(timeTaken);
        } else if (host.startsWith(VLA)) {
            vlaLuceneTimes.accept(timeTaken);
        } else {
            otherLuceneTimes.accept(timeTaken);
        }
    }

    public void perDcLuceneAnswerSelected(final String host) {
        if (host.startsWith(SAS)) {
            sasLuceneAnswerSelected.accept(ONE);
        } else if (host.startsWith(MAN)) {
            manLuceneAnswerSelected.accept(ONE);
        } else if (host.startsWith(MYT)) {
            mytLuceneAnswerSelected.accept(ONE);
        } else if (host.startsWith(VLA)) {
            vlaLuceneAnswerSelected.accept(ONE);
        } else {
            otherLuceneAnswerSelected.accept(ONE);
        }
    }

    public void addProducerClientPureTime(final long timeTaken) {
        producerClientPureTimes.accept(timeTaken);
    }

    public void spamComplaints(long count) {
        spamComplaints.accept(count);
    }

    public void trustedSpamComplaints(long count) {
        trustedSpamComplaints.accept(count);
    }

    public void trustedSpamFreshComplaint() {
        trustedSpamFreshComplaints.accept(ONE);
    }

    public void hamComplaints(long count) {
        hamComplaints.accept(count);
    }

    public void trustedHamComplaints(long count) {
        trustedHamComplaints.accept(count);
    }

    public void abusesGetRequestsStater() {
        abusesGetRequestsStater.accept(ONE);
    }

    public void abusesPutRequestsStater(long count) {
        abusesPutRequestsStater.accept(count);
    }

    public void imageDownloadRequest() {
        imageDownloadRequests.accept(ONE);
    }

    public void imageDownloadFailed() {
        imageDownloadFails.accept(ONE);
    }

    public void mailImagesDownloaded(final long selectedChanged) {
        midImagesDownloaded.accept(selectedChanged);
    }

    public void imagesMidDownloadTimes(final long timeTaken) {
        imagesMidDownloadTimes.accept(timeTaken);
    }

    public void raspRequestCompleted(final boolean isResponseEmpty) {
        if (isResponseEmpty) {
            raspRequestCompletions.accept(ONE);
        } else {
            raspRequestCompletions.accept(ZERO);
        }
    }

    public void rcaRequestCompleted(final boolean isResponseEmpty) {
        if (isResponseEmpty) {
            rcaRequestCompletions.accept(ONE);
        } else {
            rcaRequestCompletions.accept(ZERO);
        }
    }

    public RequestsStater rcaRequestsStater() {
        return rcaRequestsStater;
    }

    public void taksaRequestCompleted(final boolean isResponseEmpty) {
        if (isResponseEmpty) {
            taksaRequestCompletions.accept(ONE);
        } else {
            taksaRequestCompletions.accept(ZERO);
        }
    }

    public void requestWithTypesParam(final boolean includedUnknown) {
        if (includedUnknown) {
            requestsWithTypesParamCounter.accept(ONE);
        } else {
            requestsWithTypesParamCounter.accept(ZERO);
        }
    }

    public void rcptUidStoreEvent(final long uid) {
        if (rcptUidStoreSignals.containsKey(uid)) {
            rcptUidStoreSignals.get(uid).accept(ONE);
        }
    }

    public Map<Long, TimeFrameQueue<Long>> rcptUidStoreSignals() {
        return rcptUidStoreSignals;
    }

    public void calendarLogParsingFailed() {
        calendarLogParsingFails.accept(ONE);
    }

    public RequestsStater raspRequestsStater() {
        return raspRequestsStater;
    }

    public RequestsStater geoRequestsStater() {
        return geoRequestsStater;
    }

    public void reportForward(final String stat) {
        reportedForwards.accept(stat);
    }

    public void processingLag(final long start, final long end) {
        processingLagStater.accept(
            new RequestInfo(end, 0, start, start, 0L, 0L));
    }

    private static <E extends Exception> void statCount(
        final StatsConsumer<? extends E> statsConsumer,
        final TimeFrameQueue<Long> queue,
        final String prefix)
        throws E
    {
        int count = 0;
        Iterator<Long> iter = queue.iterator();
        while (iter.hasNext()) {
            iter.next();
            count++;
        }
        statsConsumer.stat(prefix + "-count_ammm", count);
        statsConsumer.stat(prefix + "-count_ammv", count);
    }

    // CSOFF: MagicNumber
    private static <E extends Exception> void statTimings(
        final StatsConsumer<? extends E> statsConsumer,
        final TimeFrameQueue<Long> queue,
        final String prefix)
        throws E
    {
        int[] luceneBoundaries = {10, 20, 30, 50, 75, 90, 100, 300, 600,
            1200, 3000};
        long[] luceneTimeDistribution = new long[luceneBoundaries.length + 1];
        int luceneTimeCounter = 0;
        loopLuceneTimes:
        for (long time: queue) {
            luceneTimeCounter++;
            for (int boundaryNumber = 0;
                    boundaryNumber < luceneBoundaries.length;
                    ++boundaryNumber)
            {
                if (time < luceneBoundaries[boundaryNumber]) {
                    ++luceneTimeDistribution[boundaryNumber];
                    continue loopLuceneTimes;
                }
            }
            ++luceneTimeDistribution[luceneBoundaries.length];
        }
        for (int i = 0; i < luceneBoundaries.length; ++i) {
            statsConsumer.stat(
                prefix + "-time-less-" + luceneBoundaries[i] + MS_AMMM,
                luceneTimeDistribution[i]);
        }
        statsConsumer.stat(
            prefix + "-time-greater-"
            + luceneBoundaries[luceneBoundaries.length - 1] + MS_AMMM,
            luceneTimeDistribution[luceneTimeDistribution.length - 1]);
        statsConsumer.stat(prefix + "-times-counter_ammm", luceneTimeCounter);
    }
    // CSON: MagicNumber

    private static class IntegerPair {
        private int first;
        private int second;

        IntegerPair(final int first, final int second) {
            this.first = first;
            this.second = second;
        }

        public int first() {
            return first;
        }

        public int second() {
            return second;
        }
    }

    class UserOnlineCallback
        implements FutureCallback<HttpResponse>
    {
        private final long prefix;
        private final ProxySession session;

        UserOnlineCallback(
            final long prefix,
            final ProxySession session)
        {
            this.prefix = prefix;
            this.session = session;
        }

        @Override
        public void cancelled() {
        }

        @Override
        public void failed(final Exception e) {
            session.logger().info(
                USER_CHPOCK + prefix + "> online check failed");
        }

        @Override
        public void completed(final HttpResponse result) {
            if (result != null) {
                final HeadersParser headers = new HeadersParser(result);
                boolean online =
                    headers.getString("Status", "Offline").equals("Online");
                if (online) {
                    session.logger().info(USER_CHPOCK + prefix + "> is online");
                    if (config().enlarge()) {
                        enlarge();
                    }
                } else {
                    session.logger().info(
                        USER_CHPOCK + prefix + "> is offline");
                }
            }
        }

        @SuppressWarnings("FutureReturnValueIgnored")
        private void enlarge() {
            final AsyncClient msearchClient =
                msearchClient().adjust(session.context());
            final BasicAsyncRequestProducerGenerator request =
                new BasicAsyncRequestProducerGenerator(
                    "/api/async/enlarge/your?uid=" + prefix);
            msearchClient.execute(
                config().msearchConfig().host(),
                request,
                EmptyAsyncConsumerFactory.INSTANCE,
                session.listener().
                    createContextGeneratorFor(onlineDBClient),
                EmptyFutureCallback.INSTANCE);
        }
    }

    private class TimingsStater implements Stater {
        // CSOFF: MagicNumber
        // CSOFF: MethodLength
        @Override
        public <E extends Exception> void stats(
            final StatsConsumer<? extends E> statsConsumer)
            throws E
        {
            long[] cacheHitRatios = new long[7];
            int[] boundaries = {50, 75, 90, 95, 99};
            int entitiesCounter = 0;
            int cachedMidsCounter = 0;
            int totalMidsCounter = 0;
            loopRatios:
            for (IntegerPair counters: factsCacheHitRatios) {
                entitiesCounter++;
                cachedMidsCounter += counters.first();
                totalMidsCounter += counters.second();
                for (int boundaryNumber = 0; boundaryNumber < boundaries.length;
                        ++boundaryNumber)
                {
                    if (counters.first() == counters.second()) {
                        cacheHitRatios[6]++;
                        continue loopRatios;
                    }
                    if (counters.first() * PERC / counters.second()
                            < boundaries[boundaryNumber])
                    {
                        cacheHitRatios[boundaryNumber]++;
                        continue loopRatios;
                    }
                }
                cacheHitRatios[5]++;
            }
            String[] prefixes = {
                "less-0.5",
                "less-0.75",
                "less-0.90",
                "less-0.95",
                "less-0.99",
                "greater-0.99",
                "equals-1.0"};
            for (int i = 0; i < cacheHitRatios.length; ++i) {
                statsConsumer.stat(
                    StringUtils.concat(
                        prefixes[i],
                        "-facts-cache-hit-ratio_ammm"),
                    cacheHitRatios[i]);
            }
            statsConsumer.stat(
                "total-facts-requests-counter_ammm",
                entitiesCounter);
            statsConsumer.stat(
                "cached-facts-mids-counter_ammm",
                cachedMidsCounter);
            statsConsumer.stat(
                "total-facts-mids-counter_ammm",
                totalMidsCounter);
            int actualCachedMidsCounter = 0;
            int actualTotalMidsCounter = 0;
            for (IntegerPair counters: actualFactsCacheHitRatios) {
                actualCachedMidsCounter += counters.first();
                actualTotalMidsCounter += counters.second();
            }
            statsConsumer.stat(
                "actual-cached-facts-mids-counter_ammm",
                actualCachedMidsCounter);
            statsConsumer.stat(
                "actual-total-facts-mids-counter_ammm",
                actualTotalMidsCounter);

            int urlsToRcaCounter = 0;
            int totalUrlsCounter = 0;
            for (IntegerPair counters: urlsToRcaAndTotalUrlsCount) {
                urlsToRcaCounter += counters.first();
                totalUrlsCounter += counters.second();
            }
            statsConsumer.stat(
                "people-urls-to-rca-counter_ammm",
                urlsToRcaCounter);
            statsConsumer.stat(
                "total-people-urls-counter_ammm",
                totalUrlsCounter);

            statTimings(statsConsumer, lucenePureTimes, "lucene");
            statTimings(statsConsumer, sasLuceneTimes, "sas-lucene");
            statTimings(statsConsumer, manLuceneTimes, "man-lucene");
            statTimings(statsConsumer, mytLuceneTimes, "myt-lucene");
            statTimings(statsConsumer, vlaLuceneTimes, "vla-lucene");
            statTimings(statsConsumer, otherLuceneTimes, "other-lucene");

            statCount(
                statsConsumer,
                sasLuceneAnswerSelected,
                "sas-lucene-answer-selected");
            statCount(
                statsConsumer,
                manLuceneAnswerSelected,
                "man-lucene-answer-selected");
            statCount(
                statsConsumer,
                mytLuceneAnswerSelected,
                "myt-lucene-answer-selected");
            statCount(
                statsConsumer,
                vlaLuceneAnswerSelected,
                "vla-lucene-answer-selected");
            statCount(
                statsConsumer,
                otherLuceneAnswerSelected,
                "other-lucene-answer-selected");

            statCount(
                statsConsumer,
                factsSporadicTimerWakeup,
                "facts-sporadic-timer-wakeup");

            statTimings(statsConsumer, cacheStoreTimes, "cache-store");
            statTimings(statsConsumer, axisStoreTimes, "axis-store");
            statTimings(statsConsumer, mainExtractTimes, "main-extract");
            statTimings(statsConsumer, attachExtractTimes, "attach-extract");
            statTimings(statsConsumer, postActionsTimes, "postactions");
            statTimings(statsConsumer, imagesMidDownloadTimes, "imagedownload");

            int[] producerClientBoundaries = {10, 20, 30, 50, 75, 90, 100, 300};
            long[] producerClientTimeDistribution =
                new long[producerClientBoundaries.length + 1];
            int producerClientTimeCounter = 0;
            loopProducerClientTimes:
            for (long time: producerClientPureTimes) {
                producerClientTimeCounter++;
                for (int boundaryNumber = 0;
                        boundaryNumber < producerClientBoundaries.length;
                        ++boundaryNumber)
                {
                    if (time < producerClientBoundaries[boundaryNumber]) {
                        ++producerClientTimeDistribution[boundaryNumber];
                        continue loopProducerClientTimes;
                    }
                }
                ++producerClientTimeDistribution[
                    producerClientBoundaries.length];
            }
            for (int i = 0; i < producerClientBoundaries.length; ++i) {
                statsConsumer.stat(
                    "producerClient-time-less-" + producerClientBoundaries[i]
                    + MS_AMMM,
                    producerClientTimeDistribution[i]);
            }
            statsConsumer.stat(
                "producerClient-time-greater-"
                + producerClientBoundaries[producerClientBoundaries.length - 1]
                + MS_AMMM,
                producerClientTimeDistribution[
                    producerClientTimeDistribution.length - 1]);
            statsConsumer.stat(
                "producerClient-times-counter_ammm",
                producerClientTimeCounter);
        }
        // CSON: MagicNumber
        // CSON: MethodLength
    }
}
