package ru.yandex.iex.proxy;

import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.geocoder.GeocoderConfig;
import ru.yandex.http.config.FilterSearchConfig;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.URIConfig;
import ru.yandex.iex.proxy.afisha.config.InterfaceAfishaConfig;
import ru.yandex.iex.proxy.complaints.ComplaintsConfig;
import ru.yandex.iex.proxy.config.SmartObjectConfig;
import ru.yandex.iex.proxy.images.ZoraProxyClientConfig;
import ru.yandex.iex.proxy.xiva.XivaConfig;
import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.mail.received.ReceivedChainParserConfig;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfig;
import ru.yandex.stater.StaterConfig;

public interface IexProxyConfig extends UniversalSearchProxyConfig {
    HttpHostConfig cokemulatorIexlibConfig();

    HttpHostConfig msalConfig();

    HttpHostConfig corpMsalConfig();

    HttpHostConfig raspConfig();

    StaterConfig raspStaterConfig();

    HttpHostConfig refundConfig();

    HttpHostConfig marketConfig();

    HttpHostConfig bkConfig();

    HttpHostConfig mediaConfig();

    HttpHostConfig gettextConfig();

    HttpHostConfig gatemailConfig();

    HttpHostConfig msearchConfig();

    HttpHostConfig onlineDBConfig();

    HttpHostConfig reminderConfig();

    GeocoderConfig geoSearchConfig();

    StaterConfig geoStaterConfig();

    InterfaceAfishaConfig afishaConfig();

    URIConfig iexConfig();

    Tvm2ClientConfig tvm2ClientConfig();

    HttpHostConfig blackboxConfig();

    HttpHostConfig corpBlackboxConfig();

    HttpHostConfig blackboxDirectConfig();

    HttpHostConfig calendarConfig();

    HttpHostConfig calendarToolsConfig();

    HttpHostConfig corovaneerConfig();

    HttpHostConfig kinopoiskQlConfig();

    HttpTargetConfig postProcessConfig();

    HttpHostConfig tikaiteConfig();

    HttpHostConfig tikaiteMlConfig();

    HttpHostConfig mulcagateConfig();

    HttpHostConfig knnConfig();

    HttpHostConfig mopsConfig();

    HttpHostConfig corpMopsConfig();

    ComplaintsConfig complaintsConfig();

    URIConfig complaintsCoworkersSelectionConfig();

    URIConfig sologgerConfig();

    URIConfig freemailConfig();

    URIConfig settingsApiConfig();

    URIConfig corpSettingsApiConfig();

    SmartObjectConfig smartObjectConfig();

    ZoraProxyClientConfig zoraProxyConfig();

    URIConfig axisConfig();

    URIConfig rcaURIConfig();

    StaterConfig rcaStaterConfig();

    URIConfig factsExtractURIConfig();

    FilterSearchConfig filterSearchConfig();

    FilterSearchConfig corpFilterSearchConfig();

    URIConfig foldersConfig();

    URIConfig corpFoldersConfig();

    URIConfig labelsConfig();

    URIConfig corpLabelsConfig();

    URIConfig attachSidConfig();

    URIConfig corpAttachSidConfig();

    IexForwardersConfig forwardersConfig();

    Pattern mdbs();

    Long maxRetries();

    Long almostAllFactsTimeout();

    /**
     * Before sending request to taksa, we should wait while
     * rextracted facts will be indexed by backends
     */
    Long factsExtractIndexationWaitTimeout();

    String slowQueueName();

    String factsIndexingQueueName();

    String xIndexOperationQueueNameFacts();

    String xIndexOperationQueueNameBacklog();

    String xIndexOperationQueueNameUpdate();

    String axisQueueName();

    String mailSearchQueueName();

    String corpMailSearchQueueName();

    HttpHostConfig producerAsyncClientConfig();

    HttpHostConfig soProducerConfig();

    LoggerConfig reqresLog();

    LoggerConfig sobbYtLog();

    IniConfig extraSettingsConfig() throws ConfigException, IOException;

    IniConfig headersSection();

    IniConfig headersDomainSection();

    IniConfig entitiesSection();

    IniConfig postProcessSection();

    IniConfig entitiesEmailSection();

    IniConfig entitiesRcptEmailSection();

    IniConfig postProcessEmailSection();

    IniConfig postProcessRcptEmailSection();

    IniConfig entitiesRcptUidSection();

    IniConfig postProcessRcptUidSection();

    IniConfig rcptUidRuleSections();

    IniConfig entitiesDomainSection();

    IniConfig postProcessDomainSection();

    IniConfig rcptUidStoreSignalsSection();

    IniConfig entitiesTimeStamps() throws ConfigException, IOException;

    IniConfig urlsWhitelistRegexp();

    IniConfig mediaFiscalsProperties();

    IniConfig refundSendersProperties();

    Set<String> factNamesToEraseFactData();

    XivaConfig xivaConfig();

    XivaConfig xivaCorpConfig();

    HttpHostConfig taksaConfig();

    HttpHostConfig taksaTestingConfig();

    HttpHostConfig neuroHardsConfig();

    ReceivedChainParserConfig receivedChainParserConfig();

    String blackboxTvmClientId();

    String corpBlackboxTvmClientId();

    String tikaiteTvmClientId();

    String unistorageTvmClientId();

    String geoTvmClientId();

    String afishaTvmClientId();

    String kinopoiskTvmClientId();

    String filterSearchTvmClientId();

    String corpFilterSearchTvmClientId();

    String foldersTvmClientId();

    String corpFoldersTvmClientId();

    String labelsTvmClientId();

    String corpLabelsTvmClientId();

    String attachSidTvmClientId();

    String corpAttachSidTvmClientId();

    String taksaTvmClientId();

    String calendarTvmClientId();

    String calendarToolsTvmClientId();

    String corovaneerTvmClientId();

    String mopsTvmClientId();

    String corpMopsTvmClientId();

    String settingsApiTvmClientId();

    String corpSettingsApiTvmClientId();

    String soService();

    boolean enlarge();

    JniWrapperConfig unpersonConfig();
}

