package ru.yandex.iex.proxy;

import java.io.IOException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class IexProxyConfigBuilder
        extends AbstractIexProxyConfigBuilder<IexProxyConfigBuilder>
{
    public IexProxyConfigBuilder() {
        super(IexProxyConfigDefaults.INSTANCE);
    }

    public IexProxyConfigBuilder(final IexProxyConfig config) {
        super(config);
    }

    public IexProxyConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, IexProxyConfigDefaults.INSTANCE);
    }

    public IexProxyConfigBuilder(final IniConfig config, final IexProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public IexProxyConfigBuilder self() {
        return this;
    }

    public ImmutableIexProxyConfig build()
        throws ConfigException, IOException
    {
        return new ImmutableIexProxyConfig(this);
    }
}
