package ru.yandex.iex.proxy;

import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;
import ru.yandex.geocoder.GeocoderConfigDefaults;
import ru.yandex.http.config.FilterSearchConfigDefaults;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.HttpTargetConfigDefaults;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigDefaults;
import ru.yandex.iex.proxy.afisha.config.AfishaConfigDefauls;
import ru.yandex.iex.proxy.complaints.ComplaintsConfig;
import ru.yandex.iex.proxy.complaints.ComplaintsConfigDefaults;
import ru.yandex.iex.proxy.config.SmartObjectConfig;
import ru.yandex.iex.proxy.config.SmartObjectConfigDefaults;
import ru.yandex.iex.proxy.images.ZoraProxyClientConfig;
import ru.yandex.iex.proxy.images.ZoraProxyClientConfigDefaults;
import ru.yandex.iex.proxy.xiva.XivaConfigDefaults;
import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapperConfigDefaults;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.logger.LoggerFileConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.mail.received.ReceivedChainParserConfig;
import ru.yandex.parser.mail.received.ReceivedChainParserConfigDefaults;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfigDefaults;
import ru.yandex.stater.StaterConfigDefaults;

public class IexProxyConfigDefaults extends UniversalSearchProxyConfigDefaults implements IexProxyConfig
{
    public static final IexProxyConfigDefaults INSTANCE = new IexProxyConfigDefaults();

    private static final long DEFAULT_FACTS_TIMEOUT = 95L;
    private static final long DEFAULT_FACTS_EXTRACT_TIMEOUT = 10000L;

    protected IexProxyConfigDefaults() {
    }

    @Override
    public String name() {
        return "Iex-proxy";
    }

    @Override
    public HttpHostConfigDefaults cokemulatorIexlibConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults msalConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults corpMsalConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults raspConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public StaterConfigDefaults raspStaterConfig() {
        return StaterConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults refundConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults marketConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults bkConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults mediaConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults gettextConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults gatemailConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults msearchConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults onlineDBConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults calendarConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults calendarToolsConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults corovaneerConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults kinopoiskQlConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults reminderConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public GeocoderConfigDefaults geoSearchConfig() {
        return GeocoderConfigDefaults.INSTANCE;
    }

    @Override
    public StaterConfigDefaults geoStaterConfig() {
        return StaterConfigDefaults.INSTANCE;
    }

    @Override
    public AfishaConfigDefauls afishaConfig() {
        return AfishaConfigDefauls.INSTANCE;
    }

    @Override
    public URIConfig iexConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public Tvm2ClientConfig tvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults blackboxConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults corpBlackboxConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults blackboxDirectConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpTargetConfigDefaults postProcessConfig() {
        return HttpTargetConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults tikaiteConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults tikaiteMlConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults mulcagateConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig axisConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public ComplaintsConfig complaintsConfig() {
        return ComplaintsConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig complaintsCoworkersSelectionConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig sologgerConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig freemailConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig settingsApiConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig corpSettingsApiConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig rcaURIConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public StaterConfigDefaults rcaStaterConfig() {
        return StaterConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig factsExtractURIConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public FilterSearchConfigDefaults filterSearchConfig() {
        return FilterSearchConfigDefaults.INSTANCE;
    }

    @Override
    public FilterSearchConfigDefaults corpFilterSearchConfig() {
        return FilterSearchConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig foldersConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig corpFoldersConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig labelsConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig corpLabelsConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig attachSidConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig corpAttachSidConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults producerAsyncClientConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults soProducerConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults knnConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults mopsConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults corpMopsConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public Pattern mdbs() {
        return Pattern.compile(".*");
    }

    @Override
    public Long maxRetries() {
        return null;
    }

    @Override
    public Long almostAllFactsTimeout() {
        return DEFAULT_FACTS_TIMEOUT;
    }

    @Override
    public Long factsExtractIndexationWaitTimeout() {
        return DEFAULT_FACTS_EXTRACT_TIMEOUT;
    }

    @Override
    public String slowQueueName() {
        return null;
    }

    @Override
    public String axisQueueName() {
        return null;
    }

    @Override
    public String factsIndexingQueueName() {
        return null;
    }

    @Override
    public String xIndexOperationQueueNameFacts() {
        return "iex_facts";
    }

    @Override
    public String xIndexOperationQueueNameBacklog() {
        return "iex_backlog";
    }

    @Override
    public String xIndexOperationQueueNameUpdate() {
        return "iex_update";
    }

    @Override
    public String mailSearchQueueName() {
        return "change_log";
    }

    @Override
    public String corpMailSearchQueueName() {
        return "corp_change_log";
    }

    @Override
    public LoggerConfig reqresLog() {
        try {
            return new LoggerConfigBuilder()
                .separator(" ")
                .add(
                    new LoggerFileConfigBuilder()
                        .dateFormat("yyyy-MM-dd HH:mm:ss.SSS Z")
                        .logFormat("DEBUG: %{date}%{separator}%{message}"))
                .build();
        } catch (ConfigException e) {
            throw new IllegalStateException("Logger defaults build failed", e);
        }
    }

    @Override
    public LoggerConfig sobbYtLog() {
        try {
            return new LoggerConfigBuilder()
               .add(
                   new LoggerFileConfigBuilder()
                       .logFormat("%{message}"))
               .build();
        } catch (ConfigException e) {
            throw new IllegalStateException("Logger defaults build failed", e);
        }
    }

    @Override
    public IniConfig extraSettingsConfig()
        throws ConfigException, IOException
    {
        return new IniConfig(Paths.get("ini_config_empty"));
    }

    @Override
    public IniConfig headersSection() {
        try {
            return new IniConfig(new StringReader("message-type-43 = rpop-info, message-id-hash"));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default headers by domain section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig headersDomainSection() {
        try {
            return new IniConfig(new StringReader("taxi$yandex$ru = rpop-info"));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default headers section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig entitiesSection() {
        try {
            return new IniConfig(new StringReader("message-type-43 = taxi"));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default entities section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig postProcessSection() {
        try {
            return new IniConfig(new StringReader("message-type-35 = hotels_widget:http://localhost:10306/hotels"));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default postProcess section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig entitiesEmailSection() {
        try {
            return new IniConfig(new StringReader("no-reply@taxi.yandex.ru = micro"));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default email entities section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig postProcessEmailSection() {
        try {
            return new IniConfig(
                new StringReader("no-reply@taxi.yandex.ru = hotels_widget:http://localhost:10306/hotels"));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default email postProcess section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig entitiesRcptEmailSection() {
        try {
            return new IniConfig(new StringReader(""));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default rcpt email entities section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig postProcessRcptEmailSection() {
        try {
            return new IniConfig(new StringReader(""));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default rcpt email postProcess section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig entitiesRcptUidSection() {
        try {
            return new IniConfig(new StringReader(""));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default rcpt uid entities section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig postProcessRcptUidSection() {
        try {
            return new IniConfig(new StringReader(""));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default rcpt uid postProcess section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig rcptUidRuleSections() {
        try {
            return new IniConfig(new StringReader(""));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default rcpt uid bulk rule section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig entitiesDomainSection() {
        try {
            return new IniConfig(new StringReader("taxi.yandex.ru = micro"));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default domain entities section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig postProcessDomainSection() {
        try {
            return new IniConfig(new StringReader("taxi.yandex.ru = hotels:http://localhost:10306/hotels"));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default domain postProcess section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig rcptUidStoreSignalsSection() {
        try {
            return new IniConfig(new StringReader(""));
        } catch (ConfigException | IOException e) {
            throw new IllegalStateException("Default rcpt uid store signals section cannot be instantiated", e);
        }
    }

    @Override
    public IniConfig entitiesTimeStamps() {
        return null;
    }

    @Override
    public IniConfig urlsWhitelistRegexp() {
        return null;
    }

    @Override
    public IniConfig mediaFiscalsProperties() {
        return null;
    }

    @Override
    public IniConfig refundSendersProperties() {
        return null;
    }

    @Override
    public ZoraProxyClientConfig zoraProxyConfig() {
        return ZoraProxyClientConfigDefaults.INSTANCE;
    }

    @Override
    public Set<String> factNamesToEraseFactData() {
        return Collections.emptySet();
    }

    @Override
    public IexForwardersConfig forwardersConfig() {
        return IexForwardersConfigDefaults.INSTANCE;
    }

    @Override
    public XivaConfigDefaults xivaConfig() {
        return XivaConfigDefaults.INSTANCE;
    }

    @Override
    public XivaConfigDefaults xivaCorpConfig() {
        return XivaConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults taksaConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults taksaTestingConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfigDefaults neuroHardsConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public ReceivedChainParserConfig receivedChainParserConfig() {
        return ReceivedChainParserConfigDefaults.INSTANCE;
    }

    @Override
    public String blackboxTvmClientId() {
        return null;
    }

    @Override
    public String corpBlackboxTvmClientId() {
        return null;
    }

    @Override
    public String tikaiteTvmClientId() {
        return null;
    }

    @Override
    public String unistorageTvmClientId() {
        return null;
    }

    @Override
    public String geoTvmClientId() {
        return null;
    }

    @Override
    public String afishaTvmClientId() {
        return null;
    }

    @Override
    public String kinopoiskTvmClientId() {
        return null;
    }

    @Override
    public String filterSearchTvmClientId() {
        return null;
    }

    @Override
    public String corpFilterSearchTvmClientId() {
        return null;
    }

    @Override
    public String foldersTvmClientId() {
        return null;
    }

    @Override
    public String corpFoldersTvmClientId() {
        return null;
    }

    @Override
    public String labelsTvmClientId() {
        return null;
    }

    @Override
    public String corpLabelsTvmClientId() {
        return null;
    }

    @Override
    public String attachSidTvmClientId() {
        return null;
    }

    @Override
    public String corpAttachSidTvmClientId() {
        return null;
    }

    @Override
    public String taksaTvmClientId() {
        return null;
    }

    @Override
    public String calendarTvmClientId() {
        return null;
    }

    @Override
    public String calendarToolsTvmClientId() {
        return null;
    }

    @Override
    public String corovaneerTvmClientId() {
        return null;
    }

    @Override
    public String mopsTvmClientId() {
        return null;
    }

    @Override
    public String corpMopsTvmClientId() {
        return null;
    }

    @Override
    public String settingsApiTvmClientId() {
        return null;
    }

    @Override
    public String corpSettingsApiTvmClientId() {
        return null;
    }

    @Override
    public String soService() {
        return null;
    }

    @Override
    public boolean enlarge() {
        return false;
    }

    @Override
    public JniWrapperConfig unpersonConfig() {
        return JniWrapperConfigDefaults.INSTANCE;
    }

    @Override
    public SmartObjectConfig smartObjectConfig() {
        return SmartObjectConfigDefaults.INSTANCE;
    }
}

