package ru.yandex.iex.proxy;

import java.io.IOException;
import java.net.URISyntaxException;

import org.apache.http.HttpException;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import ru.yandex.http.util.server.HttpServerFactory;
import ru.yandex.jniwrapper.JniWrapperException;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class IexProxyFactory
    implements HttpServerFactory
        <ImmutableIexProxyConfig, HttpAsyncRequestHandler<?>>
{
    @Override
    public String name() {
        return "mail.java.ru.yandex.iex.proxy.IexProxy.IexProxy";
    }

    @Override
    public IexProxy create(final IniConfig config)
        throws ConfigException, IOException
    {
        try {
            return new IexProxy(new IexProxyConfigBuilder(config).build());
        } catch (HttpException
            | JniWrapperException
            | JsonException
            | URISyntaxException e)
        {
            throw new ConfigException("Check the TVM config", e);
        }
    }
}

